#
# Michaeld site plugin definition
#
# Add support for MichaelDVD.com.au site plugin to DVD
#
# Author: Andrew Donkin <ard@waikato.ac.nz>
#

#
# Cleanup
#
DELETE FROM s_site_plugin WHERE site_type = 'michaeld';
DELETE FROM s_site_plugin_conf WHERE site_type = 'michaeld';
DELETE FROM s_site_plugin_input_field WHERE site_type = 'michaeld';
DELETE FROM s_site_plugin_link WHERE site_type = 'michaeld';
DELETE FROM s_site_plugin_s_attribute_type_map WHERE site_type = 'michaeld';
DELETE FROM s_site_plugin_s_attribute_type_lookup_map WHERE site_type = 'michaeld';

INSERT INTO s_site_plugin (site_type, classname, order_no, title, image, description, external_url, items_per_page, more_info_url)
VALUES('michaeld', 'michaeld', 4, 'MichaelD', 'michaeld.png', 'MichaelDVD is the best source of region 2 and 4 DVD information.', 'http://www.michaeldvd.com.au', 25, 'http://www.michaeldvd.com.au/Discs/Disc.asp?ID={michaeldid}');

#
# Input Fields
#	
INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('michaeld', 'title', 1, '', 'Title Search', 'text', '', '{title}');

INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('michaeld', 'michaeldid', 2, '', 'MichaelDVD ID', 'text', '', '{michaeldid}');

#
# Links
#
INSERT INTO s_site_plugin_link(site_type, s_item_type_group, s_item_type, order_no, description, url, title_url)
VALUES('michaeld', '*', '*', 1, 'More Info', 'http://www.michaeldvd.com.au/Discs/Disc.asp?ID={michaeldid}', 'http://www.michaeldvd.com.au/Search/TitleSearch.asp?title={title}');

#
# site variable to s_attribute_type mapping
#
INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('michaeld', 'title', '*', '*', 'ALT_TITLE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('michaeld', 'title', '*', '*', 'S_TITLE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('michaeld', 'blurb', 'VIDEO', '*', 'MOVIE_PLOT');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('michaeld', 'genre', 'VIDEO', '*', 'MOVIEGENRE');

#
# site variable to s_attribute_type_lookup mapping
#
# MichaelD has over 50 categories; we have 20.  These are the ones OpenDb
# is missing (May 2002).
# The following michaeld genre mappings are not defined.
# 'caper', 'childrens','circus','classical','coming-of-age','dance','family','game','imax','mob','new age',
# 'olympics','post apocalyptic','satire','screensaver','sports','surfing','unknown','vampire','various','wrestling'
INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('michaeld', 'MOVIEGENRE', 'anime', 'Animation');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('michaeld', 'MOVIEGENRE', 'black comedy', 'Comedy');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('michaeld', 'MOVIEGENRE', 'bond', 'Action');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('michaeld', 'MOVIEGENRE', 'bond', 'Adventure');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('michaeld', 'MOVIEGENRE', 'claymation', 'Animation');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('michaeld', 'MOVIEGENRE', 'comedy western', 'Comedy');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('michaeld', 'MOVIEGENRE', 'comedy western', 'Western');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('michaeld', 'MOVIEGENRE', 'demo/test', 'Other');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('michaeld', 'MOVIEGENRE', 'disaster', 'Adventure');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('michaeld', 'MOVIEGENRE', 'karaoke', 'Other');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('michaeld', 'MOVIEGENRE', 'martial arts', 'Action');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('michaeld', 'MOVIEGENRE', 'opera', 'Music');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('michaeld', 'MOVIEGENRE', 'romantic comedy', 'Romance');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('michaeld', 'MOVIEGENRE', 'romantic comedy', 'Comedy');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('michaeld', 'MOVIEGENRE', 'science fiction', 'ScienceFiction');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('michaeld', 'MOVIEGENRE', 'star trek', 'ScienceFiction');

####################################################################################################
# Item Type / Attribute Type relationships
####################################################################################################

#
# The attributes.
#
INSERT INTO s_attribute_type (s_attribute_type, description, prompt,input_type, display_type, s_field_type, site_type) 
VALUES ( 'MICHAELDID', 'MichaelD ID','MichaelD ID', 'hidden', 'hidden', NULL, 'michaeld');

# Best Region
INSERT INTO s_attribute_type (s_attribute_type, description, prompt,input_type, display_type, s_field_type, site_type) 
VALUES ( 'MIKER4R1','R4 vs. R1 comparsion', 'Best region', 'textarea(50,3)', 'display(%value%)', NULL, 'michaeld');

# Link to DVD
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no,prompt, compulsory_ind) VALUES ( 'DVD', 'MICHAELDID', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'MIKER4R1', '140',NULL, NULL);