<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/database.php");
include_once("./functions/auth.php");
include_once("./functions/logging.php");

if($CONFIG_VARS['site.enable']!==FALSE)
{
	session_start();
	if(is_opendb_valid_session())
	{
		if(is_user_valid($HTTP_VARS['uid']))
		{
			$page_title = replace_lang_vars(array('user_id'=>$HTTP_VARS['uid'], 'fullname'=>fetch_user_name($HTTP_VARS['uid'])), $LANG_VARS['user_address_for_user_name']);
			echo(_theme_header($page_title));
			echo('<h2>'.$page_title.'</h2>');
			
			$addr_results = fetch_user_address_type_rs($HTTP_VARS['uid'], NULL, TRUE);
			if($addr_results)
			{
				echo("<table border=0 frameborder=0 cellspacing=1 width=50%>");
				while($address_type_r = mysql_fetch_array($addr_results, MYSQL_ASSOC))
				{
					echo('<tr><td colspan=2>&nbsp;</td></tr>');
					echo('<tr><td colspan=2 align=left><div class="navbar" style="text-align:left">- '.$address_type_r['description'].':</div></td></tr>');
					
					$attr_results = fetch_address_type_attribute_type_rs($address_type_r['s_address_type'], $HTTP_SESSION_VARS['user_type'], 'query', TRUE);
					if($attr_results)
					{
						while($addr_attribute_type_r = mysql_fetch_array($attr_results, MYSQL_ASSOC))
						{
							// If display_type == '' AND input_type == 'hidden' we set to 'hidden'
							$display_type = trim($addr_attribute_type_r['display_type']);
							if(strlen($display_type)==0 && strcasecmp(get_function_type(trim($addr_attribute_type_r['input_type'])),'hidden')==0)
							{
								// We allow the get_display_field to handle hidden variable, in case at some stage
								// we might want to change the functionality of 'hidden' to something other than ignore.
								$display_type = 'hidden';
							}
							
							$value = NULL;
							if(is_lookup_attribute_type($addr_attribute_type_r['s_attribute_type']))
							{
								$value = fetch_user_address_lookup_attribute_val(
															$address_type_r['sequence_number'], 
															$addr_attribute_type_r['s_attribute_type'], 
															$addr_attribute_type_r['order_no']);
							}
							else
							{
								
								$value = fetch_user_address_attribute_val(
															$address_type_r['sequence_number'], 
															$addr_attribute_type_r['s_attribute_type'],
															$addr_attribute_type_r['order_no']);
							}
							
							echo(get_display_field(
										$addr_attribute_type_r['s_attribute_type'],
										$addr_attribute_type_r['prompt'],
										$display_type,
										$value));
						}
						mysql_free_result($attr_results);
					}
				}
				mysql_free_result($addr_results);
				echo("\n</table>");
			}
			else
			{
				// no records available / visible
				echo("<div class=\"error\">".$LANG_VARS['no_records_found']."</div>");
			}
			
			if($HTTP_VARS['user_listing_link'] == 'y' && strlen($HTTP_VARS['listing_url_vars'])>0)
			{
				echo format_footer_links(array(array(url=>urldecode($HTTP_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_user_listing'])));
			}
		}
		else
		{
			echo(_theme_header($LANG_VARS['user_address']));
			echo('<h2>'.$LANG_VARS['user_address'].'</h2>');
			
			echo("\n<table cellspacing=1 border=0>");
			echo("\n<form action=\"$PHP_SELF\" method=\"get\">");
			echo("\n<input type=\"hidden\" name=\"op\" value=\"my_history\">");
	
			$results = fetch_user_rs(NULL, 'fullname', 'ASC');
			echo(format_field($LANG_VARS['fullname'], NULL, custom_select('uid', $results, '%fullname% (%user_id%)', 1, $HTTP_SESSION_VARS['user_id'], 'user_id')));
			echo("<tr><td colspan=2 align=left><br><input type=submit value=\"".$LANG_VARS['continue']."\"></td></tr>");
			
			echo("</form>");
			echo("</table>");
		}
	}
	else
	{
		// invalid login, so login instead.
		include("./login.php");
	}
}//if($CONFIG_VARS['site.enable']!==FALSE)
else
{
	echo _theme_header($LANG_VARS['site_is_disabled'], FALSE);
	echo _theme_error($LANG_VARS['site_is_disabled']);
	echo _theme_footer();
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>