<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/database.php");
include_once("./functions/auth.php");
include_once("./functions/logging.php");

include_once("./functions/utils.php");
include_once("./functions/borrowed_item.php");
include_once("./functions/item.php");
include_once("./functions/http.php");
include_once("./functions/fileutils.php");
include_once("./functions/user.php");
include_once("./functions/review.php");
include_once("./functions/item_attribute.php");
include_once("./functions/item_type.php");
include_once("./functions/widgets.php");
include_once("./functions/parseutils.php");
include_once("./functions/site_plugin.php");
include_once("./functions/item_input.php");
include_once("./functions/status_type.php");
include_once("./functions/HTML_Listing.class.inc");

/**
* Will test the old against the new value.
* 
* Assumes that filter_input_field(...) has already
* been called for new_value.
*/
function is_value_refreshed($s_attribute_type, $new_value, $old_value)
{
	// Do the simplest check first!
	if(strlen($old_value)==0 && strlen($new_value)>0)
	{
		return TRUE;
	}
	else
	{
		// they should both be arrays at this point.
		if(is_lookup_attribute_type($s_attribute_type))
		{
			if(is_not_empty_array($old_value) && is_not_empty_array($new_value) && count($old_value) == count($new_value))
			{
				for($i=0; $i<count($old_value); $i++)
				{
					// case insensitive search
					if(array_search2($old_value[$i], $new_value, TRUE)===FALSE)
					{
						return TRUE;
					}
				}
				
				//else
				return FALSE;
			}
			else
			{
				return TRUE;
			}
		}
		else
		{
			if(is_array($new_value)) // multi-value option automatically means a refreshed field
			{
				for($i=0; $i<count($new_value); $i++)
				{
					if(strcmp($new_value[$i], $old_value)!==0)
					{
						return TRUE;
					}
				}
				return FALSE;
			}
			if(strcmp($new_value, $old_value)!==0)
			{
				return TRUE;
			}
			else
			{
				return FALSE;
			}
		}				
	}
}

/*
* Will return a complete TABLE, FORM, including <table ...> <form ...>, </form> and </table>
* 
* @param $confirm_message - If defined this edit form, is a Confirm Action form as well.
* @param $pre_form_block
* @param $post_form_block
*/
function get_edit_form($op, $confirm_message, $parent_item_r, $item_r, $status_type_r, $siat_results, $HTTP_VARS, $HTTP_POST_FILES, $pre_form_block='', $post_form_block='')
{
	global $PHP_SELF;
	global $LANG_VARS;
	global $CONFIG_VARS;
	global $HTTP_SESSION_VARS;
	
	if($siat_results)
	{
		// Work out $op value to submit.
		if($op == 'edit' || $op == 'refresh')
			$op2 = 'update';
		else if($op == 'new' || $op == 'site')
			$op2 = 'insert';
		else
			$op2 = $op; // last resort!
				
		$formContents .= "\n<input type=\"hidden\" name=\"op\" value=\"$op2\">";
		$formContents .= "\n<input type=\"hidden\" name=\"s_item_type\" value=\"".$item_r['s_item_type']."\">";
		
		if(is_not_empty_array($parent_item_r))
		{
			$formContents .= "\n<input type=\"hidden\" name=\"parent_id\" value=\"".$HTTP_VARS['parent_id']."\">";
			$formContents .= "\n<input type=\"hidden\" name=\"parent_instance_no\" value=\"".$HTTP_VARS['parent_instance_no']."\">";
		}
		
		if(is_not_empty_array($item_r))
		{
			if(is_numeric($item_r['item_id']))
				$formContents .= "\n<input type=\"hidden\" name=\"item_id\" value=\"".$item_r['item_id']."\">";
			if(is_numeric($item_r['instance_no']))
				$formContents .= "\n<input type=\"hidden\" name=\"instance_no\" value=\"".$item_r['instance_no']."\">";
		}
		
		// Pass owner_id parameter through
		if(strlen($HTTP_VARS['owner_id'])>0)
		{
			$formContents .= "\n<input type=\"hidden\" name=\"owner_id\" value=\"".$HTTP_VARS['owner_id']."\">";
		}
		
		$formContents .= "\n<input type=\"hidden\" name=\"listing_link\" value=\"".$HTTP_VARS['listing_link']."\">";

		// ------------------- Start inline functions - only used by get_edit_form(...)
		// This function will calculate a field input_field value,
		// based on $HTTP_VARS, $op and $indexes (Used for site operations)
		function get_field_value($op, $item_r, $s_attribute_type, $order_no, $s_field_type, $attribute_val, &$HTTP_VARS, &$HTTP_POST_FILES)
		{
			if($op == 'new')
			{
				return NULL; // No value!
			}
			else if(is_not_empty_array($HTTP_VARS))// Lets try to get field value, from HTTP
			{
				$fieldname = get_field_name($s_attribute_type, $order_no);
				
				// this is not a refresh operation here
				if(!is_array($HTTP_VARS[$fieldname]))
				{
					if(preg_match("/new([0-9]+)/", $HTTP_VARS[$fieldname], $matches) && isset($HTTP_VARS[$fieldname.'_'.$matches[0]]))
					{
						$HTTP_VARS[$fieldname] = $HTTP_VARS[$fieldname.'_'.$matches[0]];
					}
					else if($HTTP_VARS[$fieldname] == 'old')
					{
						// make sure this is a refresh value and not just a field with the value 'old'
						if(isset($HTTP_VARS[$fieldname.'_new1']))
						{
							// Using $item_r value instead.
							unset($HTTP_VARS[$fieldname]);
						}
					}
				}
				
				// If $HTTP_VARS[$fieldname] is set, we have probably come back to
				// edit form, after a failed insert or update.
				if(isset($HTTP_VARS[$fieldname])) // this is NOT a refresh op!!!
				{
					// Is it an upload operation - There is not much we can do in the case of $HTTP_POST_FILEs, as they
					// cannot be cached and passed into next request.  A user would have to re-upload the specific file.
					if(is_array($HTTP_POST_FILES) && is_array($HTTP_POST_FILES[$fieldname])) 
						return NULL;
					else if(is_array($HTTP_POST_FILES) && is_array($HTTP_POST_FILES[$fieldname.'_upload'])) 
						return NULL;
					else if($HTTP_VARS[$fieldname.'_saveurl'] == 'y')
						return $HTTP_VARS[$fieldname];
					else // normal field
						return $HTTP_VARS[$fieldname];
				}
			}
	
			// If no $HTTP_VARS field values found, try normal avenues.
			if($s_field_type == 'STATUSTYPE')
			{
				return $item_r['s_status_type'];
			}
			else if($s_field_type == 'STATUSCMNT')
			{
				return $item_r['status_comment'];
			}
			else if($s_field_type == 'DURATION')
			{
				return $item_r['borrow_duration'];
			}
			else // $op == 'edit'
			{
				if($s_field_type == 'CATEGORY')
				{
					// the category should be an array.
					return trim_explode(' ', $item_r['category']);
				}
				else if($s_field_type == 'TITLE')
				{
					return $item_r['title'];
				}
				else
				{
					return $attribute_val;
				}
			}				
		} //function get_field_value($op, $item_r, $s_attribute_type, $order_no, $s_field_type, $attribute_val)
		
		function get_old_field_value($item_r, $s_field_type, $attribute_val)
		{
			if($s_field_type == 'STATUSTYPE')
			{
				return $item_r['s_status_type'];
			}
			else if($s_field_type == 'STATUSCMNT')
			{
				return $item_r['status_comment'];
			}
			else if($s_field_type == 'DURATION')
			{
				return $item_r['borrow_duration'];
			}
			else if($s_field_type == 'CATEGORY')
			{
				// the category should an array.
				return trim_explode(' ', $item_r['category']);
			}
			else if($s_field_type == 'TITLE')
			{
				return $item_r['title'];
			}
			else
			{
				return $attribute_val;
			}
		}//get_old_field_value($item_r, $s_field_type, $attribute_val)

		// If $old_value !== FALSE, then we will assume a refresh operation and display a
		// special refresh row, if the $new_value is different from the $old_value.
		function get_table_row($op, $s_attribute_type, $order_no, $prompt, $display_type, $input_type, $compulsory_ind, $old_value, $new_value)
		{
			global $LANG_VARS;

			$input_widget_type = get_function_type(trim($input_type));
			$fieldname = get_field_name($s_attribute_type, $order_no);

			// Hidden cannot be involved in a refresh operation directly, but refreshed hidden fields, will still be updated.
			if(strcasecmp($input_widget_type,'hidden')!==0 && 
						$old_value!==FALSE && 
						( is_not_empty_array($new_value) || (!is_array($new_value) && strlen($new_value)>0) ) && 
						is_value_refreshed($s_attribute_type, $new_value, $old_value) &&
						// Do not display 'Old' & 'New' options, if there was NO previous Old value (but $old_field is not FALSE!!!)
						(is_not_empty_array($old_value) || (!is_array($old_value) && strlen($old_value)>0)))
			{
				// -------------
				// REFRESH FIELD
				// -------------
 				// If we are doing a complete refresh block, and display_type is set to 
 				// hidden, overwrite to display it.
 				if(get_function_type($display_type) == 'hidden')
 					$display_type = 'display(%value%)';
 				
 				$field = "<table border=1 width=100%>".
 						"<tr><td width=75 nowrap><input type=radio name=\"".$fieldname."\" value=\"old\">".$LANG_VARS['old_value']."</td>".
 						"<td>".get_display_field($s_attribute_type, $prompt, $display_type, $old_value, FALSE)."</td></tr>";
 				
 				if(!is_lookup_attribute_type($s_attribute_type) && is_not_empty_array($new_value))
 				{
					// remove a new option if it matches the old, but do it here, so we can
					// use the simple CHECKED functionality of comparing $i==0
					for($i=0; $i<count($new_value); $i++)
 					{
						if(strcasecmp($new_value[$i], $old_value) === 0)
							array_splice($new_value, $i, 1);
 					}
					
 					for($i=0; $i<count($new_value); $i++)
 					{
						$field .= "<tr><td><input type=radio name=\"".$fieldname."\" value=\"new".($i+1)."\"".($i==0?" CHECKED":"").">".$LANG_VARS['new_value']."</td>".
								"<td>".get_input_field($fieldname."_new".($i+1), $s_attribute_type, $prompt, $input_type, $compulsory_ind, $new_value[$i], FALSE)."</td></tr>";
 					}
 				}
 				else
 				{
					if(!is_array($new_value))
					{
						// This is the equivalent of an edit operation - so the new_value must be NOT NULL
						// for some widgets to work properly.
						if($new_value === NULL)
						{
							$new_value = '';
						}
					}
					
 					$field .= "<tr><td width=75 nowrap><input type=radio name=\"".$fieldname."\" value=\"new1\" CHECKED>".$LANG_VARS['new_value']."</td>".
 						"<td>".get_input_field($fieldname."_new1", $s_attribute_type, $prompt, $input_type, $compulsory_ind, $new_value, FALSE)."</td></tr>";
 				}
 				
 				$field .= "</table>";
						
				return format_input_field(
					$prompt, 
					NULL,
					$field,
					TRUE,
					_theme_image("rs.gif", NULL, $LANG_VARS['refreshed'])."&nbsp;%prompt%",
					$compulsory_ind);
					
			} // not a refresh field
			else
			{
				if(is_lookup_attribute_type($s_attribute_type))
				{
					// if new_value is empty!
					if(is_empty_or_not_array($new_value))
					{
						if($old_value !== FALSE)
							$value = $old_value;
						else
							$value = NULL;
					}
					else
					{
						$value =& $new_value;
					}
					
					return get_input_field($fieldname, 
							$s_attribute_type, 
							$prompt, 
							$input_type, 
							$compulsory_ind, 
							$value);
				}
				else
				{
					if(is_not_empty_array($new_value))
					{
						$field = "<table border=1 width=100%>";
						for($i=0; $i<count($new_value); $i++)
						{
							$field .= "<tr><td><input type=radio name=\"".$fieldname."\" value=\"new".($i+1)."\"".($i==0?" CHECKED":"")."></td>".
							"<td>".get_input_field($fieldname."_new".($i+1), $s_attribute_type, $prompt, $input_type, $compulsory_ind, $new_value[$i], FALSE)."</td></tr>";
						}
						$field .= "</table>";
						
						return format_input_field(
							$prompt, 
							NULL,
							$field,
							TRUE,
							NULL,
							$compulsory_ind);
					}
					else
					{
						$value = ifempty($new_value, $old_value===FALSE?NULL:$old_value);
				
						// If this is an edit operation - the value must be NOT NULL
						// for some widgets to work properly.
						if($op != 'new' && $op != 'site' && $value === NULL)
						{
							$value = '';
						}
						
						return get_input_field($fieldname, 
							$s_attribute_type, 
							$prompt, 
							$input_type, 
							$compulsory_ind, 
							$value);
					}
				}
			}
		}//get_table_row($s_attribute_type, $order_no, $prompt, $display_type, $input_type, $compulsory_ind, $old_value, $new_value)
		// ------------------- End inline functions - only used by get_edit_form(...)
		
		// is at least one field a compulsory field?
		$compulsory_fields = FALSE;
		
		// Now create the input form
		while($item_attribute_type_r = mysql_fetch_array($siat_results))
		{
			if($item_attribute_type_r['s_field_type'] == 'STATUSTYPE')
			{
				if(!is_array($parent_item_r))
				{
					$fieldname = get_field_name($item_attribute_type_r['s_attribute_type'],$item_attribute_type_r['order_no']);
					$new_value = filter_input_field(
								$item_attribute_type_r['s_attribute_type'], 
								$item_attribute_type_r['input_type'], 
								get_field_value($op, $item_r, $item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no'], $item_attribute_type_r['s_field_type'], $item_attribute_type_r['attribute_val'], $HTTP_VARS, $HTTP_POST_FILES));
					
					// change owner, must change the status of the item, from the 'For Sale' status
					// to the status required of the new owner.
					if($op == 'new' || $op == 'site')
					{
						// A s_status_type was not specified, will choose once in the edit form
						if(strlen($status_type_r['s_status_type'])==0)
							$lookup_results = fetch_newitem_status_type_rs($item_r['owner_id']);
						else
						{
							// Have to pass the hidden s_status_type along to insert process.
							$formContents .= hidden_field(get_field_name($item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no']), $item_r['s_status_type']);
						}
					}
					else if($op == 'change_owner')
					{
						$lookup_results = fetch_update_status_type_rs($item_r['item_id'], $item_r['instance_no'], $item_r['owner_id'], FALSE);
					}
					else
					{
						// If item has borrowed records, then no s_status_type with borrow_ind == 'X' should be included.
						$lookup_results = fetch_update_status_type_rs($item_r['item_id'], $item_r['instance_no'], $item_r['owner_id']);
					}
					
					if($lookup_results && mysql_num_rows($lookup_results)>0)
					{
						$formContents .= format_field($item_attribute_type_r['prompt'], 
													NULL,
													status_type_input_field($fieldname, $lookup_results, $new_value));
					}
				}//Otherwise Linked Item
			}
			else if($item_attribute_type_r['s_field_type'] == 'STATUSCMNT')
			{
				// If $status_type_r['s_status_type'] defined, then the s_status_type has not been specified, so we cannot
				// decide whether to display the status comment field or not.
				if(!is_array($parent_item_r) && (($op != 'new' && $op != 'site') || strlen($status_type_r['s_status_type'])==0 || $status_type_r['status_comment_ind'] == 'Y' || $status_type_r['status_comment_ind'] == 'H'))
				{
					$fieldname = get_field_name($item_attribute_type_r['s_attribute_type'],$item_attribute_type_r['order_no']);
					$new_value = filter_input_field(
									$item_attribute_type_r['s_attribute_type'], 
									$item_attribute_type_r['input_type'], 
									get_field_value($op, $item_r, $item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no'], $item_attribute_type_r['s_field_type'], $item_attribute_type_r['attribute_val'], $HTTP_VARS, $HTTP_POST_FILES));
					
					$formContents .= 
						get_input_field(
							$fieldname,
							$item_attribute_type_r['s_attribute_type'], 
							$item_attribute_type_r['prompt'], 
							$item_attribute_type_r['input_type'], 
							$item_attribute_type_r['compulsory_ind'], 
							ifempty($new_value, $item_r['status_comment']));
				}//Otherwise Linked Item
			}
			else if($item_attribute_type_r['s_field_type'] == 'DURATION')
			{
				if(!is_array($parent_item_r) && (($op != 'new' && $op != 'site') || 
							strlen($status_type_r['s_status_type'])==0 || 
							$status_type_r['borrow_ind']=='Y' || 
							$status_type_r['borrow_ind']=='N'|| 
							$status_type_r['borrow_ind']=='B'))
				{
					$fieldname = get_field_name($item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no']);
					$borrow_duration = ifempty(
									filter_input_field(
											$item_attribute_type_r['s_attribute_type'], 
											$item_attribute_type_r['input_type'], 
											get_field_value($op, $item_r, $item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no'], $item_attribute_type_r['s_field_type'], $item_attribute_type_r['attribute_val'], $HTTP_VARS, $HTTP_POST_FILES)),
									$item_r['borrow_duration']);
					
					// The S_DURATION lookup list will most likely include an 'Undefined' option, that equates
					// to an empty string.  So for Updates, we want to allow for a match, by forcing any NULL
					// value to a empty string.  The reason why we do this, is because the Borrow Duration was
					// probably set to 'Undefined', but because this equated to an empty string, the field was
					// never updated.  We do not take advantage of MySQL recognising difference between NULL
					// and empty string, because other databases do not support this.
					if($op != 'new' && $op != 'site')
					{
						if($borrow_duration === NULL)
							$borrow_duration = '';
					}
									
					$formContents .= 
						get_input_field(
							$fieldname,
							$item_attribute_type_r['s_attribute_type'], 
							$item_attribute_type_r['prompt'], 
							$item_attribute_type_r['input_type'], 
							$item_attribute_type_r['compulsory_ind'], 
							$borrow_duration);
				}//Otherwise Linked Item
			}
			else		
			{
				if($op == 'refresh' || $op == 'edit')
				{
					if(is_lookup_attribute_type($item_attribute_type_r['s_attribute_type']))
						$item_attribute_type_r['attribute_val'] = fetch_lookup_attribute_val_r($item_r['item_id'], $item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no']);
					else
						$item_attribute_type_r['attribute_val'] = fetch_attribute_val($item_r['item_id'], $item_attribute_type_r['s_attribute_type'],  $item_attribute_type_r['order_no']);
				}
				
				if($op=='refresh')
				{
					$old_value = get_old_field_value($item_r, $item_attribute_type_r['s_field_type'], $item_attribute_type_r['attribute_val']);
					$new_value = get_field_value($op, $item_r, $item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no'], $item_attribute_type_r['s_field_type'], $item_attribute_type_r['attribute_val'], $HTTP_VARS, $HTTP_POST_FILES);
					
					if(is_not_empty_array($new_value) && 
							!is_lookup_attribute_type($item_attribute_type_r['s_attribute_type']))
					{
						for($i=0; $i<count($new_value); $i++)
						{
							$new_value[$i] = filter_input_field($item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['input_type'], $new_value[$i]);
						}
					}
					else
					{
						$new_value = filter_input_field($item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['input_type'], $new_value);
						
						// If no HTTP value, especially where FILE UPLOAD is being concerned, attempt to get from database again.
						if($op=='edit' && $new_value === NULL)
						{
							$new_value = get_old_field_value($item_r, $item_attribute_type_r['s_field_type'], $item_attribute_type_r['attribute_val']);
						}
					}
				}
				else //if($op == 'edit' || $op == 'new')
				{
					// No refresh operation.
					$old_value = FALSE;
					
					$new_value = get_field_value($op, $item_r, $item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no'], $item_attribute_type_r['s_field_type'], $item_attribute_type_r['attribute_val'], $HTTP_VARS, $HTTP_POST_FILES);
					
					// we do not want to process input fields separately if they are lookup ones, because
					// the filter process checks 
					if(is_not_empty_array($new_value) && 
							!is_lookup_attribute_type($item_attribute_type_r['s_attribute_type']))
					{
						for($i=0; $i<count($new_value); $i++)
						{
							$new_value[$i] = filter_input_field($item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['input_type'], $new_value[$i]);
						}
					}
					else
					{
						$new_value = filter_input_field($item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['input_type'], $new_value);
						
						// If no HTTP value, especially where FILE UPLOAD is being concerned, attempt to get from database again.
						if($op=='edit' && $new_value === NULL)
						{
							$new_value = get_old_field_value($item_r, $item_attribute_type_r['s_field_type'], $item_attribute_type_r['attribute_val']);
						}
					}
				}
			
				// Enforce compulsory indicator for TITLE.
				if($item_attribute_type_r['s_field_type'] == 'TITLE')
				{
					$item_attribute_type_r['compulsory_ind'] = 'Y';
					
					// Remove any title articles.
					if(is_not_empty_array($CONFIG_VARS['item_input.title_articles']))
					{
						if(is_not_empty_array($new_value))
						{
							for($i=0; $i<count($new_value); $i++)
							{
								$new_value[$i] = trim(format_title_grammar_article($new_value[$i], $CONFIG_VARS['item_input.title_articles']));
							}
						}
						else
						{
							$new_value = trim(format_title_grammar_article($new_value, $CONFIG_VARS['item_input.title_articles']));
						}
					}
				}
				
				$formContents .= 
					get_table_row($op,
						$item_attribute_type_r['s_attribute_type'],
						$item_attribute_type_r['order_no'],
						$item_attribute_type_r['prompt'],
						$item_attribute_type_r['display_type'],
						$item_attribute_type_r['input_type'],
						$item_attribute_type_r['compulsory_ind'],
						$old_value,
						$new_value);
			}
			
			if($item_attribute_type_r['compulsory_ind']=='Y')
			{
				$compulsory_fields = TRUE;
			}
		}//while
		
		// only display the form field rows, do not complete the form definition,
		// as this will be done elsewhere.
		if($complete_form!==FALSE)
		{
			$help_block_r = NULL;
			
			if($op=='refresh')
			{
				$help_block_r[] = array('img'=>'rs.gif','text'=>$LANG_VARS['refreshed']);
			}
			
			if($CONFIG_VARS['widgets.show_prompt_compulsory_ind']!==FALSE && $compulsory_fields!==FALSE)
			{
				$help_block_r[] = array('img'=>'compulsory.gif', 'text'=>$LANG_VARS['compulsory_field']);
			}
			
			if(is_array($help_block_r))
			{
				$formContents .= "\n<tr><td align=left nowrap>".
							format_help_block($help_block_r).
						"</td><td>&nbsp;</td></tr>";
			}
			
			if($CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE)
				$onclick_event = "if(!checkForm(this.form)){return false;}else{this.form.submit();}";
			else
				$onclick_event = "this.form.submit();";
			
			// Add submit button.
			$formContents .= "\n<tr>".
				"<td colspan=2 align=center><br>";
						
			if(strlen($confirm_message)>0)
			{
				$formContents .= "\n<input type=\"hidden\" name=\"confirmed\" value=\"false\">".
					"\n<div class=\"colortext\">".$confirm_message."</div>".
					"\n<input type=\"button\" value=\" ".$LANG_VARS['yes']." \" onclick=\"this.form.confirmed.value='true'; $onclick_event\">&nbsp;".
					"\n<input type=\"button\" value=\" ".$LANG_VARS['no']." \" onclick=\"this.form.confirmed.value='false'; this.form.submit();\">";
			}
			else
			{
				$formContents .= "<input type=\"button\" onclick=\"$onclick_event\" value=\"".$LANG_VARS['save_item']."\">";
			}
			
			$formContents .= "</td>".
						"</tr>";
			
			// Finally - note that get_popup_javascript() is included by get_validation_javascript(), but in the case where
			// javascript validation has been disabled we need to include it manually.
			return ($CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE?get_validation_javascript():get_popup_javascript()).
					"\n<table border=0 frameborder=0 cellspacing=1>".
					(is_file_upload_form() && is_file_upload_enabled()?
						"\n<form action=\"$PHP_SELF\" method=\"post\" enctype=\"multipart/form-data\">":
								"\n<form action=\"$PHP_SELF\" method=\"post\">").
					$pre_form_block. //usually be null
					$formContents.
					$post_form_block. //  //usually be null
					"\n</form>".
					"\n</table>";
		}
		else
		{
			// do not return a complete form, but only the rows themselves
			return $formContents;
		}
	}
	else // We have nothing to display in this case!
	{
		return NULL;
	}
}

/*
* Will validate that edit/refresh can proceed for the $HTTP_SESSION_VARS['user_id'], and will then
* build the edit form, by calling get_edit_form.  If get_edit_form, returns
* a NOT NULL, value then the complete get_edit_form block will be returned,
* otherwise this function returns false.
*/
function handle_edit_or_refresh($op, $parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $HTTP_POST_FILES, &$errors)
{
	global $LANG_VARS;
	global $HTTP_SESSION_VARS;
	
	// If $parent_item_r defined, then the test for parent ownership is sufficient!
	if(is_not_empty_array($parent_item_r) || 
			is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) || 
			$item_r['owner_id'] == $HTTP_SESSION_VARS['user_id'])
	{
		if(is_empty_array($parent_item_r) || 
				is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) || 
				$parent_item_r['owner_id'] == $HTTP_SESSION_VARS['user_id'])
		{
			$results = fetch_item_attribute_type_rs($item_r['s_item_type'], TRUE, TRUE);
			$formContents = get_edit_form($op, NULL, $parent_item_r, $item_r, $status_type_r, $results, $HTTP_VARS, $HTTP_POST_FILES);
			if($formContents != NULL)
				return $formContents;
			else
			{
				$errors = array('error'=>$LANG_VARS['undefined_error'],detail=>'');
				return FALSE;
			}
		}
		else
		{
			$errors = array('error'=>$LANG_VARS['cannot_edit_item_not_owned'],detail=>'');
			opendb_log("Attempted to edit linked item for parent item they do not own (item_id=".$item_r['item_id'].", parent_id=".$parent_item_r['item_id'].",parent_instance_no=".$parent_item_r['instance_no'].", update_who=".$HTTP_SESSION_VARS['user_id'].")");
			return FALSE;
		}
	}
	else
	{
		$errors = array('error'=>$LANG_VARS['cannot_edit_item_not_owned'],detail=>'');
		opendb_log("Attempted to edit item instance they do not own (item_id=".$item_r['item_id'].",instance_no=".$item_r['instance_no'].", update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return FALSE;
	}
}

/*
* Will validate that new/site can proceed for the $HTTP_SESSION_VARS['user_id'], and will then
* build the edit form, by calling get_edit_form.  If get_edit_form, returns
* a NOT NULL, value then the complete get_edit_form block will be returned,
* otherwise this function returns false.
*/
function handle_new_or_site($op, $parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $HTTP_POST_FILES, &$errors)
{
	global $LANG_VARS;
	global $CONFIG_VARS;
	global $HTTP_SESSION_VARS;
	
	if( is_not_empty_array($parent_item_r) || 
			(is_user_allowed_to_own($item_r['owner_id']) && (
				$item_r['owner_id'] == $HTTP_SESSION_VARS['user_id'] || 
				is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))) )
	{
		if(is_empty_array($parent_item_r) || 
				is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) || 
				$parent_item_r['owner_id'] == $HTTP_SESSION_VARS['user_id'])
		{
			if(is_empty_array($parent_item_r) || $CONFIG_VARS['item_input.linked_item_support']!==FALSE)
			{
				// No parent, or parent and child same type, or allowed to have separate types.
				if(is_empty_array($parent_item_r) || $CONFIG_VARS['item_input.link_same_type_only']!==TRUE || $parent_item_r['s_item_type'] == $item_r['s_item_type'])
				{
					// Before trying to insert items into this structure, first ensure it is valid.
					if(is_valid_item_type_structure($item_r['s_item_type']))
					{
						if(is_not_empty_array($parent_item_r) || is_newitem_status_type_valid($item_r['owner_id'], $status_type_r, $errors))
						{
							$results = fetch_item_attribute_type_rs($item_r['s_item_type'], TRUE, TRUE);
							$formContents = get_edit_form($op, NULL, $parent_item_r, $item_r, $status_type_r, $results, $HTTP_VARS, $HTTP_POST_FILES);
							if($formContents != NULL)
								return $formContents;
							else
							{
								$errors = array('error'=>$LANG_VARS['undefined_error'],detail=>'');
								return FALSE;
							}
						}
						else //if(is_not_empty_array($parent_item_r) || is_status_type_insert_valid($item_r['item_id'], $HTTP_SESSION_VARS['user_id'], $status_type_r, $errors))
						{
							return FALSE;
						}
					}
					else//if(is_valid_item_type_structure($item_r['s_item_type']))
					{
						$errors = array('error'=>replace_lang_var("s_item_type", $item_r['s_item_type'], $LANG_VARS['invalid_item_type_structure']),'detail'=>'');
	
						// An error like this is a big problem, and should be dealt with quickly, but there is no sense in alarming the
						// user by sending back an error.
						opendb_log("Experienced a problem with a system item type.  Either it does not exist, or there is an error in its structure. (s_item_type=".$item_r['s_item_type'].", update_who=".$HTTP_SESSION_VARS['user_id'].")");
						return FALSE;
					}					
				}
				else
				{
					$errors = array('error'=>replace_lang_var("s_item_type", $parent_item_r['s_item_type'], $LANG_VARS['linked_item_must_be_type']),'detail'=>'');
					return FALSE;
				}
			}
			else
			{
				$errors = array('error'=>$LANG_VARS['linked_items_not_supported'],detail=>'');
				return FALSE;
			}
		}
		else
		{
			$errors = array('error'=>$LANG_VARS['cannot_edit_item_not_owned'],detail=>'');
			opendb_log("Attempted to add new linked item for parent item they do not own (parent_id=".$parent_item_r['item_id'].", parent_instance_no=".$parent_item_r['instance_no'].", update_who=".$HTTP_SESSION_VARS['user_id'].")");
			return FALSE;
		}
	}// non-admin user attempting to insert item for someone else.
	else
	{
		$errors = array('error'=>$LANG_VARS['operation_not_available']);
		opendb_log("Non admin user attempted to insert an item for another user. (update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return FALSE;
	}
}

/*
* Will validate that edit/refresh can proceed for the $HTTP_SESSION_VARS['user_id'], and will then
* build the edit form, by calling get_edit_form.  If get_edit_form, returns
* a NOT NULL value then the complete get_edit_form block will be returned,
* otherwise this function returns false.
*/
function handle_confirm_item_instance_update($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, &$errors)
{
	global $LANG_VARS;
	global $HTTP_SESSION_VARS;
	
	// Linked item has no item instance
	if(is_empty_array($parent_item_r))
	{
		if(is_not_empty_array($item_r))
		{
			if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) || $item_r['owner_id'] == $HTTP_SESSION_VARS['user_id'])
			{
				$results = fetch_sfieldtype_item_attribute_type_rs($item_r['s_item_type'], array('STATUSTYPE','STATUSCMNT','DURATION'), TRUE, TRUE);
				$formContents = get_edit_form(
							$HTTP_VARS['op'], 
							$LANG_VARS['confirm_item_instance_update'], 
							$parent_item_r, //$parent_item_r is empty at this stage!!!
							$item_r, 
							$status_type_r, 
							$results, 
							$HTTP_VARS, 
							$dummy_post_file);
							
				if($formContents != NULL)
					return $formContents;
				else
				{
					$errors = array('error'=>$LANG_VARS['undefined_error'], detail=>'');
					return FALSE;
				}
			}
			else
			{
				$errors = array('error'=>$LANG_VARS['cannot_edit_item_not_owned'],detail=>'');
				opendb_log("Attempted to edit item instance they do not own (item_id=".$item_r['item_id'].", instance_no=".$item_r['instance_no'].", update_who=".$HTTP_SESSION_VARS['user_id'].")");
				return FALSE;
			}
		}
		else//if(is_not_empty_array($item_r))
		{
			$errors = array('error'=>$LANG_VARS['item_not_found'],'detail'=>'');
			return FALSE;
		}
	}
	else//if(is_empty_array($parent_item_r))
	{
		$errors = array('error'=>$LANG_VARS['operation_not_available'],'detail'=>'');
		return FALSE;
	}
}

/*
* Will validate that edit/refresh can proceed for the $HTTP_SESSION_VARS['user_id'], and will then
* build the edit form, by calling get_edit_form.  If get_edit_form, returns
* a NOT NULL value then the complete get_edit_form block will be returned,
* otherwise this function returns false.
*/
function handle_confirm_item_instance_change_owner($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, &$errors)
{
	global $PHP_SELF;
	global $LANG_VARS;
	global $HTTP_SESSION_VARS;
	
	if($CONFIG_VARS['item_input.item_instance_support']!==FALSE && $CONFIG_VARS['item_input.change_owner_supported']!==FALSE)
	{
		if(is_empty_array($parent_item_r))
		{
			$HTTP_VARS['owner_id'] = ifempty($HTTP_VARS['owner_id'], $HTTP_SESSION_VARS['user_id']);
	
			if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) || $item_r['owner_id'] == $HTTP_SESSION_VARS['user_id'])
			{
				$results = fetch_user_rs(get_owner_user_types_r(), 'user_id', 'ASC', FALSE, $item_r['owner_id']);
				
				if($item_r['owner_id'] == $HTTP_SESSION_VARS['user_id'])
					$owner_name = replace_lang_vars(array('fullname'=>str_replace(" ", "&nbsp;", fetch_user_name($item_r['owner_id'])), 'user_id'=>$item_r['owner_id']), str_replace(" ", "&nbsp;", $LANG_VARS['current_user']));	
				else
					$owner_name = replace_lang_vars(array('fullname'=>str_replace(" ", "&nbsp;", fetch_user_name($item_r['owner_id'])), 'user_id'=>$item_r['owner_id']), $LANG_VARS['user_name']);
	
				$pre_form_block = 
						format_field($LANG_VARS['owner_id'],
							NULL,
							$owner_name).
						format_field($LANG_VARS['new_owner_id'],
							NULL, // prompt_mask
							"\n<select name=\"new_owner_id\" onChange=\"this.form['confirmed'].value=''; this.form.submit();\">\n".
							"<option value=\"\" SELECTED>- ".$LANG_VARS['new_owner_id']." -\n".
							custom_select(
								'owner_id', 
								$results, 
								'%fullname% (%user_id%)',
								'NA',
								$HTTP_VARS['new_owner_id'],
								'user_id').
							"\n</select>");
							
				
				// temporarily change this, so we can get the right list of status_type's
				if(strlen($HTTP_VARS['new_owner_id'])>0)
				{
					$item_r['owner_id'] = $HTTP_VARS['new_owner_id'];
				}
				
				$results = fetch_sfieldtype_item_attribute_type_rs($item_r['s_item_type'], array('STATUSTYPE','STATUSCMNT','DURATION'), TRUE, TRUE);
				$formContents = get_edit_form(
							$HTTP_VARS['op'], 
							$LANG_VARS['confirm_item_instance_change_owner'], 
							$parent_item_r, //$parent_item_r is empty at this stage!!!
							$item_r, 
							$status_type_r, 
							$results, 
							$HTTP_VARS, 
							$dummy_post_file,
							$pre_form_block);
							
				if($formContents != NULL)
					return $formContents;
				else
				{
					$errors = array('error'=>$LANG_VARS['undefined_error'], detail=>'');
					return FALSE;
				}
				
			}// non-admin user attempting to change owner of item instance for someone else.
			else
			{
				$errors = array('error'=>$LANG_VARS['operation_not_available']);
				opendb_log("Non admin user attempted to change owner of an item instance for another user. (update_who=".$HTTP_SESSION_VARS['user_id'].")");
				return FALSE;
			}
		}
		else//if(is_empty_array($parent_item_r))
		{
			$errors = array('error'=>$LANG_VARS['operation_not_available'],'detail'=>'');
			return FALSE;
		}
	}
	else//if($CONFIG_VARS['item_input.item_instance_support']!==FALSE)
	{
		$errors = array('error'=>$LANG_VARS['operation_not_avail_change_owner'],'detail'=>'');
		return FALSE;
	}
}

/**
*/
function handle_confirm_new_instance($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, &$errors)
{
	global $PHP_SELF;
	global $LANG_VARS;
	global $HTTP_SESSION_VARS;
	
	if($CONFIG_VARS['item_input.item_instance_support']!==FALSE)
	{
		if(is_empty_array($parent_item_r))
		{
			$HTTP_VARS['owner_id'] = ifempty($HTTP_VARS['owner_id'], $HTTP_SESSION_VARS['user_id']);
	
			if(is_user_allowed_to_own($HTTP_VARS['owner_id']) && (
					$HTTP_VARS['owner_id'] == $HTTP_SESSION_VARS['user_id'] || 
					is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type'])))
			{
				if($CONFIG_VARS['item_input.new_instance_admin_diff_owner_support']!==FALSE && 
								is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
				{
					$results = NULL;
					if(is_exists_item_instance_with_owner_and_status($item_r['item_id'], $item_r['s_status_type'], $HTTP_SESSION_VARS['user_id']))
					{
						if($status_type_r['new_owner_instance_ind'] == 'Y')
							$results = fetch_user_rs(get_owner_user_types_r(), 'user_id', 'ASC');
						else
							$results = fetch_user_rs(get_owner_user_types_r(), 'user_id', 'ASC', FALSE, $HTTP_SESSION_VARS['user_id']);
					}
					else
					{
						$results = fetch_user_rs(get_owner_user_types_r(), 'user_id', 'ASC');
					}
					
					$field_rs[] = 
					array('prompt'=>$LANG_VARS['owner'],
						'field'=>
							"\n<select name=\"owner_id\" onChange=\"this.form['confirmed'].value=''; this.form.submit();\">".
							custom_select(
								'owner_id', 
								$results, 
								'%fullname% (%user_id%)',
								'NA',
								$HTTP_VARS['owner_id'],
								'user_id').
							"\n</select>");
				}
											
				$duration_attr_type_r = fetch_sfieldtype_item_attribute_type_r($item_r['s_item_type'], 'DURATION', TRUE);
				$field_rs[] = 
					array('prompt'=>$LANG_VARS['borrow_duration'],
						'field'=>get_input_field(
							'borrow_duration',
							$duration_attr_type_r['s_attribute_type'], 
							$duration_attr_type_r['prompt'], 
							$duration_attr_type_r['input_type'], 
							$duration_attr_type_r['compulsory_ind'], 
							ifempty($HTTP_VARS['borrow_duration'], $item_r['borrow_duration']),
							FALSE));
				
				$field_rs[] = 
						array('prompt'=>$LANG_VARS['s_status_type'],
							'field'=>status_type_input_field(
									's_status_type', 
									fetch_newinstance_status_type_rs($item_r['item_id'], $HTTP_VARS['owner_id']), 
									$item_r['s_status_type']));
			
				$field_rs[] = 
					array('prompt'=>$LANG_VARS['status_comment'],
						'field'=>get_input_field(
							'status_comment',
							NULL, 
							$LANG_VARS['status_comment'], 
							'textarea(50,5)', 
							'N', 
							NULL,
							FALSE));
				
				return format_confirm_form($PHP_SELF, 
								$LANG_VARS['confirm_item_instance_insert'], 
								$field_rs,
								$HTTP_VARS);
			}// non-admin user attempting to insert item for someone else.
			else
			{
				$errors = array('error'=>$LANG_VARS['operation_not_available']);
				opendb_log("Non admin user attempted to clone an item instance for another user. (update_who=".$HTTP_SESSION_VARS['user_id'].")");
				return FALSE;
			}
		}
		else//if(is_empty_array($parent_item_r))
		{
			$errors = array('error'=>$LANG_VARS['operation_not_available'],'detail'=>'');
			return FALSE;
		}
	}
	else//if($CONFIG_VARS['item_input.item_instance_support']!==FALSE)
	{
		$errors = array('error'=>$LANG_VARS['operation_not_avail_new_instance'],'detail'=>'');
		return FALSE;
	}
}

/*
*/
function handle_confirm_clone_item($item_r, $HTTP_VARS, &$errors)
{
	global $PHP_SELF;
	global $LANG_VARS;
	global $HTTP_SESSION_VARS;
	
	if($CONFIG_VARS['item_input.clone_item_support']!==FALSE)
	{
		if(is_not_empty_array($item_r))
		{
			// Linked item has no item instance
			if($item_r['parent_id'] === NULL)
			{
				$HTTP_VARS['owner_id'] = ifempty($HTTP_VARS['owner_id'], $HTTP_SESSION_VARS['user_id']);
				
				if(is_user_allowed_to_own($HTTP_VARS['owner_id']) && (
						$HTTP_VARS['owner_id'] == $HTTP_SESSION_VARS['user_id'] || 
						is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type'])))
				{
					if($CONFIG_VARS['item_input.clone_item_admin_diff_owner_support']!==FALSE && 
						is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
					{
						$field_rs[] = 
							array('prompt'=>$LANG_VARS['owner'],
							'field'=>"\n<select name=\"owner_id\" onChange=\"this.form['confirmed'].value=''; this.form.submit();\">".
								custom_select(
									'owner_id', 
									fetch_user_rs(get_owner_user_types_r(), 'user_id', 'ASC'), 
									'%fullname% (%user_id%)',
									'NA',
									$HTTP_VARS['owner_id'],
									'user_id'
									)."\n</select>");
					}				
					
					$field_rs[] = 
						array('prompt'=>$LANG_VARS['item_type'],
							'field'=>custom_select(
										's_item_type',
										fetch_item_type_rs(),
											'%s_item_type% - %description%', 
											'1',
											$item_r['s_item_type'],
											's_item_type'));
				
					$field_rs[] = 
							array('prompt'=>$LANG_VARS['s_status_type'],
								'field'=>status_type_input_field(
										's_status_type', 
										fetch_newitem_status_type_rs($HTTP_VARS['owner_id']), 
										$item_r['s_status_type']));
			
					$field_rs[] = 
						array('prompt'=>$LANG_VARS['status_comment'],
							'field'=>get_input_field(
								'status_comment',
								NULL, 
								$LANG_VARS['status_comment'], 
								'textarea(50,5)', 
								'N', 
								NULL,
								FALSE));
				
					// If child items exist, we need to prompt, to force conversion to new type.
					if(is_exists_child_item_with_diff_item_type_to_parent($item_r['item_id'], $item_r['s_item_type']))
					{
						$field_rs[] = 
							array('prompt'=>$LANG_VARS['coerce_child_item_types'],
								'field'=>'<input type=checkbox name="coerce_child_item_type" value="Y" CHECKED>');
					}
				
					return format_confirm_form($PHP_SELF, 
									$LANG_VARS['confirm_clone_item'], 
									$field_rs,
									$HTTP_VARS);
				}// non-admin user attempting to insert item for someone else.
				else
				{
					$errors = array('error'=>$LANG_VARS['operation_not_available']);
					opendb_log("Non admin user attempted to clone an item instance for another user. (update_who=".$HTTP_SESSION_VARS['user_id'].")");
					return FALSE;
				}
			}
			else//if($item_r['parent_id'] === NULL)
			{
				$errors = array('error'=>$LANG_VARS['cannot_clone_linked_item'],detail=>'');
				opendb_log("User attempted to clone linked item (item_id=".$item_r['item_id'].", update_who=".$HTTP_SESSION_VARS['user_id'].")");
				return FALSE;
			}
		}
		else//if(is_not_empty_array($item_r))
		{
			$errors = array('error'=>$LANG_VARS['item_not_found'],'detail'=>'');
			return FALSE;
		}
	}
	else
	{
		$errors = array('error'=>$LANG_VARS['clone_item_not_supported'],detail=>'');
		return FALSE;
	}
}

/**
* This function will handle constructing instances of site plugin classes, to
* present title listings.  Each title in the listing should be linkable back
* into item_input with 'site' operation.
* 
* @return if returns an array, then we assume its a single match, and it contains
* the item data.
*/
function handle_site_search(&$sitePlugin, $HTTP_VARS, &$errors)
{
	global $PHP_SELF;
	global $LANG_VARS;
	global $CONFIG_VARS;
	
	// next operation to be undertaken will be site - adding item to opendb
	$HTTP_VARS['op'] = 'site';
	
	$formContents = "";
	
	$formContents .= get_popup_javascript();
	
 	if($sitePlugin->_queryListing($HTTP_VARS) !== FALSE)
 	{
		$searchQuery = $sitePlugin->getSearchQuery();
		if(is_not_empty_array($searchQuery))
		{
			if(strlen($sitePlugin->getImage())>0)
				$site_image = "<a href=\"javascript:popup('external.php?url=".urlencode($sitePlugin->getExternalUrl())."&title=".urlencode($sitePlugin->getTitle())."', 800, 600);\"><img src=\"./site/images/".$sitePlugin->getImage()."\" title=\"".$sitePlugin->getTitle()."\" alt=\"".$sitePlugin->getTitle()."\" valign=absmiddle align=absmiddle border=0></a>";

			$formContents .= "<h3>".replace_lang_vars(array('site_title'=>$sitePlugin->getTitle(), 'site_image'=>$site_image), $LANG_VARS['site_search_results'])."</h3>";
			
			$formContents .='<table border=1 cellpadding=0 cellspacing=1><tr><td><table cellspacing=1 border=0>'
 						.'<tr><td class="navbar" colspan=2 align=middle>'.$LANG_VARS['search_query'].'</td></tr>';
						
			for($i=0; $i<count($searchQuery); $i++)
			{
				$formContents .= format_field($searchQuery[$i]['prompt'], NULL, htmlspecialchars($searchQuery[$i]['value']));
			}
			$formContents .= "</table></td></tr></table><br>";
		}
 		
 		if($sitePlugin->getRowCount()>0)
 		{
 			// exact title match.
 			if($sitePlugin->getRowCount() == 1 && $sitePlugin->isPreviousPage() === FALSE )
 			{
 				// the site plugin process will have already queried for the itemData
 				// based on the single row returned.
 				return "__EXACT_TITLE_MATCH__";
 			}
 			else
 			{
 				$formContents .= "\n<table width=\"100%\" border=0>";
				$class = "top";
				
 				for($i=0; $i<$sitePlugin->getRowCount(); $i++)
 				{
 					$formContents .= "\n<tr>";
 
 					$row_data_r = $sitePlugin->getRowData($i);
 					
 					if(strlen($row_data_r['cover_image_url'])>0)
 						$thumbimg = $row_data_r['cover_image_url'];
 					else
 						$thumbimg = _theme_image_src($CONFIG_VARS['listings.no_image']);

					$cover_image_block = get_cover_image(
														$thumbimg, 
														NULL,
														$CONFIG_VARS['listings.item_image_size'],
														NULL, 
														NULL, 
														FALSE);
														
 					$formContents .= "\n<td class=\"$class\" align=center width=\"5%\">".$cover_image_block."</td>";
 					
 					if(strlen($row_data_r['comments'])>0 && strlen($row_data_r['more_info_url'])>0)
						$formContents .= "\n<td class=\"$class\">";
					else if(strlen($row_data_r['comments'])>0 || strlen($row_data_r['more_info_url'])>0)
						$formContents .= "\n<td class=\"$class\" colspan=2>";
					else // both are empty
						$formContents .= "\n<td class=\"$class\" colspan=3>";
						
 					$formContents .= "\n<a href=\""."item_input.php?".$row_data_r['opendb_link_url']."\">".$row_data_r['title']."</a></td>";
 
 					if(strlen($row_data_r['comments'])>0)
					{
						$formContents .= "<td class=\"$class\">".nl2br($row_data_r['comments'])."</td>";
					}
					
 					if(strlen($row_data_r['more_info_url'])>0)
					{
 						$formContents .= "\n<td class=\"$class\" width=\"10%\" nowrap><a href=\"javascript:popup('external.php?url=".urlencode($row_data_r['more_info_url'])."&title=".urlencode($sitePlugin->getTitle().": ".str_replace("'", "\\'", $row_data_r['title']))."', 800, 600);\">".str_replace(" ", "&nbsp;", $LANG_VARS['more_info'])."&nbsp;<img border=0 src=\""._theme_image_src('magnify.gif')."\"></a></td>";
					}
						
 					$formContents .= "\n</tr>";
					
					$class = ($class=='top'?'top2':'top');
 				}
 				
 				// we want to do it programatically.
 				unset($HTTP_VARS['page_no']);
 				
 				if($sitePlugin->isPreviousPage() || $sitePlugin->isNextPage())
 				{
					//spacer
					$formContents .= "<tr><td colspan=4>&nbsp;</td></tr>";
					
 					$HTTP_VARS['op'] = 'site-search';
 					
 					$page_nav_url = get_url_string($HTTP_VARS);
 					
 					$formContents .= "<tr><td class=\"footer\" align=\"center\" colspan=\"4\">";
 					
 					// Include a back link if we are on page 2 or greater.
 					if($sitePlugin->isPreviousPage())
 					{
 						$formContents .= _theme_image("left.gif", "<=", NULL, "absmiddle")." <a href=\"item_input.php?$page_nav_url&page_no=".($sitePlugin->getPageNo() - 1)."\" class=\"footer\">".$LANG_VARS['previous_page']."</a>";
 					}
 
 					// If we are not at the end of the list, include a Next button!
 					if($sitePlugin->isNextPage())
 					{
 						if($sitePlugin->isPreviousPage())
 							$formContents .= "&nbsp;/&nbsp;";
 							
 						$formContents .= "<a href=\"item_input.php?$page_nav_url&page_no=".($sitePlugin->getPageNo() + 1)."\" class=\"footer\">".$LANG_VARS['next_page']." "._theme_image("right.gif", "=>", NULL, "absmiddle")."</a>";
 					}
 					$formContents .= "</td></tr>";
 				}
 				$formContents .= "\n</table>";
 			}
 		}//if($sitePlugin->getRowCount())
 		else
 		{
 			$formContents .= "<h3>".$LANG_VARS['no_matches_found']."</h3>";
 		}
			
		$http_url_vars = get_url_string($HTTP_VARS, NULL, array('op', 'site_type', 's_item_type'));
		$formContents .= format_footer_links(array(array(url=>"item_add.php".(strlen($http_url_vars)>0?"?".$http_url_vars:""),text=>$LANG_VARS['new_search'])));
		
		return $formContents;
		
	}//if($sitePlugin->_queryListing($HTTP_VARS))
	else
	{
		$errors = $sitePlugin->getErrors();
		
		// we need to provide at least some indication of why there was a problem.
		if($errors === FALSE)
			$errors = $LANG_VARS['undefined_error'];

		return FALSE;
	}
}

/**
*/
function get_child_item_table($op, $parent_item_r, $item_r, $HTTP_VARS)
{
	global $LANG_VARS;
	global $CONFIG_VARS;
	global $PHP_SELF;
	
	// Ensure we are at the level of parent item, not a child item (This the is_empty_array($parent_item_r) test!)
	if($op!='new' && $op!='site' && $op!='site-search' && is_empty_array($parent_item_r) && is_not_empty_array($item_r))
	{
		// If existing linked items, then we need to display block, but just disable Add Linked operation!
		// Otherwise if no results and $CONFIG_VARS['item_input.linked_item_support'] enabled, still generate table,
		// but no records will be displayed.
		$results = fetch_child_item_rs($item_r['item_id']);
		if ($results || $CONFIG_VARS['item_input.linked_item_support'] !== FALSE)
		{
			// A interpage link to be used from listings.
			$tableContents = "\n<a name=\"linked_item\"></a>".
							"\n<p><br><div class=\"colortext\"><b>".$LANG_VARS['linked_item(s)'].":</b>&nbsp;";
							
			if($CONFIG_VARS['item_input.linked_item_support'] !== FALSE)
			{
				$tableContents .= "[<a href=\"item_add.php?".($CONFIG_VARS['item_input.link_same_type_only']===TRUE?"s_item_type=".$item_r['s_item_type']."&":"")."parent_id=".$item_r['item_id']."&parent_instance_no=".$item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:'')."\">".$LANG_VARS['add_linked']."</a>]";
			}				
			$tableContents .= "</div>";

			$tableContents .= "\n<table border=0 cellpadding=0 cellspacing=1>";
			
			$tableContents .= "\n<tr>".
							"<td class=\"navbar\" align=center width=10%>".$LANG_VARS['type']."</td>".
							"<td class=\"navbar\" align=center width=40%>".$LANG_VARS['title']."</td>".
							"<td class=\"navbar\" align=center>".$LANG_VARS['action']."</td>".
							"<td class=\"navbar\" align=center>".$LANG_VARS['category']."</td>".
							"</tr>";
			if($results)
			{
				$toggle = TRUE;
				while($child_item_r = mysql_fetch_array($results))
				{
					if($toggle)
						$color="top";
					else
		 				$color="top2";
					$toggle = !$toggle;
						
					$action_links_rs = NULL;
					
					$child_item_r['title'] = expand_type_title_mask($child_item_r, $CONFIG_VARS['listings.title_display_mask'], $parsed_title_mask_r);

					$tableContents .= "\n<tr>".
									"<td class=\"$color\" align=center nowrap>".get_item_image($child_item_r['s_item_type'],NULL,TRUE)."</td>".
									"<td class=\"$color\" align=center>".$child_item_r['title']."</td>";

					$action_links_rs[] = array(url=>$PHP_SELF.'?op=edit&item_id='.$child_item_r['item_id'].'&parent_id='.$item_r['item_id'].'&parent_instance_no='.$item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),img=>'edit.gif',text=>$LANG_VARS['edit']);
					
					// Checks if any legal site plugins defined for $s_item_type
					if(is_item_legal_site_type($child_item_r['s_item_type']))
					{
						$action_links_rs[] = array(url=>'item_add.php?item_id='.$child_item_r['item_id'].'&parent_id='.$item_r['item_id'].'&parent_instance_no='.$item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),img=>'refresh.gif',text=>$LANG_VARS['refresh']);
					}

					$action_links_rs[] = array(url=>$PHP_SELF.'?op=delete&item_id='.$child_item_r['item_id'].'&parent_id='.$item_r['item_id'].'&parent_instance_no='.$item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),img=>'delete.gif',text=>$LANG_VARS['delete']);

					$tableContents .= format_action_links(
							$action_links_rs,
							"\n<td align=\"center\" class=\"$color\" %nowrap%><font class=\"smlink\">%field%</font></td>",
							$LANG_VARS['not_applicable']);
																
					$attribute_type_r = fetch_sfieldtype_item_attribute_type_r($child_item_r['s_item_type'], 'CATEGORY', TRUE);
					$tableContents .= "<td class=\"$color\" align=center>";
					if(is_array($attribute_type_r))
					{
						$tableContents .= ifempty(
									get_display_field(
											$attribute_type_r['s_attribute_type'], 
											$attribute_type_r['prompt'], 
											$attribute_type_r['display_type'], 
											trim_explode(' ', $child_item_r['category']), // category should be array
											FALSE),
									"&nbsp;");
					}
					else
						$tableContents .= "&nbsp;";
								
					$tableContents .= "</td></tr>";
				}
			}
			else
			{
				$tableContents .= "\n<tr><td align=center colspan=4 class=\"error\">".
							"<div class=\"error\"><b>- ".$LANG_VARS['no_records_found']." -</b></div>".
							"</td></tr>";
			}		
			
			return $tableContents .
					"\n</table></p>";
			
		}//if ($results || $CONFIG_VARS['item_input.linked_item_support'] !== FALSE)
	}//if($op != "new" && $op!="site" && is_empty_array($parent_item_r) && is_not_empty_array($item_r))
	
	//else
	return NULL;
}

/**
* Will work out based on the $op what the title should be.  It will
* return a complete heading, including calling the _theme_header
* and everything.
*/
function do_op_title($parent_item_r, $item_r, $status_type_r, $op)
{
	global $LANG_VARS;
	global $CONFIG_VARS;
	global $HTTP_SESSION_VARS;
	
	// Now do the title
	if(is_not_empty_array($parent_item_r))
	{
		$parent_item_title = replace_lang_var('display_title', expand_item_title_mask($parent_item_r, $CONFIG_VARS['item_display.title_display_mask']), $LANG_VARS['edit_title']);
		switch($op)
		{
			case 'delete':
			case 'update':
			case 'refresh':
			case 'edit':
				$linked_item_title = $LANG_VARS[$op.'_linked_item'];
				break;
			case 'new':
			case 'site':
			case 'site-search':
			case 'insert':
				$linked_item_title = $LANG_VARS['add_linked_item'];
				break;
			default:
				$linked_item_title = $LANG_VARS['operation_not_available'];
		}		
		
		echo _theme_header($parent_item_title);
		echo ("<h2>".$parent_item_title." ".get_item_image($parent_item_r['s_item_type'])."</h2>\n");
		echo ("<h3>".$linked_item_title." ".get_item_image($item_r['s_item_type'], NULL, TRUE)."</h3>\n");
	}
	else
	{
		if($op == 'new' || $op == 'site' || $op == 'site-search' || $op == 'insert')
		{
			if(is_empty_array($parent_item_r))
			{
				// Not yet provided s_status_type value.
				if(strlen($status_type_r['s_status_type'])>0)
				{
					if($item_r['owner_id'] != $HTTP_SESSION_VARS['user_id'])
						$item_title = replace_lang_vars(array('s_status_type_desc'=>$status_type_r['description'], 'user_id'=>$item_r['owner_id'], 'fullname'=>fetch_user_name($item_r['owner_id'])), $LANG_VARS['add_s_status_type_item_for_name']);
					else
						$item_title = replace_lang_var('s_status_type_desc', $status_type_r['description'], $LANG_VARS['add_s_status_type_item']);
				}
				else
				{
					if($item_r['owner_id'] != $HTTP_SESSION_VARS['user_id'])
						$item_title = replace_lang_vars(array('user_id'=>$item_r['owner_id'], 'fullname'=>fetch_user_name($item_r['owner_id'])), $LANG_VARS['add_item_for_name']);
					else
						$item_title = $LANG_VARS['add_item'];
				}
			}
			else
			{
				// Not yet provided s_status_type value.
				if(strlen($status_type_r['s_status_type'])>0)
					$item_title = replace_lang_var('s_status_type_desc', $status_type_r['description'], $LANG_VARS['add_s_status_type_item']);
				else
					$item_title = $LANG_VARS['add_item'];
			}
		}
		else if($op == 'update' || $op == 'delete')
		{
			$item_title = $LANG_VARS[$op.'_item'];
		}
		else if ($op == 'refresh' || $op == 'edit' || $op == 'updateinstance' || $op == 'clone_item')
		{
			if($op == 'updateinstance')
				$op = 'update';
			else if($op == 'clone_item')
				$op = 'clone';
			
			$item_title = replace_lang_vars(array('display_title'=>expand_item_title_mask($item_r, $CONFIG_VARS['item_display.title_display_mask'])), $LANG_VARS[$op.'_title']);
		}
		else if ($op == 'newinstance')
		{
			// temporarily remove instance_no so that title renders correctly.
			$item_r['instance_no'] = NULL;
			
			$item_title = replace_lang_vars(array('display_title'=>expand_item_title_mask($item_r, $CONFIG_VARS['item_display.title_display_mask'])), $LANG_VARS['new_item_instance_title']);
		}
		else if ($op == 'change_owner')
		{
			// temporarily remove instance_no so that title renders correctly.
			$item_r['instance_no'] = NULL;
			
			$item_title = replace_lang_vars(array('display_title'=>expand_item_title_mask($item_r, $CONFIG_VARS['item_display.title_display_mask'])), $LANG_VARS['item_instance_change_owner_title']);
		}
		
		echo _theme_header($item_title);
		echo ("<h2>".$item_title." ".get_item_image($item_r['s_item_type'])."</h2>\n");
	}
}

// *****************************************************************************
// MAIN PROCESS
// *****************************************************************************
if($CONFIG_VARS['site.enable']!==FALSE)
{
	session_start();
	if (is_opendb_valid_session())
	{
		// Get a reference to the $item_r and $parent_item_r if applicable
		if(is_numeric($HTTP_VARS['parent_id']) && is_numeric($HTTP_VARS['parent_instance_no']))
			$parent_item_r = fetch_item_instance_r($HTTP_VARS['parent_id'], $HTTP_VARS['parent_instance_no']);
			
		// Either no parent relationship - The !is_numeric(...) bit, or a non-empty array.
		if(!is_numeric($HTTP_VARS['parent_id']) || is_not_empty_array($parent_item_r))
		{
			if($HTTP_VARS['op'] == 'new' || 
					$HTTP_VARS['op'] == 'insert' || 
					// For a $op == ('site' OR 'site-search') where an item is actually defined, 
					// it is really a 'refresh' site operation.
					(($HTTP_VARS['op'] == 'site-search' || 
						$HTTP_VARS['op'] == 'site') && !is_exists_item($HTTP_VARS['item_id'])))
			{	
				// Get the status_type for instances where the s_status_type is being
				// specified according to the s_attribute_type:order_no.  This would
				// occur for site operations, as well as situations where the addition
				// of an item resulted in an error which reloading the Update page.
				if(strlen($HTTP_VARS['s_status_type'])==0)
				{
					$status_attr_type_r = fetch_sfieldtype_item_attribute_type_r($HTTP_VARS['s_item_type'], 'STATUSTYPE');
					$HTTP_VARS['s_status_type'] = $HTTP_VARS[get_field_name($status_attr_type_r['s_attribute_type'], $status_attr_type_r['order_no'])];
				}
			
				// No s_status_type unless actually provided.
				if(strlen($HTTP_VARS['s_status_type'])>0)
					$status_type_r = fetch_status_type_r($HTTP_VARS['s_status_type']);
				else
				{
					// Dummy array entry, as the s_status_type will be chosen in the edit form.
					$status_type_r = array(
								'insert_ind'=>'Y',
								'borrow_ind'=>'Y');
				}
					
				$item_r = array(id=>NULL,
						instance_no=>NULL,
						title=>NULL,//Will be provided by get_field_value, when $op == 'site'!
						owner_id=>ifempty($HTTP_VARS['owner_id'], $HTTP_SESSION_VARS['user_id']),
						parent_id=>(is_not_empty_array($parent_item_r)?$parent_item_r['item_id']:NULL),
						category=>NULL,//Will be provided by get_field_value, when $op == 'site'
						s_item_type=>trim($HTTP_VARS['s_item_type']),
						s_status_type=>$status_type_r['s_status_type'],
						status_comment=>NULL);
			}
			else //otherwise either a site refresh operation or an edit/update/delete
			{
				// Is parent-child relationship
				if(is_not_empty_array($parent_item_r))
				{
					$status_type_r = fetch_status_type_r($parent_item_r['s_status_type']);
					$item_r = fetch_child_item_r($HTTP_VARS['item_id']);
				}
				else
				{
					$item_r = fetch_item_instance_r($HTTP_VARS['item_id'], $HTTP_VARS['instance_no']);
					$status_type_r = fetch_status_type_r($item_r['s_status_type']);
				}
			}
			
			// Includes 'new' because we artificially construct an $item_r array.
			if(is_not_empty_array($item_r))
			{
				// We need a valid $status_type_r as well at this point, and should not continue without it.
				if(is_not_empty_array($status_type_r))
				{
					$footer_links_r = NULL;
					
					switch($HTTP_VARS['op'])
					{
						case 'delete':
							do_op_title($parent_item_r, $item_r, $status_type_r, 'delete');
					
							$return_val = handle_item_delete($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $errors);
							if($return_val === "__CONFIRM__")
							{
								echo(get_op_confirm_form($PHP_SELF, 
													replace_lang_var('display_title', expand_item_title_mask($item_r, $CONFIG_VARS['item_display.title_display_mask']), $LANG_VARS['confirm_delete_title']), 
													$HTTP_VARS));
							}
							else if($return_val === "__CONFIRM_INACTIVE_BORROW__")
							{
								echo(get_op_confirm_form($PHP_SELF, 
													replace_lang_var('display_title', expand_item_title_mask($item_r, $CONFIG_VARS['item_display.title_display_mask']), $LANG_VARS['confirm_delete_inactive_borrowed_items_and_title']), 
													$HTTP_VARS));
							}
							else
							{
								if($return_val === "__ABORTED__")
								{
									echo("<div class=\"success\">".$LANG_VARS['item_not_deleted']."</div>");
									
									if(is_not_empty_array($parent_item_r))
										$footer_links_r[] = array(url=>"item_display.php?parent_id=".$parent_item_r['item_id']."&parent_instance_no=".$parent_item_r['instance_no']."&item_id=".$item_r['item_id'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_item']);
									else
										$footer_links_r[] = array(url=>"item_display.php?item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_item']);
								}
								else if($return_val === FALSE)
								{
									echo format_error_block($errors);
										if(is_not_empty_array($parent_item_r))
										$footer_links_r[] = array(url=>"item_display.php?parent_id=".$parent_item_r['item_id']."&parent_instance_no=".$parent_item_r['instance_no']."&item_id=".$item_r['item_id'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_item']);
									else
										$footer_links_r[] = array(url=>"item_display.php?item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_item']);
								}
								else
									echo("<div class=\"success\">".$LANG_VARS['item_deleted']."</div>");
	
								if(is_not_empty_array($parent_item_r))
								{
									$footer_links_r[] = array(url=>"item_display.php?item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_parent']);
								}
								
								// Listing link.
								if($HTTP_VARS['listing_link'] === 'y' && is_array($HTTP_SESSION_VARS['listing_url_vars']))
								{
									$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
								}
							}
							break;
							
						case 'update':
							do_op_title($parent_item_r, $item_r, $status_type_r, 'update');
						
							$return_val = handle_item_update($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $HTTP_POST_FILES, $errors);
							if($return_val === "__INVALID_DATA__")
							{
								// We need to load the edit form again here!
								echo format_error_block($errors);
							
								$HTTP_VARS['op'] = 'edit';
								
								$formContents = handle_edit_or_refresh($HTTP_VARS['op'], $parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $HTTP_POST_FILES, $errors);
								if($formContents !== FALSE)
								{
									echo $formContents;
							
									// Do not display child items block, if edit/refresh for a child item!
									if(is_empty_array($parent_item_r))
										echo get_child_item_table($HTTP_VARS['op'], $parent_item_r, $item_r, $HTTP_VARS);
								}
								else
									echo format_error_block($errors);
	
								if(is_not_empty_array($parent_item_r))
								{
									$footer_links_r[] = array(url=>"item_input.php?op=edit&item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['edit_parent']);
									$footer_links_r[] = array(url=>"item_display.php?item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_parent']);
								}
							}
							else if($return_val === TRUE)
							{
								echo("<div class=\"success\">".$LANG_VARS['item_updated']."</div>");
								echo format_error_block($errors, 'warning');//warnings
									
								if(is_not_empty_array($parent_item_r))
								{
									$footer_links_r[] = array(url=>"item_display.php?parent_id=".$parent_item_r['item_id']."&parent_instance_no=".$parent_item_r['instance_no']."&item_id=".$item_r['item_id'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_item']);
									$footer_links_r[] = array(url=>"item_display.php?item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_parent']);
								}
								else
									$footer_links_r[] = array(url=>"item_display.php?item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_item']);
									
								// Listing link.
								if($HTTP_VARS['listing_link'] === 'y' && is_array($HTTP_SESSION_VARS['listing_url_vars']))
								{
									$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
								}
							}
							else // if($return_val === FALSE)
							{
								echo format_error_block($errors);
										
								// Listing link.
								if($HTTP_VARS['listing_link'] === 'y' && is_array($HTTP_SESSION_VARS['listing_url_vars']))
								{
									$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
								}
							}
							break;
							
						case 'insert':
							$return_val = handle_item_insert($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $HTTP_POST_FILES, $errors);
							if($return_val === "__CONFIRM_EXISTS_TITLE__" || $return_val === "__CONFIRM_EXISTS_OWNER_TITLE__" || $return_val === "__CONFIRM_EXISTS_LINKED_TITLE__")
							{
								if($return_val === "__CONFIRM_EXISTS_OWNER_TITLE__")
								{
									$message_lang_var = $LANG_VARS['confirm_title_same_type_and_owner_insert'];
									$footer_links_r[] = array(url=>"listings.php?search_list=y&inc_menu=N&owner_id=".$item_r['owner_id']."&title=".urlencode($item_r['title'])."&title_match=exact&s_item_type=".$item_r['s_item_type'],target=>'popup',text=>$LANG_VARS['list_duplicate_title(s)']);
								}
								else if($return_val === "__CONFIRM_EXISTS_TITLE__")
								{
									$message_lang_var = $LANG_VARS['confirm_title_same_type_insert'];
									$footer_links_r[] = array(url=>"listings.php?search_list=y&inc_menu=N&title=".urlencode($item_r['title'])."&title_match=exact&s_item_type=".$item_r['s_item_type'],target=>'popup',text=>$LANG_VARS['list_duplicate_title(s)']);
								}
								else if($return_val === "__CONFIRM_EXISTS_LINKED_TITLE__")
								{
									$message_lang_var = $LANG_VARS['confirm_title_linked_item_insert'];
									$footer_links_r[] = array(url=>"item_display.php?inc_menu=N&item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no']."#linked_item",target=>'popup',text=>$LANG_VARS['list_duplicate_title(s)']);
								}
									
								do_op_title($parent_item_r, $item_r, $status_type_r, 'insert');
								
								echo get_popup_javascript();
									
								echo get_op_confirm_form(
										$PHP_SELF, 
										replace_lang_vars(array('title'=>$item_r['title'],'s_item_type'=>$item_r['s_item_type']), $message_lang_var), 
										$HTTP_VARS);
							}
							else
							{
								if($return_val === "__INVALID_DATA__")
								{
									do_op_title($parent_item_r, $item_r, $status_type_r, 'insert');
								
									// We need to load the edit form again here!
									echo format_error_block($errors);
		
									// Reset operation 						
									$HTTP_VARS['op'] = 'new';
									$formContents = handle_new_or_site($HTTP_VARS['op'], $parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $HTTP_POST_FILES, $errors);
									if($formContents !== FALSE)
										echo $formContents;
									else
										echo format_error_block($errors);
												
									if(is_not_empty_array($parent_item_r))
									{
										$footer_links_r[] = array(url=>"item_input.php?op=edit&item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['edit_parent']);
										$footer_links_r[] = array(url=>"item_display.php?item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_parent']);
									}
								}
								else if($return_val === "__ABORTED__")
								{
									do_op_title($parent_item_r, $item_r, $status_type_r, 'insert');
									echo("<div class=\"success\">".$LANG_VARS['item_not_added']."</div>");
									
									// Listing link.
									if($HTTP_VARS['listing_link'] === 'y' && is_array($HTTP_SESSION_VARS['listing_url_vars']))
									{
										$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
									}
								}
								else if($return_val === TRUE)
								{
									do_op_title($parent_item_r, $item_r, $status_type_r, 'insert');
									echo("<div class=\"success\">".$LANG_VARS['item_added']."</div>");
									echo format_error_block($errors, 'warning');//warnings
	
									if(is_not_empty_array($parent_item_r))
									{
										if($CONFIG_VARS['item_input.linked_item_support']!==FALSE)
											$footer_links_r[] = array(url=>"item_add.php?".($CONFIG_VARS['item_input.link_same_type_only']===TRUE?"s_item_type=".$item_r['s_item_type']."&":"")."parent_id=".$parent_item_r['item_id']."&parent_instance_no=".$parent_item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['add_linked']);
	
										$footer_links_r[] = array(url=>"item_display.php?parent_id=".$parent_item_r['item_id']."&parent_instance_no=".$parent_item_r['instance_no']."&item_id=".$item_r['item_id'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_item']);
										$footer_links_r[] = array(url=>"item_display.php?item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_parent']);
									}
									else
									{
										$footer_links_r[] = array(url=>"item_add.php?owner_id=".$item_r['owner_id']."&s_status_type=".$item_r['s_status_type'],text=>replace_lang_var('s_status_type_desc', $status_type_r['description'], $LANG_VARS['add_s_status_type_item']));
										$footer_links_r[] = array(url=>"item_display.php?item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_item']);
									}
										
									// Listing link.
									if($HTTP_VARS['listing_link'] === 'y' && is_array($HTTP_SESSION_VARS['listing_url_vars']))
									{
										$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
									}
								}
								else //if($return_val === FALSE)
								{
									do_op_title($parent_item_r, $item_r, $status_type_r, 'insert');
									
									echo format_error_block($errors);
										
									if(is_not_empty_array($parent_item_r))
									{
										$footer_links_r[] = array(url=>"item_display.php?item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_parent']);
									}
										
									// Listing link.
									if($HTTP_VARS['listing_link'] === 'y' && is_array($HTTP_SESSION_VARS['listing_url_vars']))
									{
										$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
									}
								}
							}
							break;
							
						case 'updateinstance': // Only Status Type / Status Comment update supported
							do_op_title($parent_item_r, $item_r, $status_type_r, $HTTP_VARS['op']);
							
							$return_val = handle_item_instance_update($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $errors);
							if($return_val === "__CONFIRM__")
							{
								$formContents = handle_confirm_item_instance_update($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $errors);
								if($formContents !== FALSE)
									echo $formContents;
								else
								{
									echo format_error_block($errors);
								}
							}
							else if($return_val === "__ABORTED__")
							{
								echo("<div class=\"success\">".$LANG_VARS['item_instance_not_updated']."</div>");
							}
							else if($return_val === TRUE)
							{
								echo("<div class=\"success\">".$LANG_VARS['item_instance_updated']."</div>");
								echo format_error_block($errors, 'warning');//warnings
							}
							else // $return_val == FALSE
							{
								echo format_error_block($errors);
							}
												
							$footer_links_r[] = array(url=>"item_display.php?item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_item']);
								
							// Listing link.
							if($HTTP_VARS['listing_link'] == 'y' && is_array($HTTP_SESSION_VARS['listing_url_vars']))
							{
								$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
							}
							break;
							
						case 'change_owner':
							do_op_title($parent_item_r, $item_r, $status_type_r, $HTTP_VARS['op']);
							
							$return_val = handle_item_instance_change_owner($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $errors);
							if($return_val === "__CONFIRM__")
							{
								$formContents = handle_confirm_item_instance_change_owner($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $errors);
								if($formContents !== FALSE)
									echo $formContents;
								else
								{
									echo format_error_block($errors);
								}
							}
							else if($return_val === "__ABORTED__")
							{
								echo("<div class=\"success\">".$LANG_VARS['item_instance_owner_not_changed']."</div>");
							}
							else if($return_val === TRUE)
							{
								echo("<div class=\"success\">".$LANG_VARS['item_instance_owner_changed']."</div>");
								// for status info change, etc.
								echo("<div class=\"success\">".$LANG_VARS['item_instance_updated']."</div>");
								echo format_error_block($errors, 'warning');//warnings
							}
							else // $return_val == FALSE
							{
								echo format_error_block($errors);
							}
												
							$footer_links_r[] = array(url=>"item_display.php?item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_item']);
								
							// Listing link.
							if($HTTP_VARS['listing_link'] == 'y' && is_array($HTTP_SESSION_VARS['listing_url_vars']))
							{
								$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
							}
							break;
							
						case 'newinstance':
							do_op_title($parent_item_r, $item_r, $status_type_r, 'newinstance');
							
							$return_val = handle_item_instance_insert($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $errors);
							if($return_val === "__CONFIRM__")
							{
								$formContents = handle_confirm_new_instance($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $errors);
								if($formContents !== FALSE)
									echo $formContents;
								else
								{
									echo format_error_block($errors);
								}
									
								$footer_links_r[] = array(url=>"item_display.php?item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_item']);
							}
							else if($return_val === "__ABORTED__")
							{
								echo("<div class=\"success\">".$LANG_VARS['item_instance_not_added']."</div>");
									
								// This will take us back to the item_display entry where the 'New Copy' operation was started.							
								$footer_links_r[] = array(url=>"item_display.php?item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_item']);
							}
							else if($return_val === TRUE)
							{
								echo("<div class=\"success\">".$LANG_VARS['item_instance_added']."</div>");
								echo format_error_block($errors, 'warning');//warnings
									
								// Provide link back to item after insert.
								$footer_links_r[] = array(url=>"item_display.php?item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_item']);
							}
							else
							{
								echo format_error_block($errors);
									
								// This will take us back to the item_display entry where the 'New Copy' operation was started.							
								$footer_links_r[] = array(url=>"item_display.php?item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_item']);
							}
							
							// Listing link.
							if($HTTP_VARS['listing_link'] == 'y' && is_array($HTTP_SESSION_VARS['listing_url_vars']))
							{
								$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
							}
	
							break;
						
						case 'clone_item':
							do_op_title($parent_item_r, $item_r, $status_type_r, 'clone_item');
							
							$return_val = handle_clone_item($item_r, $HTTP_VARS, $errors);
							if($return_val === "__CONFIRM__")
							{
								$formContents = handle_confirm_clone_item($item_r, $HTTP_VARS, $errors);
								if($formContents !== FALSE)
									echo $formContents;
								else
								{
									echo format_error_block($errors);
								}
							}
							else if($return_val === "__ABORTED__")
							{
								echo("<div class=\"success\">".$LANG_VARS['item_not_cloned']."</div>");
							}
							else if($return_val === TRUE)
							{
								echo("<div class=\"success\">".$LANG_VARS['item_cloned']."</div>");
								echo format_error_block($errors, 'warning');//warnings
							}
							else
							{
								echo format_error_block($errors);
							}
							
							$footer_links_r[] = array(url=>"item_display.php?item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_item']);
								
							// Listing link.
							if($HTTP_VARS['listing_link'] === 'y' && is_array($HTTP_SESSION_VARS['listing_url_vars']))
							{
								$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
							}
							break;
						
						case 'site-search':
						case 'site':
							$sitePlugin =& get_site_plugin_instance($HTTP_VARS['site_type']);
							if($sitePlugin !== FALSE)
							{
								if($HTTP_VARS['op'] == 'site-search')
								{
									$return_val = handle_site_search($sitePlugin, $HTTP_VARS, $errors);
									if($return_val === "__EXACT_TITLE_MATCH__")
									{
										// do nothing - we have an exact match, so shall fall down
										// to do site / refresh operation instead.
									}
									else if($return_val !== FALSE)
									{
										// display search page and break out.
										do_op_title($parent_item_r, $item_r, $status_type_r, 'site-search');
										echo $return_val;
										break;
									}
									else
									{
										do_op_title($parent_item_r, $item_r, $status_type_r, 'site-search');
										echo format_error_block($errors);
										break;
									}
								}//if($HTTP_VARS['op'] == 'site-search')
								else 
								{
									if($sitePlugin->_queryItem($HTTP_VARS) !== TRUE)
									{
										// display error
										do_op_title($parent_item_r, $item_r, $status_type_r, 'new');
										
										$errors = $sitePlugin->getErrors();
										
										// we need to provide at least some indication of why there was a problem.
										if($errors === FALSE)
											$errors = $LANG_VARS['undefined_error'];
											
										echo format_error_block($errors);
										break;
									}
								}
								
								// special case where exact match.
								$site_item_attributes_r = $sitePlugin->getItemData($item_r['s_item_type']);
								if(is_not_empty_array($site_item_attributes_r))
								{
									$HTTP_VARS = array_merge($HTTP_VARS, $site_item_attributes_r);
									
									if(is_exists_item($item_r['item_id']))
									{
										$HTTP_VARS['op'] = 'refresh';
											
										do_op_title($parent_item_r, $item_r, $status_type_r, 'edit');
										
										// if site plugin configured title articles, then overwrite configuration.
										$titleArticlesConfig = $sitePlugin->getConfigValue('item_input.title_articles');
										if(is_array($titleArticlesConfig))
										{
											$CONFIG_VARS['item_input.title_articles'] = $titleArticlesConfig;	
										}
										
										$formContents = handle_edit_or_refresh($HTTP_VARS['op'], $parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $dummy_http_post_vars, $errors);
										if($formContents !== FALSE)
										{
											echo $formContents;
											
											// Do not display child items block, if edit/refresh for a child item!
											if(is_empty_array($parent_item_r))
												echo get_child_item_table($HTTP_VARS['op'], $parent_item_r, $item_r, $HTTP_VARS);
										}
										else
										{
											echo format_error_block($errors);
										}
											
										if(is_not_empty_array($parent_item_r))
										{
											$footer_links_r[] = array(url=>"item_input.php?op=edit&item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['edit_parent']);
											$footer_links_r[] = array(url=>"item_display.php?item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_parent']);
										}
									}
									else
									{
										$HTTP_VARS['op'] = 'new';
										
										do_op_title($parent_item_r, $item_r, $status_type_r, 'new');
										
										// if site plugin configured title articles, then overwrite configuration.
										$titleArticlesConfig = $sitePlugin->getConfigValue('item_input.title_articles');
										if(is_array($titleArticlesConfig))
										{
											$CONFIG_VARS['item_input.title_articles'] = $titleArticlesConfig;	
										}
										
										$formContents = handle_new_or_site('site', $parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $dummy_http_post_vars, $errors);
										if($formContents !== FALSE)
											echo $formContents;
										else
											echo format_error_block($errors);
														
										if(is_not_empty_array($parent_item_r))
										{
											$footer_links_r[] = array(url=>"item_input.php?op=edit&item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['edit_parent']);
											$footer_links_r[] = array(url=>"item_display.php?item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_parent']);
										}
									}
									break;
								}
								else
								{
									// no info found - drop down to new operation.
									$HTTP_VARS['op'] = 'new';
								}
							}//if($sitePlugin !== FALSE)
							else
							{
							    do_op_title($parent_item_r, $item_r, $status_type_r, $HTTP_VARS['op']);
							    
								echo format_error_block($LANG_VARS['undefined_error']);
								
								opendb_logger(OPENDB_LOG_ERROR, 'item_input.php', NULL, 'Site Plugin Class not Found', NULL, $HTTP_VARS);
								
								break;
							}
							
						case 'new': //add item
							do_op_title($parent_item_r, $item_r, $status_type_r, 'new');
							
							$formContents = handle_new_or_site($HTTP_VARS['op'], $parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $HTTP_POST_FILES, $errors);
							if($formContents !== FALSE)
								echo $formContents;
							else
							{
								echo format_error_block($errors);
							}
													
							if(is_not_empty_array($parent_item_r))
							{
								$footer_links_r[] = array(url=>"item_input.php?op=edit&item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['edit_parent']);
								$footer_links_r[] = array(url=>"item_display.php?item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_parent']);
							}
							
							break;
							
						case 'edit':// edit item
							do_op_title($parent_item_r, $item_r, $status_type_r, 'edit');
							
							$formContents = handle_edit_or_refresh($HTTP_VARS['op'], $parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $HTTP_POST_FILES, $errors);
							if($formContents !== FALSE)
							{
								echo $formContents;
								
								// Do not display child items block, if edit/refresh for a child item!
								if(is_empty_array($parent_item_r))
									echo get_child_item_table($HTTP_VARS['op'], $parent_item_r, $item_r, $HTTP_VARS);
							}
							else
							{
								echo format_error_block($errors);
							}
								
							if(is_not_empty_array($parent_item_r))
							{
								$footer_links_r[] = array(url=>"item_input.php?op=edit&item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['edit_parent']);
								$footer_links_r[] = array(url=>"item_display.php?item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_parent']);
							}
								
							break;
						
						default:
							echo _theme_header($LANG_VARS['operation_not_available']);
							echo format_error_block($LANG_VARS['operation_not_available']);
						
							if(is_not_empty_array($parent_item_r))
							{
								$footer_links_r[] = array(url=>"item_display.php?item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_parent']);
							}
								
							// Listing link.
							if($HTTP_VARS['listing_link'] == 'y' && is_array($HTTP_SESSION_VARS['listing_url_vars']))
							{
								$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
							}
					}
				}
				else//if(is_not_empty_array($status_type_r))
				{
					$page_title = replace_lang_var("s_status_type", ifempty((is_not_empty_array($parent_item_r)?$parent_item_r['s_status_type']:$item_r['s_status_type']),$HTTP_VARS['s_status_type']), $LANG_VARS['invalid_s_status_type']);
					echo _theme_header($page_title);
					echo format_error_block($page_title);
						
					// Listing link.
					if($HTTP_VARS['listing_link'] == 'y' && is_array($HTTP_SESSION_VARS['listing_url_vars']))
					{
						$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
					}
				}
			}
			else //if(is_not_empty_array($item_r))
			{
				if(is_not_empty_array($parent_item_r))
				{
					echo _theme_header($LANG_VARS['linked_item_not_found']);
					echo format_error_block($LANG_VARS['linked_item_not_found']);
						
					$footer_links_r[] = array(url=>"item_display.php?item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_parent']);
				}
				else
				{
					echo _theme_header($LANG_VARS['item_not_found']);
					echo format_error_block($LANG_VARS['item_not_found']);
				}
					
				// Listing link.
				if($HTTP_VARS['listing_link'] == 'y' && is_array($HTTP_SESSION_VARS['listing_url_vars']))
				{
					$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
				}
			}
		}
		else //if(!is_numeric($HTTP_VARS['parent_id']) || is_not_empty_array($parent_item_r))
		{
			echo _theme_header($LANG_VARS['parent_item_not_found']);
			echo format_error_block($LANG_VARS['parent_item_not_found']);
			
			// Listing link.
			if($HTTP_VARS['listing_link'] == 'y' && is_array($HTTP_SESSION_VARS['listing_url_vars']))
			{
				$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
			}
		}
	
		echo format_footer_links($footer_links_r);
		echo _theme_footer();
	}	
	else
	{
		// invalid login, so login instead.
		include("./login.php");
	}
}//if($CONFIG_VARS['site.enable']!==FALSE)
else
{
	echo _theme_header($LANG_VARS['site_is_disabled'], FALSE);
	echo _theme_error($LANG_VARS['site_is_disabled']);
	echo _theme_footer();
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
