#
# Patch for 0.62 - 0.80
# Address functionality
#

DROP TABLE IF EXISTS s_address_type;
CREATE TABLE s_address_type (
  s_address_type			varchar(10) NOT NULL,
  description				varchar(30) NOT NULL,
  display_order				tinyint(2),
  min_create_user_type		varchar(1) NOT NULL default 'B', # borrower
  min_display_user_type		varchar(1) NOT NULL default 'N', # normal
  compulsory_for_user_type	varchar(1) NOT NULL default 'B', # normal
  closed_ind				varchar(1) NOT NULL default 'N',
  PRIMARY KEY ( s_address_type )
) TYPE=MyISAM COMMENT='System address type';

INSERT INTO s_address_type ( s_address_type, description, display_order, min_create_user_type, min_display_user_type, compulsory_for_user_type )
VALUES ( 'EMAIL', 'Email Address', '1', 'B', 'N', 'B' );

INSERT INTO s_address_type ( s_address_type, description, display_order, min_create_user_type, min_display_user_type, compulsory_for_user_type )
VALUES ( 'SNAIL', 'Postal Address', '2', 'B', 'B', 'B' );

#
# Address type attributes
#
# cleanup
DELETE FROM s_attribute_type WHERE s_attribute_type IN ('ADDR_LINE', 'CITY', 'STATE', 'POSTCODE', 'COUNTRY', 'PHONE_NO', 'EMAIL_ADDR');

INSERT INTO s_attribute_type ( s_attribute_type, description, prompt, input_type, display_type, s_field_type )
VALUES ( 'ADDR_LINE', 'Address Line', 'Address', 'text(50,255)', 'display(%value%)', 'ADDRESS' );

INSERT INTO s_attribute_type ( s_attribute_type, description, prompt, input_type, display_type, s_field_type )
VALUES ( 'CITY', 'City', 'City', 'text(50,100)', 'display(%value%)', 'ADDRESS' );

INSERT INTO s_attribute_type ( s_attribute_type, description, prompt, input_type, display_type, s_field_type )
VALUES ( 'STATE', 'State', 'State', 'text(20,100)', 'display(%display%)', 'ADDRESS' );

INSERT INTO s_attribute_type ( s_attribute_type, description, prompt, input_type, display_type, s_field_type )
VALUES ( 'POSTCODE', 'Post code', 'Postcode', 'number(10)', 'display(%value%)', 'ADDRESS' );

INSERT INTO s_attribute_type ( s_attribute_type, description, prompt, input_type, display_type, s_field_type )
VALUES ( 'COUNTRY', 'Country', 'Country', 'single_select(%display%)', 'display(%value% - %display%)', 'ADDRESS' );

INSERT INTO s_attribute_type ( s_attribute_type, description, prompt, input_type, display_type, s_field_type )
VALUES ( 'PHONE_NO', 'Phone Number', 'Phone', 'filtered(20,50,0-9 \\\\-+)', 'display(%value%)', 'ADDRESS' );

INSERT INTO s_attribute_type ( s_attribute_type, description, prompt, input_type, display_type, s_field_type )
VALUES ( 'EMAIL_ADDR', 'Email address', 'Email', 'email(30,50)', 'display(%value%)', 'ADDRESS' );

#
# Address Type Attribute relationship
#
DROP TABLE IF EXISTS s_addr_attribute_type_rltshp;
CREATE TABLE s_addr_attribute_type_rltshp (
  s_address_type		varchar(10) NOT NULL,
  s_attribute_type		varchar(10) NOT NULL,
  order_no				tinyint(3) unsigned NOT NULL,
  prompt				varchar(30),
  min_create_user_type	varchar(1),
  min_display_user_type	varchar(1),
  compulsory_for_user_type	varchar(1),
  closed_ind			varchar(1) NOT NULL default 'N',
  PRIMARY KEY ( s_address_type, s_attribute_type, order_no )
) TYPE=MyISAM COMMENT='System address attribute type relationship';

INSERT INTO s_addr_attribute_type_rltshp (s_address_type, s_attribute_type, order_no, prompt, min_create_user_type, min_display_user_type, compulsory_for_user_type, closed_ind)
VALUES ( 'EMAIL', 'EMAIL_ADDR', '1', NULL, NULL, NULL, NULL, 'N' );
INSERT INTO s_addr_attribute_type_rltshp (s_address_type, s_attribute_type, order_no, prompt, min_create_user_type, min_display_user_type, compulsory_for_user_type, closed_ind)
VALUES ( 'SNAIL', 'ADDR_LINE', '1', 'Address Line 1', NULL, NULL, NULL, 'N' );
INSERT INTO s_addr_attribute_type_rltshp (s_address_type, s_attribute_type, order_no, prompt, min_create_user_type, min_display_user_type, compulsory_for_user_type, closed_ind)
VALUES ( 'SNAIL', 'ADDR_LINE', '2', 'Address Line 2', NULL, NULL, '*', 'N' );
INSERT INTO s_addr_attribute_type_rltshp (s_address_type, s_attribute_type, order_no, prompt, min_create_user_type, min_display_user_type, compulsory_for_user_type, closed_ind)
VALUES ( 'SNAIL', 'CITY', '3', NULL, NULL, NULL, NULL, 'N' );
INSERT INTO s_addr_attribute_type_rltshp (s_address_type, s_attribute_type, order_no, prompt, min_create_user_type, min_display_user_type, compulsory_for_user_type, closed_ind)
VALUES ( 'SNAIL', 'STATE', '4', NULL, NULL, NULL, NULL, 'N' );
INSERT INTO s_addr_attribute_type_rltshp (s_address_type, s_attribute_type, order_no, prompt, min_create_user_type, min_display_user_type, compulsory_for_user_type, closed_ind)
VALUES ( 'SNAIL', 'POSTCODE', '5', NULL, NULL, NULL, NULL, 'N' );
INSERT INTO s_addr_attribute_type_rltshp (s_address_type, s_attribute_type, order_no, prompt, min_create_user_type, min_display_user_type, compulsory_for_user_type, closed_ind)
VALUES ( 'SNAIL', 'COUNTRY', '6', NULL, NULL, NULL, NULL, 'N' );
INSERT INTO s_addr_attribute_type_rltshp (s_address_type, s_attribute_type, order_no, prompt, min_create_user_type, min_display_user_type, compulsory_for_user_type, closed_ind)
VALUES ( 'SNAIL', 'PHONE_NO', '10', 'Home Phone', NULL, NULL, NULL, 'N' );
INSERT INTO s_addr_attribute_type_rltshp (s_address_type, s_attribute_type, order_no, prompt, min_create_user_type, min_display_user_type, compulsory_for_user_type, closed_ind)
VALUES ( 'SNAIL', 'PHONE_NO', '11', 'Work Phone', NULL, NULL, '*', 'N' );
INSERT INTO s_addr_attribute_type_rltshp (s_address_type, s_attribute_type, order_no, prompt, min_create_user_type, min_display_user_type, compulsory_for_user_type, closed_ind)
VALUES ( 'SNAIL', 'PHONE_NO', '12', 'Mobile Phone', NULL, NULL, '*', 'N' );

#
# User address
#
DROP TABLE IF EXISTS user_address;
CREATE TABLE user_address (
  sequence_number	integer(10) unsigned NOT NULL auto_increment,
  user_id			varchar(20) NOT NULL,
  s_address_type	varchar(10) NOT NULL,
  start_dt			date NOT NULL default '0000-00-00',
  end_dt			date,
  update_on			timestamp(14) NOT NULL,
  PRIMARY KEY ( sequence_number ),
  KEY user_address_idx ( user_id, s_address_type, start_dt )
) TYPE=MyISAM COMMENT='User address';

#
# User address attribute
#
DROP TABLE IF EXISTS user_address_attribute;
CREATE TABLE user_address_attribute (
  ua_sequence_number	integer(10) unsigned NOT NULL,
  s_attribute_type		varchar(10) NOT NULL,
  order_no				tinyint(3) unsigned NOT NULL,
  lookup_attribute_val 	varchar(50) NOT NULL,
  attribute_val			text,
  update_on				timestamp(14) NOT NULL,
  PRIMARY KEY ( ua_sequence_number, s_attribute_type, order_no, lookup_attribute_val )
) TYPE=MyISAM COMMENT='User address attribute';

#
# Country lookups
#
# cleanup
DELETE FROM s_attribute_type_lookup WHERE s_attribute_type IN('COUNTRY');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'AF', 'AFGHANISTAN', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'AL', 'ALBANIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'DZ', 'ALGERIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'AS', 'AMERICAN SAMOA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'AD', 'ANDORRA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'AO', 'ANGOLA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'AI', 'ANGUILLA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'AQ', 'ANTARCTICA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'AG', 'ANTIGUA AND BARBUDA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'AZ', 'AZERBAIJAN', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'AR', 'ARGENTINA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'AM', 'ARMENIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'AW', 'ARUBA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'AU', 'AUSTRALIA', '', 'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'AT', 'AUSTRIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'BS', 'BAHAMAS', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'BH', 'BAHRAIN', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'BD', 'BANGLADESH', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'BB', 'BARBADOS', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'BY', 'BELARUS', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'BE', 'BELGIUM', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'BZ', 'BELIZE', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'BJ', 'BENIN', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'BM', 'BERMUDA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'BT', 'BHUTAN', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'BO', 'BOLIVIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'BA', 'BOSNIA AND HERZEGOWINA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'BW', 'BOTSWANA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'BV', 'BOUVET ISLAND', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'BR', 'BRAZIL', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'IO', 'BRITISH INDIAN OCEAN TERRITORY', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'BN', 'BRUNEI DARUSSALAM', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'BG', 'BULGARIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'BF', 'BURKINA FASO', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'BI', 'BURUNDI', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'CA', 'CANADA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'KH', 'CAMBODIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'CM', 'CAMEROON', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'CV', 'CAPE VERDE', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'CF', 'CENTRAL AFRICAN REPUBLIC', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'TD', 'CHAD', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'CL', 'CHILE', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'CN', 'CHINA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'CX', 'CHRISTMAS ISLAND', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'CC', 'COCOS (KEELING) ISLANDS', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'CO', 'COLOMBIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'KM', 'COMOROS', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'CG', 'CONGO', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'CD', 'CONGO, THE DEMOCRATIC REPUBLIC OF THE', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'CK', 'COOK ISLANDS', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'CR', 'COSTA RICA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'CI', 'COTE D\'IVOIRE', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'HR', 'CROATIA (localname:Hrvatska)', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'CU', 'CUBA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'CY', 'CYPRUS', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'CZ', 'CZECH REPUBLIC', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'DE', 'GERMANY', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'DK', 'DENMARK', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'DJ', 'DJIBOUTI', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'DM', 'DOMINICA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'DO', 'DOMINICAN REPUBLIC', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'TP', 'EAST TIMOR', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'EC', 'ECUADOR', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'EG', 'EGYPT', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'SV', 'ELSALVADOR', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'GQ', 'EQUATORIAL GUINEA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'ER', 'ERITREA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'EE', 'ESTONIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'ET', 'ETHIOPIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'FK', 'FALKLAND ISLANDS (MALVINAS)', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'FO', 'FAROE ISLANDS', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'FJ', 'FIJI', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'FI', 'FINLAND', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'FR', 'FRANCE', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'FX', 'FRANCE, METROPOLITAN', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'GF', 'FRENCH GUIANA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'PF', 'FRENCH POLYNESIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'TF', 'FRENCH SOUTHERN TERRITORIES', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'GM', 'GAMBIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'GA', 'GABON', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'GE', 'GEORGIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'GH', 'GHANA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'GI', 'GIBRALTAR', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'GR', 'GREECE', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'GL', 'GREENLAND', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'GD', 'GRENADA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'GP', 'GUADELOUPE', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'GU', 'GUAM', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'GT', 'GUATEMALA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'GN', 'GUINEA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'GW', 'GUINEA-BISSAU', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'GY', 'GUYANA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'HT', 'HAITI', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'HM', 'HEARD AND MCDONALD ISLANDS', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'HN', 'HONDURAS', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'HK', 'HONGKONG', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'HU', 'HUNGARY', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'IS', 'ICELAND', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'ID', 'INDONESIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'IL', 'ISRAEL', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'IN', 'INDIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'IR', 'IRAN (ISLAMIC REPUBLIC OF)', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'IQ', 'IRAQ', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'IE', 'IRELAND', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'IT', 'ITALY', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'JM', 'JAMAICA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'JP', 'JAPAN', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'JO', 'JORDAN', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'KZ', 'KAZAKHSTAN', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'KY', 'CAYMAN ISLANDS', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'KE', 'KENYA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'KI', 'KIRIBATI', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'KP', 'KOREA, DEMOCRATIC PEOPLE\'S REPUBLIC OF', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'KR', 'KOREA, REPUBLIC OF', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'KW', 'KUWAIT', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'KG', 'KYRGYZSTAN', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'LV', 'LATVIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'LB', 'LEBANON', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'LS', 'LESOTHO', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'LR', 'LIBERIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'LY', 'LIBYAN ARAB JAMAHIRIYA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'LI', 'LIECHTENSTEIN', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'LT', 'LITHUANIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'LA', 'LAO PEOPLE\'S DEMOCRATIC REPUBLIC', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'LU', 'LUXEMBOURG', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'MK', 'MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'MG', 'MADAGASCAR', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'MW', 'MALAWI', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'MY', 'MALAYSIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'MV', 'MALDIVES', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'ML', 'MALI', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'MH', 'MARSHALL ISLANDS', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'MQ', 'MARTINIQUE', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'MD', 'MOLDOVA, REPUBLIC OF', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'MP', 'NORTHERN MARIANA ISLANDS', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'MA', 'MOROCCO', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'MR', 'MAURITANIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'MU', 'MAURITIUS', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'YT', 'MAYOTTE', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'MX', 'MEXICO', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'FM', 'MICRONESIA, FEDERATED STATES OF', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'MN', 'MONGOLIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'MO', 'MACAU', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'MS', 'MONTSERRAT', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'MT', 'MALTA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'MC', 'MONACO', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'MZ', 'MOZAMBIQUE', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'MM', 'MYANMAR', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'NR', 'NAURU', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'NE', 'NIGER', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'NP', 'NEPAL', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'NL', 'NETHERLANDS', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'AN', 'NETHERLANDS ANTILLES', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'NZ', 'NEW ZEALAND', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'NF', 'NORFOLK ISLAND', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'NI', 'NICARAGUA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'NG', 'NIGERIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'NU', 'NIUE', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'NC', 'NEW CALEDONIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'NO', 'NORWAY', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'NA', 'NAMIBIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'OM', 'OMAN', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'PK', 'PAKISTAN', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'PW', 'PALAU', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'PS', 'PALESTINIAN TERRITORY, OCCUPIED', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'PG', 'PAPUA NEW GUINEA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'PY', 'PARAGUAY', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'PA', 'PANAMA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'PH', 'PHILIPPINES', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'PN', 'PITCAIRN', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'PL', 'POLAND', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'PT', 'PORTUGAL', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'PE', 'PERU', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'PR', 'PUERTO RICO', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'QA', 'QATAR', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'RE', 'REUNION', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'RO', 'ROMANIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'RU', 'RUSSIAN FEDERATION', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'RW', 'RWANDA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'KN', 'SAINT KITTS AND NEVIS', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'LC', 'SAINT LUCIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'VC', 'SAINT VINCENT AND THE GRENADINES', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'WS', 'SAMOA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'SM', 'SANMARINO', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'ST', 'SAO TOME AND PRINCIPE', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'SK', 'SLOVAKIA (Slovak Republic)', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'SA', 'SAUDI ARABIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'SN', 'SENEGAL', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'SL', 'SIERRA LEONE', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'SG', 'SINGAPORE', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'SI', 'SLOVENIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'SB', 'SOLOMON ISLANDS', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'SO', 'SOMALIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'SC', 'SEYCHELLES', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'ZA', 'SOUTH AFRICA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'GS', 'SOUTH GEORGIA AND THE SOUTHS AND WICH ISLANDS', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'SD', 'SUDAN', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'ES', 'SPAIN', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'LK', 'SRI LANKA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'SH', 'ST.HELENA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'PM', 'ST.PIERRE AND MIQUELON', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'SR', 'SURINAME', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'SJ', 'SVALBARD AND JANMAYEN ISLANDS', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'SZ', 'SWAZILAND', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'SE', 'SWEDEN', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'CH', 'SWITZERLAND', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'SY', 'SYRIAN ARAB REPUBLIC', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'TW', 'TAIWAN, PROVINCE OF CHINA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'TJ', 'TAJIKISTAN', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'TZ', 'TANZANIA, UNITED REPUBLIC OF', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'TN', 'TUNISIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'TH', 'THAILAND', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'TG', 'TOGO', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'TK', 'TOKELAU', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'TO', 'TONGA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'TT', 'TRINIDAD AND TOBAGO', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'TR', 'TURKEY', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'TM', 'TURKMENISTAN', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'TC', 'TURKS AND CAICOS ISLANDS', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'TV', 'TUVALU', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'UG', 'UGANDA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'UA', 'UKRAINE', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'AE', 'UNITED ARAB EMIRATES', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'GB', 'UNITED KINGDOM', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'US', 'UNITED STATES', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'UM', 'UNITED STATES MINOR OUTLYING ISLANDS', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'UY', 'URUGUAY', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'UZ', 'UZBEKISTAN', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'VU', 'VANUATU', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'VE', 'VENEZUELA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'VN', 'VIETNAM', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'VA', 'HOLY SEE (VATICAN CITY STATE)', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'VG', 'VIRGIN ISLANDS (BRITISH)', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'VI', 'VIRGIN ISLANDS (U.S.)', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'WF', 'WALLIS AND FUTUNA ISLANDS', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'EH', 'WESTERN SAHARA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'YE', 'YEMEN', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'YU', 'YUGOSLAVIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'ZM', 'ZAMBIA', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'COUNTRY', NULL, 'ZW', 'ZIMBABWE', '', '');
