<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/status_type.php");
include_once("./functions/user.php");

/*
* If more than one default_ind=Y record, then the one being updated,can be updated
* safely.
*/
function fetch_default_status_type_cnt()
{
	$query = "SELECT count('x') as count FROM s_status_type WHERE closed_ind <> 'Y' AND default_ind = 'Y'";
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		if ($found!== FALSE)
			return $found['count'];
	}

	//else
	return FALSE;
}

function is_exists_items_with_status_type($s_status_type)
{
	$query = "SELECT 'x' FROM item_instance WHERE s_status_type = '".$s_status_type."'";
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		mysql_free_result($result);
		return TRUE;
	}

	//else
	return FALSE;
}

function is_exists_items_for_user_type_and_status_type($s_status_type, $user_type)
{
	$query = "SELECT 'x' ".
			"FROM item_instance ii, user u ".
			"WHERE ii.owner_id = u.user_id AND ".
			"ii.s_status_type = '$s_status_type' AND ".
			"IF(LENGTH(type)>0,u.type,'N') IN(".format_sql_in_clause(get_min_user_type_r($user_type)).")";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		mysql_free_result($result);
		return TRUE;
	}

	//else
	return FALSE;
}

function is_exists_borrowed_items_for_status_type($s_status_type, $borrowed_items_only = FALSE)
{
	$query = "SELECT 'x' ".
			"FROM item_instance ii, borrowed_item bi ".
			"WHERE ii.item_id = bi.item_id AND ".
			"ii.instance_no = bi.instance_no AND ".
			"ii.s_status_type = '$s_status_type' ";

	if($borrowed_items_only)
	{
		$query .= "AND bi.status = 'B'";
	}
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		mysql_free_result($result);
		return TRUE;
	}

	//else
	return FALSE;
}

function validate_ind_column($column, $options_r=NULL)
{
	$column = strtoupper($column);
	
	if(is_array($options_r) && array_search2($column, $options_r)!==FALSE)
		return $column;
	else if($column == 'Y')
		return 'Y';
	else
		return 'N';
}

/*
* A single user type is all that is allowed.
*/
function validate_user_type_column($column)
{
	if(strlen(trim($column))>0)
	{
		if(is_usertype_valid(trim($column)))
			return trim($column);
		else
			return FALSE;
	}
	else
		return "";
}

function insert_s_status_type($s_status_type, $description, $img, 
							$insert_ind, $update_ind, $delete_ind, $change_owner_ind, 
							$min_display_user_type,	$min_create_user_type,
							$new_owner_instance_ind, $new_not_owner_instance_ind,
							$borrow_ind, $status_comment_ind, $default_ind)
{
	global $HTTP_SESSION_VARS;
	
	$s_status_type = strtoupper(substr(trim($s_status_type),0,1));
	
	// this should never happen.
	if(strlen(trim($s_status_type))==0)
	{
		return FALSE;
	}
	
	$description = addslashes(trim(strip_tags($description)));

	// do this one first, as we need to validate the data for the others based on this one.
	$change_owner_ind = validate_ind_column($change_owner_ind);

	$insert_ind = validate_ind_column($insert_ind);
	$update_ind = validate_ind_column($update_ind);
	$delete_ind = validate_ind_column($delete_ind);
	
	$min_display_user_type = validate_user_type_column($min_display_user_type);
	
	if($change_owner_ind == 'Y')
		$min_create_user_type = 'N'; // normal user minimum
	else
		$min_create_user_type = validate_user_type_column($min_create_user_type);
	
	if($change_owner_ind == 'Y')
	{
		$new_owner_instance_ind = 'Y'; // this will change
		$new_not_owner_instance_ind = 'Y'; // this will change
	}
	else
	{
		$new_owner_instance_ind = validate_ind_column($new_owner_instance_ind);
		$new_not_owner_instance_ind = validate_ind_column($new_not_owner_instance_ind);
	}
	
	$borrow_ind = validate_ind_column($borrow_ind, array('Y','N','B','X'));
	
	$query = "INSERT INTO s_status_type ( s_status_type, description, img, insert_ind, update_ind, delete_ind, change_owner_ind, min_display_user_type, min_create_user_type, new_owner_instance_ind, new_not_owner_instance_ind, borrow_ind, status_comment_ind, default_ind, closed_ind )".
			"VALUES ('$s_status_type', '$description', '$img', '$insert_ind', '$update_ind', '$delete_ind', '$change_owner_ind', '$min_display_user_type', '$min_create_user_type', '$new_owner_instance_ind', '$new_not_owner_instance_ind', '$borrow_ind', '$status_comment_ind', '$default_ind', 'N')";

	$insert = run_opendb_query($query);
	// We should not treat updates that were not actually updated because value did not change as failures.
	$rows_affected = mysql_affected_rows();
	if($insert && $rows_affected !== -1)
	{
		if($rows_affected>0)
			opendb_log("Inserted s_status_type (s_status_type=$s_status_type, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to insert s_status_type (s_status_type=$s_status_type, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
	
	//else
	return FALSE;
}

/*
*/
function update_s_status_type($s_status_type, $description, $img, 
							$insert_ind, $update_ind, $delete_ind, $change_owner_ind,
							$min_display_user_type,	$min_create_user_type,
							$new_owner_instance_ind, $new_not_owner_instance_ind,
							$borrow_ind, $status_comment_ind, $default_ind,
							$closed_ind)
{
	global $HTTP_SESSION_VARS;
	
	$s_status_type = strtoupper($s_status_type);
	$description = addslashes(trim(strip_tags($description)));

	// do this one first, as we need to validate the data for the others based on this one.
	$change_owner_ind = validate_ind_column($change_owner_ind);
	
	$insert_ind = validate_ind_column($insert_ind);
	$update_ind = validate_ind_column($update_ind);
	$delete_ind = validate_ind_column($delete_ind);
	
	$min_display_user_type = validate_user_type_column($min_display_user_type);
	
	if($change_owner_ind == 'Y')
		$min_create_user_type = 'N'; // normal user minimum
	else
		$min_create_user_type = validate_user_type_column($min_create_user_type);
	
	if($change_owner_ind == 'Y')
	{
		$new_owner_instance_ind = 'Y'; // this will change
		$new_not_owner_instance_ind = 'Y'; // this will change
	}
	else
	{
		$new_owner_instance_ind = validate_ind_column($new_owner_instance_ind);
		$new_not_owner_instance_ind = validate_ind_column($new_not_owner_instance_ind);
	}
	
	$borrow_ind = validate_ind_column($borrow_ind, array('Y','N','B','X'));
		
	$status_comment_ind = validate_ind_column($status_comment_ind, array('Y','N','H'));
	$default_ind = validate_ind_column($default_ind);
	$closed_ind = validate_ind_column($closed_ind);
	
	$query = "UPDATE s_status_type ".
				"SET description = '$description', ".
				"img = '$img', ".
				"insert_ind = '$insert_ind', ".
				"update_ind = '$update_ind', ".
				"delete_ind = '$delete_ind', ".
				"change_owner_ind = '$change_owner_ind', ".
				"min_display_user_type = '$min_display_user_type', ".
				"min_create_user_type = '$min_create_user_type', ".
				"new_owner_instance_ind = '$new_owner_instance_ind', ".
				"new_not_owner_instance_ind = '$new_not_owner_instance_ind', ".
				"borrow_ind = '$borrow_ind', ".
				"status_comment_ind = '$status_comment_ind', ".
				"default_ind = '$default_ind', ".
				"closed_ind = '$closed_ind' ".
			" WHERE s_status_type = '$s_status_type'";

	$update = run_opendb_query($query);

	// We should not treat updates that were not actually updated because value did not change as failures.
	$rows_affected = mysql_affected_rows();
	if($update && $rows_affected !== -1)
	{
		if($rows_affected>0)
			opendb_log("Updated s_status_type (s_status_type=$s_status_type, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to update s_status_type (s_status_type=$s_status_type, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
	
	//else
	return FALSE;
}

function delete_s_status_type($s_status_type)
{
	global $HTTP_SESSION_VARS;

	$s_status_type = strtoupper($s_status_type);
		
	$query = "DELETE FROM s_status_type "
			."WHERE s_status_type = '$s_status_type'";

	$delete = run_opendb_query($query);
	
	// We should not treat updates that were not actually updated because value did not change as failures.
	$rows_affected = mysql_affected_rows();
	if($delete && $rows_affected !== -1)
	{
		if($rows_affected>0)
			opendb_log("Deleted s_status_type (s_status_type=$s_status_type, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to delete s_status_type (s_status_type=$s_status_type, update_who=".$HTTP_SESSION_VARS['user_id']."). [".mysql_error()."]");
		return FALSE;
	}
	
	//else
	return FALSE;
}
?>