#
# plugin.sql site plugin definition
#

#
# Cleanup
#
DELETE FROM s_site_plugin WHERE site_type = 'plugin';
DELETE FROM s_site_plugin_conf WHERE site_type = 'plugin';
DELETE FROM s_site_plugin_input_field WHERE site_type = 'plugin';
DELETE FROM s_site_plugin_link WHERE site_type = 'plugin';
DELETE FROM s_site_plugin_s_attribute_type_map WHERE site_type = 'plugin';
DELETE FROM s_site_plugin_s_attribute_type_lookup_map WHERE site_type = 'plugin';

INSERT INTO s_site_plugin (site_type, classname, order_no, title, image, description, external_url, items_per_page, more_info_url)
VALUES('plugin', 'plugin', 1, 'Plugin.com', 'plugin.gif', 'A site plugin description', 'http://www.plugin.com', 25, '');

#
# Input Fields
#	
INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('plugin', 'title', 1, '', 'Title Search', 'text', '', '{title}');

INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('plugin', 'pluginid', 2, '', 'ID Number', 'text', '', '{pluginid}');

#
# Links
#
INSERT INTO s_site_plugin_link(site_type, s_item_type_group, s_item_type, order_no, description, url, title_url)
VALUES('plugin', '*', '*', 1, 'More Info', 'http://www.plugin.com/{pluginid}', 'http://www.plugin.com/search.php?title={title}');

#
# site variable to s_attribute_type mapping
#
INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('plugin', 'title', '*', '*', 'ALT_TITLE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('plugin', 'title', '*', '*', 'S_TITLE');

####################################################################################################
# Item Type / Attribute Type relationships
####################################################################################################

