<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// Include the config file here instead.
include_once("../../include/config.php");

//---------------------------------------------------------------------
// Now include the local site's configuration file, which will override
// anything we've set above.  This saves administrators having to
// re-edit this file after they upgrade OpenDb.
//---------------------------------------------------------------------
if(file_exists("../../include/local_config.php"))
{
	include_once("../../include/local_config.php");
}

include_once("../../functions/Snoopy.class.php");

$snoopy = new Snoopy;

//override user agent.
$snoopy->agent = 'Mozilla/4.77 [en] (Windows NT 5.0; U)';

// if no proxy
if($CONFIG_VARS['proxy_server.enable']==TRUE)
{
	echo '<br>Proxy server ENABLED';
	echo '<br>proxy_host: '.$CONFIG_VARS['proxy_server.host'];
	echo '<br>proxy_port: '.$CONFIG_VARS['proxy_server.port'];
	echo '<br>user: '.$CONFIG_VARS['proxy_server.userid'];
	echo '<br>pass: '.$CONFIG_VARS['proxy_server.password'];
	
	$snoopy->proxy_host = $CONFIG_VARS['proxy_server.host'];
	$snoopy->proxy_port = $CONFIG_VARS['proxy_server.port'];
	$snoopy->user = $CONFIG_VARS['proxy_server.userid'];
	$snoopy->pass = $CONFIG_VARS['proxy_server.password'];
}
else
{
	echo '<br>Proxy server DISABLED';
}

if($snoopy->fetch('http://www.sourceforge.net/projects/opendb'))
{
	echo '<br>Fetch successful.';
	if($snoopy->status >= 200 && $snoopy->status < 300)
	{
		$result = $snoopy->results;
		echo '<br>Size of result returned: '.strlen($result);
	}
	else
	{
		echo 'URL returned a non 200 status (Status-'.$snoopy->status.'; Error-'.$snoopy->error.')';
	}
}
else
{
	echo 'Failed to open URL (Status-'.$snoopy->status.'; Error-'.$snoopy->error.')';
}
?>
