#
# iblist.sql site plugin definition
#

#
# Cleanup
#
DELETE FROM s_site_plugin WHERE site_type = 'iblist';
DELETE FROM s_site_plugin_conf WHERE site_type = 'iblist';
DELETE FROM s_site_plugin_input_field WHERE site_type = 'iblist';
DELETE FROM s_site_plugin_link WHERE site_type = 'iblist';
DELETE FROM s_site_plugin_s_attribute_type_map WHERE site_type = 'iblist';
DELETE FROM s_site_plugin_s_attribute_type_lookup_map WHERE site_type = 'iblist';

INSERT INTO s_site_plugin (site_type, classname, order_no, title, image, description, external_url, items_per_page, more_info_url)
VALUES('iblist', 'iblist', 1, 'Internet Book List', 'iblist.jpg', 'Internet Book List provide a comprehensive and easily accessible database of books.', 'http://www.iblist.com', 50, 'http://www.iblist.com/book.php?id={iblist_id}');

#
# Input Fields
#	
INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('iblist', 'title', 1, '', 'Title Search', 'text', '', '{title}');

INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('iblist', 'author', 2, '', 'Author', 'text', '', '{author}');

INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('iblist', 'isbn', 3, '', 'ISBN', 'text', '', '{isbn}');

INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('iblist', 'iblist_id', 4, '', 'ID Number', 'hidden', '', '{iblist_id}');

#
# Links
#
INSERT INTO s_site_plugin_link(site_type, s_item_type_group, s_item_type, order_no, description, url, title_url)
VALUES('iblist', '*', '*', 1, 'More Info', 'http://www.iblist.com/book.php?id={iblist_id}', '');

#
# site variable to s_attribute_type mapping
#
INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('iblist', 'title', '*', '*', 'ALT_TITLE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('iblist', 'title', '*', '*', 'S_TITLE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('iblist', 'plot', '*', '*', 'SYNOPSIS');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('iblist', 'genre', '*', '*', 'BOOKGENRE');

####################################################################################################
# Item Type / Attribute Type relationships
####################################################################################################

INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'IBLIST_ID', 'IBList ID Number', 'IBList ID', 'hidden', 'hidden', NULL, 'iblist');
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'BOOK', 'IBLIST_ID', '0', NULL, NULL);
