<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
	* 
	* Search for 'Rambo' to return a list of various titles.
		Search for '12 Angry Men' to get an exact title match.
		Search for 'faddsda' to trigger a search error.
*/
include_once("./functions/SitePlugin.class.inc");

function get_hello_param()
{
	global $CONFIG_VARS;
	
	return "opendb+".get_http_env('HTTP_HOST')."+".urlencode($CONFIG_VARS['site.title'])."+".$CONFIG_VARS['site.version'];
}
//
// Search for 'Shitters' to return no titles.
// Search for 'Cunt' to get a single title.
// Search for 'Filthy Fuckers' to get an exact title match.
// Search for 'Chocolat' will return a single 'Most Popular' and multiple actual entries.
//
class freedb extends SitePlugin
{
	function freedb($site_type)
	{
		parent::SitePlugin($site_type);
	}
	
	function queryListing($page_no, $items_per_page, $offset, $s_item_type, $search_vars_r)
	{
	
		if(strlen($search_vars_r['freedb_id'])>0 && strlen($search_vars_r['cddbgenre'])>0)
		{
			$this->addListingRow(NULL, NULL, NULL, array('freedb_id'=>$search_vars_r['freedb_id'], 'cddbgenre'=>$search_vars_r['cddbgenre']));
			return TRUE;
		}
		else
		{
			$pageBuffer = $this->fetchURI("http://freedb2.org/~cddb/cddb.cgi?cmd=cddb+album+".urlencode($search_vars_r['title'])."&hello=".get_hello_param()."&proto=5");
		}
		
		if(strlen($pageBuffer)>0)
		{
			$lines = preg_split("/[\r\n]/m", trim($pageBuffer), NULL, PREG_SPLIT_NO_EMPTY);
			if(is_not_empty_array($lines))
			{
				$code = NULL;
				if(preg_match("/([0-9]+) ([^$]+)/", $lines[0], $matches))
				{
					$code = $matches[1];
				}
				
				if($code == '211' || $code == '210')
				{
					array_shift($lines);
					array_pop($lines);		
				}
				else
				{
					return TRUE;
				}
				
				//blues 590ff119 Various Artists / Cool, Cool Blues, The Classic Sides (1951-54) - Disc B (Jackson, MS)
				reset($lines);
				while(list(,$line) = each($lines))
				{
					if(preg_match("/([^\ ]+) ([^\ ]+) ([^$]+)/", $line, $matches))
					{
						//print_r($matches);
						$entry['cddbgenre'] = $matches[1];
						$entry['discid'] = $matches[2];
						$entry['freedb_id'] = $matches[2];
						$entry['title'] = $matches[3];
						
						$idx = strrpos($entry['title'], "/");
						if($idx!==FALSE)
						{
							$entry['artist'] = trim(substr($entry['title'],0, $idx));
							$entry['title'] = substr($entry['title'],$idx+1);
							
							// Now format the title nicely.
							$entry['title'] = initcap($entry['title']);
						}
						
						$this->addListingRow($entry['artist'].' / '.$entry['title'], NULL, $entry['cddbgenre'].'/'.$entry['freedb_id'], array('freedb_id'=>$entry['freedb_id'], 'cddbgenre'=>$entry['cddbgenre']));
					}
				}
			}
			
			//else no results found
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
	
	function queryItem($search_attributes_r, $s_item_type)
	{
		$entryBlock = $this->fetchURI("http://www.freedb2.org/freedb/".$search_attributes_r['cddbgenre']."/".$search_attributes_r['freedb_id']);

		// no sense going any further here.
		if(strlen($entryBlock)==0)
		{
			return FALSE;
		}
				
		// Get runtime
		if(preg_match("/^# Disc length: ([^$]*)$/mU", $entryBlock, $regs))
		{
			if(preg_match("/([0-9]+) seconds/", $regs[1], $regs2))
			{
				$minutes = (int) ($regs2[1] / 60);
				$seconds = $regs2[1] % 60;
				
				//Prefix "0", so that seconds are properly formatted.
				if(strlen($seconds)<2)
					$seconds = "0".$seconds;
					
				$this->addItemAttribute('run_time', $minutes.':'.$seconds);
			}
		}
		
		// get title.
		if(preg_match_all("/^DTITLE=([^$]*)$/mU", $entryBlock, $matches))
		{
			$title = '';
			$artist = '';
			for ($i = 0; $i < count($matches[1]); $i++)
			{
				$title .= $matches[1][$i];
			}
			
			$index = strrpos($title,"/");
			if($index !== FALSE)
			{
				$artist = trim(substr($title, 0, $index));//1="/"
				$title = trim(substr($title, $index+1));//1="/"
			}
				
			// Ensure title is properly formatted.
			$title = initcap($title);
			
			$this->addItemAttribute('artist', $artist);
			$this->addItemAttribute('title', $title);
		}
		
		//get year
		if(preg_match("/^DYEAR=([^$]*)$/mU", $entryBlock, $regs))
		{
			if(strlen(trim($regs[1]))>0)
			{
				$this->addItemAttribute('year', $regs[1]);
			}
		}
		
		// get extended genre
		if(preg_match("/^DGENRE=([^$]*)$/mU", $entryBlock, $regs))
		{
			if(strlen(trim($regs[1]))>0)
			{
				$this->addItemAttribute('genre', $regs[1]);
			}
		}
		
		// Collect titles in two passes
		// In the first pass, just find the raw data: the lines that begin
		// with TITLEnn. A long title can wrap around, e.g.:
		//	TITLE5=This is a ve
		//	TITLE5=ry long title
		// so we append to what's already in $entry[tracks][n].
		$tracks = array();
	 	if(preg_match_all("/^TTITLE([0-9]+)=([^$]+)$/mU", $entryBlock, $matches))
	 	{
	 		for ($i = 0; $i < count($matches[2]); $i++)
			{
				$tracks[$matches[1][$i]] .= $matches[2][$i];
			}
	 	}
	
		// Now that we have the raw titles, clean them up. This is done in
		// a separate loop rather than the preceding one because a title
		// might be split in the middle of a word, so ucwords() would
		// capitalize whatever happened to be at the beginning of a split
		// line ("This Is A VeRy Long Title", above).
		for ($i = 0; $i < count($tracks); $i++)
		{
			$this->addItemAttribute('tracks', initcap(preg_replace('/[\s]+/', ' ', trim($tracks[$i]))));
		}
		
		return TRUE;
	}
}
?>
