/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 2010-2011 OpenCFD Ltd.
     \\/     M anipulation  |
-------------------------------------------------------------------------------
                            | Copyright (C) 2011-2017 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::geometricZeroField

Description
    A class representing the concept of a GeometricField of 0 used to avoid
    unnecessary manipulations for objects which are known to be zero at
    compile-time.

    Used for example as the density argument to a function written for
    compressible to be used for incompressible flow.

\*---------------------------------------------------------------------------*/

#ifndef geometricZeroField_H
#define geometricZeroField_H

#include "zeroFieldField.H"
#include "dimensionSet.H"
#include "scalar.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                      Class geometricZeroField Declaration
\*---------------------------------------------------------------------------*/

class geometricZeroField
:
    public zero
{

public:

    // Public typedefs

        typedef zeroField Internal;
        typedef zeroField Patch;
        typedef zeroFieldField Boundary;
        typedef zero cmptType;


    // Constructors

        //- Construct null
        geometricZeroField()
        {}


    // Member Operators

        inline const dimensionSet& dimensions() const;

        inline scalar operator[](const label) const;

        inline zeroField field() const;

        inline zeroField operator()() const;

        inline zeroField oldTime() const;

        inline zeroFieldField boundaryField() const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#include "geometricZeroFieldI.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
