/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 2004-2010 OpenCFD Ltd.
     \\/     M anipulation  |
-------------------------------------------------------------------------------
                            | Copyright (C) 2011-2012 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::inversePointDistanceDiffusivity

Description
    Inverse distance to the given patches motion diffusivity.

SourceFiles
    inversePointDistanceDiffusivity.C

\*---------------------------------------------------------------------------*/

#ifndef inversePointDistanceDiffusivity_H
#define inversePointDistanceDiffusivity_H

#include "uniformDiffusivity.H"
#include "wordRes.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
               Class inversePointDistanceDiffusivity Declaration
\*---------------------------------------------------------------------------*/

class inversePointDistanceDiffusivity
:
    public uniformDiffusivity
{
    // Private data

        //- Patches selected to base the distance on
        wordRes patchNames_;


    // Private Member Functions

        //- No copy construct
        inversePointDistanceDiffusivity
        (
            const inversePointDistanceDiffusivity&
        ) = delete;

        //- No copy assignment
        void operator=(const inversePointDistanceDiffusivity&) = delete;


public:

    //- Runtime type information
    TypeName("inversePointDistance");


    // Constructors

        //- Construct for the given fvMesh and data Istream
        inversePointDistanceDiffusivity(const fvMesh& mesh, Istream& mdData);


    //- Destructor
    virtual ~inversePointDistanceDiffusivity() = default;


    // Member Functions

        //- Correct the motion diffusivity
        virtual void correct();
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
