/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

class TestFunction : public GTLTest::Case {
  public:
    TestFunction() : GTLTest::Case("TestFunction") {}
    virtual void runTest()
    {
      OpenCTL::Module p("testCall");
      p.setSource( " \
int testCall(int a, int b, int c, int d) \
{ \
  return a + b * ( c / d ); \
}");
      p.compile();
      const GTLCore::Function* function = p.function("testCall");
      GTLTEST_CHECK(function);
      if(function)
      {
        std::vector< GTLCore::Value> arguments;
        int a = 2;
        int b = 4;
        int c = 10;
        int d = 2;
        arguments.push_back( a );
        arguments.push_back( b );
        arguments.push_back( c );
        arguments.push_back( d );
        GTLCore::Value result = function->call( arguments );
        GTLTEST_CHECK_EQUAL( result.type()->dataType(), GTLCore::Type::INTEGER32);
      }
    }
};

