/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _AST_CONVERT_EXPRESSION_H_
#define _AST_CONVERT_EXPRESSION_H_

#include "GTLCore/AST/Expression.h"

namespace GTLCore {
  namespace AST {
    class ConvertExpression : public Expression {
      public:
        ConvertExpression( AST::Expression* _value );
        ~ConvertExpression();
        virtual void markAsReturnExpression();
        virtual bool isConstant() const;
      protected:
        const AST::Expression* value() const;
      private:
        AST::Expression* m_value;
    };
    class DefaultConvertExpression : public ConvertExpression {
      public:
        DefaultConvertExpression( AST::Expression* _value,  const GTLCore::Type* _dstType );
        virtual ~DefaultConvertExpression();
        virtual const GTLCore::Type* type() const;
        virtual GTLCore::ExpressionResult generateValue( GenerationContext&, llvm::BasicBlock* bb ) const;
      private:
        const GTLCore::Type* m_dstType;
    };
  }
}

#endif
