/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_FUNCTION_CALLER_P_H_
#define _GTLCORE_FUNCTION_CALLER_P_H_

#include <vector>

namespace llvm {
  class Function;
}

namespace GTLCore {
  class Value;
  class Function;
  /**
   * This class is part of the private API of OpenCTL.
   * This is use to provide fast and efficient call to CTL functions,
   * unlike what llvm's JIT provides.
   * @internal
   */
  class FunctionCaller {
    public:
      FunctionCaller(llvm::Function*, const Function* );
      virtual ~FunctionCaller();
      static FunctionCaller* createCaller(llvm::Function*, const Function* );
      virtual GTLCore::Value call(const std::vector<GTLCore::Value>& arguments ) = 0;
    protected:
      llvm::Function* function();
    private:
      struct Private;
      Private* const d;
  };
  
}

#endif
