/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "PixelVisitor_p.h"

// LLVM
#include <llvm/Instructions.h>

#include "GTLCore/ExpressionResult_p.h"
#include "GTLCore/Macros_p.h"
#include "GTLCore/Type.h"

#include "Debug.h"
#include "CodeGenerator_p.h"
#include "wrappers/PixelWrap_p.h"

using namespace OpenShiva;

PixelVisitor* pixelVisitor = 0;

STATIC_INITIALISATION( PixelVisitor )
{
  pixelVisitor = new PixelVisitor;
}


PixelVisitor::PixelVisitor()
{
}

PixelVisitor::~PixelVisitor()
{
}

const GTLCore::Visitor* PixelVisitor::instance()
{
  return pixelVisitor;
}

const GTLCore::Type* PixelVisitor::pointerToIndexType( const GTLCore::Type* _type ) const
{
  return GTLCore::Type::Float;
}

llvm::Value* PixelVisitor::pointerToIndex( GTLCore::GenerationContext& _generationContext, llvm::BasicBlock* _currentBlock, llvm::Value* _pointer, const GTLCore::Type* _type, llvm::Value* _index) const
{
  llvm::Value* ptr = CodeGenerator::accessPixelDataAsF32Ptr( _generationContext, _currentBlock, _pointer );
  return llvm::GetElementPtrInst::Create( ptr, _index, "", _currentBlock);
}

GTLCore::ExpressionResult PixelVisitor::get( GTLCore::GenerationContext& _generationContext, llvm::BasicBlock* _currentBlock, llvm::Value* _pointer, const GTLCore::Type* _pointerType) const
{
#if 0
  SHIVA_DEBUG( *_pointer << " " << *_pointerType );
  llvm::Value* result = new llvm::LoadInst(
      CodeGenerator::accessPixelDataPtr( _generationContext, _currentBlock, _pointer ),
      "",
      _currentBlock );
  SHIVA_DEBUG( *_pointer << " " << *result );
  return GTLCore::ExpressionResult( result, (*_pointerType->structDataMembers())[0].type());
#endif
  return GTLCore::ExpressionResult(_pointer, _pointerType);
}

llvm::BasicBlock* PixelVisitor::set( GTLCore::GenerationContext& _generationContext, llvm::BasicBlock* _currentBlock, llvm::Value* _pointer, const GTLCore::Type* _pointerType, llvm::Value* _value, const GTLCore::Type* _valueType, bool _allocatedInMemory) const
{
  SHIVA_DEBUG( "Pointer Type = " << *_pointerType << " Value Type = " << *_valueType );
  SHIVA_DEBUG( "Pointer = " << *_pointer << " Value = " << *_value );
  if( _valueType->dataType() == GTLCore::Type::STRUCTURE )
  {
    GTL_ASSERT( _valueType == _pointerType );
    _value = new llvm::LoadInst( CodeGenerator::accessPixelDataPtr( _generationContext, _currentBlock, _value ), "", _currentBlock);
  }
  GTL_DEBUG( "Value = " << *_value );
  new llvm::StoreInst( _value,
                       CodeGenerator::accessPixelDataPtr( _generationContext, _currentBlock, _pointer ),
                       "",
                       _currentBlock );
  return _currentBlock;
}

llvm::BasicBlock* PixelVisitor::initialise( GTLCore::GenerationContext& _generationContext, llvm::BasicBlock* _currentBlock, llvm::Value* _pointer, const GTLCore::Type* _pointerType, const std::list< llvm::Value*>& _sizes, bool _allocatedInMemorys) const
{
  // Don't do nothing
  return _currentBlock;
}

llvm::BasicBlock* PixelVisitor::cleanUp( GTLCore::GenerationContext& _generationContext, llvm::BasicBlock* _currentBlock, llvm::Value* _pointer, const GTLCore::Type* _pointerType, llvm::Value* _donttouch, bool _allocatedInMemory ) const
{
  return _currentBlock;
}
