/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "GarbageCollectionStatement.h"

#include <stdlib.h>

#include <llvm/Constant.h>
#include <llvm/Instructions.h>

#include "../Type.h"
#include "../CodeGenerator_p.h"
#include "../VariableNG_p.h"
#include "../Visitor_p.h"

using namespace GTLCore::AST;

PointerGarbageCollectionStatement::PointerGarbageCollectionStatement( llvm::Value* _pointer, const GTLCore::Type* _type ) : m_pointer(_pointer), m_type(_type)
{
}

PointerGarbageCollectionStatement::~PointerGarbageCollectionStatement()
{
}

llvm::BasicBlock* PointerGarbageCollectionStatement::generateStatement( GenerationContext& _generationContext, llvm::BasicBlock* _currentBlock) const
{
  // FIXME: garbage collect if needed
  
  if( m_type->dataType() == Type::STRUCTURE or m_type->dataType() == Type::ARRAY )
  {
    llvm::Value* countValue = CodeGenerator::getCountFieldOf( _currentBlock, m_pointer );
    llvm::Value* test = CodeGenerator::createStrictInferiorExpression( _currentBlock, countValue, Type::Integer32, CodeGenerator::integerToConstant( 1 ), Type::Integer32 );
    llvm::BasicBlock* first = createBlock( _generationContext );
    llvm::BasicBlock* after = createBlock( _generationContext );
    llvm::BasicBlock* last = Visitor::getVisitorFor( m_type )->cleanUp( _generationContext, first, m_pointer, m_type, 0, true, false, true );
    CodeGenerator::createIfStatement( _currentBlock, test, Type::Boolean, first, last, after);
    return after;
  } else {
    return _currentBlock;
  }
}

VariablesGarbageCollectionStatement::VariablesGarbageCollectionStatement( std::list< VariableNG* > _variablesToCollect )
  : m_variablesToCollect(_variablesToCollect)
{
}

VariablesGarbageCollectionStatement::~VariablesGarbageCollectionStatement()
{
}

llvm::BasicBlock* VariablesGarbageCollectionStatement::generateStatement( GenerationContext& _generationContext, llvm::BasicBlock* _currentBlock) const
{
  for( std::list< VariableNG* >::const_iterator it = m_variablesToCollect.begin(); it != m_variablesToCollect.end(); ++it )
  {
    _currentBlock = (*it)->cleanUp( _generationContext, _currentBlock, 0 );
  }
  return _currentBlock;
}
