/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Entry.h"

using namespace GTLCore::Metadata;

struct Entry::Private {
  GTLCore::String name;
};

Entry::Entry( const GTLCore::String& _name ) : d(new Private)
{
  d->name = _name;
}

Entry::~Entry()
{
  delete d;
}

const GTLCore::String& Entry::name() const
{
  return d->name;
}

const Group* Entry::asGroup() const
{
  return 0;
}

const ParameterEntry* Entry::asParameterEntry() const
{
  return 0;
}

const TextEntry* Entry::asTextEntry() const
{
  return 0;
}

const ValueEntry* Entry::asValueEntry() const
{
  return 0;
}
