/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPTIMISER_H_
#define _OPTIMISER_H_

namespace OpenCTL {
  class Compiler;
  class Program;
}

namespace OpenShiva {
  class Compiler;
}

namespace GTLCore {
  /**
   * This class contains information about the current level of optimization.
   * @ingroup GTLCore
   */
  class Optimiser{
    friend class OpenCTL::Compiler;
    friend class OpenCTL::Program;
    friend class OpenShiva::Compiler;
    friend class ModuleData;
    private:
      Optimiser();
      ~Optimiser();
    public:
      static Optimiser* instance();
      /**
       * Set the level of optimisation.
       * @param _level from 0 to 4 (0 means no optimisation, 4 is aggressive optimisation)
       */
      void setLevel(int _level);
      /**
       * @return the maximum level that can be used without knwown problems
       */
      static int maximumRecommendedLevel();
    private:
      class Private;
      Private* const d;
  };
}

#endif
