/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "GTLTest/Test.h"

class TestResult : public GTLTest::Case {
  public:
    TestResult() : GTLTest::Case("TestResult") {}
    virtual void runTest()
    {
      GTLTest::Result r("Test");
      GTLTest::Result r2("Test2", &r);
      GTLTEST_CHECK_EQUAL(r.name(), "Test");
      GTLTEST_CHECK_EQUAL(r.countPassed(), 0);
      GTLTEST_CHECK_EQUAL(r.countFailed(), 0);
      GTLTEST_CHECK_EQUAL(r2.name(), "Test2");
      r.incPassed();
      GTLTEST_CHECK_EQUAL(r.countPassed(), 1);
      GTLTEST_CHECK_EQUAL(r2.countPassed(), 0);
      r2.incPassed();
      GTLTEST_CHECK_EQUAL(r.countPassed(), 2);
      GTLTEST_CHECK_EQUAL(r2.countPassed(), 1);
      GTLTEST_CHECK_EQUAL(r.countFailed(), 0);
      GTLTEST_CHECK_EQUAL(r2.countFailed(), 0);
      r.incFailed();
      GTLTEST_CHECK_EQUAL(r.countFailed(), 1);
      GTLTEST_CHECK_EQUAL(r2.countFailed(), 0);
      r2.incFailed();
      GTLTEST_CHECK_EQUAL(r.countFailed(), 2);
      GTLTEST_CHECK_EQUAL(r2.countFailed(), 1);
      GTLTEST_CHECK_EQUAL(r.countPassed(), 2);
      GTLTEST_CHECK_EQUAL(r2.countPassed(), 1);
    }
};

GTLTEST_MAIN_BEGIN(TestGTLTest)
GTLTEST_MAIN_ADD_CASE(TestResult)
GTLTEST_MAIN_END()
