/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENSHIVA_KERNEL_P_H_
#define _OPENSHIVA_KERNEL_P_H_

#include "Kernel.h"

#include <list>

namespace llvm {
  class Function;
}

namespace GTLCore {
  class Type;
}

namespace OpenShiva {
  class Wrapper;
  class Kernel::Private {
    friend class Kernel;
      Private();
    public:
      const std::list< const GTLCore::Type* >& inputsTypes();
      const GTLCore::Type* outputPixelType();
      const GTLCore::Type* outputImageType();
      GTLCore::ModuleData* moduleData();
    private:
      /**
       * Determines output and input types.
       */
      void determineTypes();
      Kernel* self;
      llvm::Function* evaluatePixelesFunction;
      Wrapper* wrapper;
      std::list< const GTLCore::Type* > m_inputsTypes;
      const GTLCore::Type* m_outputPixelType;
      const GTLCore::Type* m_outputImageType;
  };
}

#endif
