/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

/*
 * Copyright (c) 2004 by BEA Systems, Inc. All Rights Reserved.
 */

package javax.jws.soap;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.annotation.ElementType;

/**
 * Specifies the mapping of the Web Service onto the SOAP message protocol.
 *
 * @author Copyright (c) 2004 by BEA Systems, Inc. All Rights Reserved.
 *
 */
@Retention(value = RetentionPolicy.RUNTIME)
@Target(value = {ElementType.TYPE, ElementType.METHOD})
public @interface SOAPBinding {

    /**
     * The SOAP binding style
     */
    public enum Style {
      DOCUMENT,
      RPC
    };

    /**
     * The SOAP binding use
     */
    public enum Use {
      LITERAL,
      ENCODED
    };

    /**
     * The style of mapping parameters onto SOAP messages
     */
    public enum ParameterStyle {
      BARE,
      WRAPPED
    }

    /**
     * Defines the encoding style for messages send to and from the Web Service.
     */
    Style style() default Style.DOCUMENT;

    /**
     * Defines the formatting style for messages sent to and from the Web Service.
     */
    Use use() default Use.LITERAL;

    /**
     * Determines whether method parameters represent the entire message body, or whether the parameters are elements
     * wrapped inside a top-level element named after the operation
     */
    ParameterStyle parameterStyle() default ParameterStyle.WRAPPED;
}
