/*
 * Copyright 2007 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

/*
 * @test
 * @bug 5004188
 * @summary Tests synchronization
 * @author Sergey Malenkov
 */

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;

public class TestSynchronization {
    private static boolean isCalled;

    public static void main(String[] args) throws PropertyVetoException {
        final VetoableChangeSupport vcs = new VetoableChangeSupport(TestSynchronization.class);
        vcs.addVetoableChangeListener("name", new VetoableChangeListener() {
            public void vetoableChange(PropertyChangeEvent event) {
                isCalled = true;
            }
        });
        vcs.addVetoableChangeListener(new VetoableChangeListener() {
            public void vetoableChange(PropertyChangeEvent event) {
                for (VetoableChangeListener listener : vcs.getVetoableChangeListeners())
                    vcs.removeVetoableChangeListener(listener);
            }
        });
        vcs.fireVetoableChange("name", null, null);
        if (!isCalled)
            throw new Error("test failed");
    }
}
