/* tests/regression/bugzilla/PR125.java

   Copyright (C) 2009
   CACAOVM - Verein zur Foerderung der freien virtuellen Maschine CACAO

   This file is part of CACAO.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
   02110-1301, USA.

*/


import org.junit.Test;
import static org.junit.Assert.*;

import java.lang.reflect.Field;

public class PR125 extends ClassLoader {
    @Test
    public void test() throws NoSuchFieldException, IllegalAccessException {
        Class cls = super.defineClass(null, bytecode, 0, bytecode.length);
        Field fld = cls.getDeclaredField("val");
        assertEquals(42, fld.getInt(null));
    }

    /*
     * The following Bytecode was derived from a class like this:
     *    public class Foo {
     *       public static int val = 42;
     *    }
     *
     * The access_flags of the <clinit> were modified by hand to
     * not contain the ACC_STATIC flag.
     */
    static byte[] bytecode = {
	(byte)0xca, (byte)0xfe, (byte)0xba, (byte)0xbe, (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x31, 
	(byte)0x00, (byte)0x12, (byte)0x0a, (byte)0x00, (byte)0x04, (byte)0x00, (byte)0x0e, (byte)0x09, 
	(byte)0x00, (byte)0x03, (byte)0x00, (byte)0x0f, (byte)0x07, (byte)0x00, (byte)0x10, (byte)0x07, 
	(byte)0x00, (byte)0x11, (byte)0x01, (byte)0x00, (byte)0x03, (byte)0x76, (byte)0x61, (byte)0x6c, 
	(byte)0x01, (byte)0x00, (byte)0x01, (byte)0x49, (byte)0x01, (byte)0x00, (byte)0x06, (byte)0x3c, 
	(byte)0x69, (byte)0x6e, (byte)0x69, (byte)0x74, (byte)0x3e, (byte)0x01, (byte)0x00, (byte)0x03, 
	(byte)0x28, (byte)0x29, (byte)0x56, (byte)0x01, (byte)0x00, (byte)0x04, (byte)0x43, (byte)0x6f, 
	(byte)0x64, (byte)0x65, (byte)0x01, (byte)0x00, (byte)0x0f, (byte)0x4c, (byte)0x69, (byte)0x6e, 
	(byte)0x65, (byte)0x4e, (byte)0x75, (byte)0x6d, (byte)0x62, (byte)0x65, (byte)0x72, (byte)0x54, 
	(byte)0x61, (byte)0x62, (byte)0x6c, (byte)0x65, (byte)0x01, (byte)0x00, (byte)0x08, (byte)0x3c, 
	(byte)0x63, (byte)0x6c, (byte)0x69, (byte)0x6e, (byte)0x69, (byte)0x74, (byte)0x3e, (byte)0x01, 
	(byte)0x00, (byte)0x0a, (byte)0x53, (byte)0x6f, (byte)0x75, (byte)0x72, (byte)0x63, (byte)0x65, 
	(byte)0x46, (byte)0x69, (byte)0x6c, (byte)0x65, (byte)0x01, (byte)0x00, (byte)0x08, (byte)0x46, 
	(byte)0x6f, (byte)0x6f, (byte)0x2e, (byte)0x6a, (byte)0x61, (byte)0x76, (byte)0x61, (byte)0x0c, 
	(byte)0x00, (byte)0x07, (byte)0x00, (byte)0x08, (byte)0x0c, (byte)0x00, (byte)0x05, (byte)0x00, 
	(byte)0x06, (byte)0x01, (byte)0x00, (byte)0x03, (byte)0x46, (byte)0x6f, (byte)0x6f, (byte)0x01, 
	(byte)0x00, (byte)0x10, (byte)0x6a, (byte)0x61, (byte)0x76, (byte)0x61, (byte)0x2f, (byte)0x6c, 
	(byte)0x61, (byte)0x6e, (byte)0x67, (byte)0x2f, (byte)0x4f, (byte)0x62, (byte)0x6a, (byte)0x65, 
	(byte)0x63, (byte)0x74, (byte)0x00, (byte)0x21, (byte)0x00, (byte)0x03, (byte)0x00, (byte)0x04, 
	(byte)0x00, (byte)0x00, (byte)0x00, (byte)0x01, (byte)0x00, (byte)0x09, (byte)0x00, (byte)0x05, 
	(byte)0x00, (byte)0x06, (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x02, (byte)0x00, (byte)0x01, 
	(byte)0x00, (byte)0x07, (byte)0x00, (byte)0x08, (byte)0x00, (byte)0x01, (byte)0x00, (byte)0x09, 
	(byte)0x00, (byte)0x00, (byte)0x00, (byte)0x1d, (byte)0x00, (byte)0x01, (byte)0x00, (byte)0x01, 
	(byte)0x00, (byte)0x00, (byte)0x00, (byte)0x05, (byte)0x2a, (byte)0xb7, (byte)0x00, (byte)0x01, 
	(byte)0xb1, (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x01, (byte)0x00, (byte)0x0a, (byte)0x00, 
	(byte)0x00, (byte)0x00, (byte)0x06, (byte)0x00, (byte)0x01, (byte)0x00, (byte)0x00, (byte)0x00, 
	(byte)0x01, (byte)0x00, (byte)/*0x08*/0x00, (byte)0x00, (byte)0x0b, (byte)0x00, (byte)0x08, (byte)0x00, 
	(byte)0x01, (byte)0x00, (byte)0x09, (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x1e, (byte)0x00, 
	(byte)0x01, (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x06, (byte)0x10, 
	(byte)0x2a, (byte)0xb3, (byte)0x00, (byte)0x02, (byte)0xb1, (byte)0x00, (byte)0x00, (byte)0x00, 
	(byte)0x01, (byte)0x00, (byte)0x0a, (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x06, (byte)0x00, 
	(byte)0x01, (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x02, (byte)0x00, (byte)0x01, (byte)0x00, 
	(byte)0x0c, (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x02, (byte)0x00, (byte)0x0d, 
    };
}

