/*
 * Copyright (c) 2011, 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.sun.javafx.scene.control.infrastructure;

import com.sun.javafx.Utils;
import com.sun.javafx.pgstub.StubToolkit;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.tk.Toolkit;
import javafx.scene.input.KeyCode;

public enum KeyModifier {
    SHIFT,
    CTRL,
    ALT,
    META;
    
    public static KeyModifier getShortcutKey() {
        // The StubToolkit doesn't know what the platform shortcut key is, so 
        // we have to tell it here (and lets not be cute about optimising this
        // code as we need the platform shortcut key to be known elsewhere in the
        // code base for keyboard navigation tests to work accurately).
        if (Toolkit.getToolkit() instanceof StubToolkit) {
            ((StubToolkit)Toolkit.getToolkit()).setPlatformShortcutKey(Utils.isMac() ? KeyCode.META : KeyCode.CONTROL);
        } 
        
        switch (Toolkit.getToolkit().getPlatformShortcutKey()) {
            case SHIFT:
                return SHIFT;

            case CONTROL:
                return CTRL;

            case ALT:
                return ALT;

            case META:
                return META;

            default:
                return null;
        }
    }
}
