/*
 * archive-stream.h --
 *
 *      This file contains the definitions for the C++ archive file objects.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/archive/archive-stream.h,v 1.18 2002/02/03 03:09:26 lim Exp $
 */

#ifndef MASH_ARCHIVE_STREAM_H
#define MASH_ARCHIVE_STREAM_H


#include <tclcl.h>
#include "archive/archive-file.h"
#include "archive/lts.h"

class RecorderStream;
class PlaybackStream;


class ArchiveStream : public TclObject {
public:
	ArchiveStream() : TclObject(), is_first_(0), dataFile_(NULL),
		indexFile_(NULL)
#ifdef MTRACE
	  , myNum_(0) {
	  myNum_ = ++count_;
	}
#else
	{
	}
#endif
	virtual ~ArchiveStream() { }

	int datafile (int argc, const char * const *argv);
	int indexfile(int argc, const char * const *argv);

protected:
	DataFile  *DataFile_ () { return dataFile_; }
	IndexFile *IndexFile_() { return indexFile_;}

	void DataFile_ (DataFile  *file) { dataFile_ = file; }
	void IndexFile_(IndexFile *file) { indexFile_= file; }
	int is_first_;
private:
	DataFile  *dataFile_;
	IndexFile *indexFile_;

#ifdef MTRACE
public:
	int myNum_;
	static int count_;
private:
#endif
};


#ifdef MTRACE
#define MYNUM(x) ((x)->myNum_)
#else
#define MYNUM(x) 0
#endif



/*
 * The stream object for interfacing the playback tool to the file system
 */
class PlaybackStream : public LTSTimer,
		       public LTSTrigger,
		       public ArchiveStream {
public:
	PlaybackStream()
		: LTSTimer(),
		  LTSTrigger(LTS_SPEED|LTS_REFERENCE),
		  ArchiveStream(), lts_(NULL) { }
	virtual ~PlaybackStream() {
		if (lts_!=NULL) {
			// remove myself from the trigger list of the lts
			lts_->UnsetTrigger(this);
		}
	}
	virtual void LTS_Speed() { LTS_Changed(); }
	virtual void LTS_Reference() { LTS_Changed(); }

	virtual void Clip(timeval start, timeval end)=0;
	// obtain the timeout value for the next event
	// returns: TCL_OK/TCL_ERROR; logical=0.0 if I'm done!
	virtual int  NextEvent(timeval &logical)=0;
	virtual void DoEvent()=0; // do the next event

	int lts (int argc, const char * const *argv);
	int clip(int argc, const char * const *argv);
	inline LTS* LTS_() { return lts_; }
	inline void LTS_(LTS *lts) {
		if (lts_ != NULL) {
			// if there already is an LTS, remove myself from its
			// trigger list
			lts_->UnsetTrigger(this);
		}

		lts_ = lts;
		LTSTimer::LTS_(lts);
		LTSTrigger::LTS_(lts);

		// add myself to the trigger list of the lts
		lts->SetTrigger(this);
	}

protected:
	void callback(u_int32_t triggerType) {
		if (triggerType & LTS_SPEED) LTS_Speed();
		if (triggerType & LTS_REFERENCE) LTS_Reference();
	}
	void timeout();

private:
	void LTS_Changed();
	LTS       *lts_;
};


/*
 * The stream object for interfacing the recorder to the file system
 */
class RecordStream : public ArchiveStream {
public:
	RecordStream() { }
	virtual ~RecordStream() { }
};


#endif /* MASH_ARCHIVE_STREAM_H */
