/*
 * transform.h --
 *
 *      FIXME: This file needs a description here.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/misc/transform.h,v 1.6 2001/04/05 17:17:14 lim Exp $
 *
 * This code derived from InterViews library which is covered
 * by the copyright below.
 */

/*
 * Copyright (c) 1987, 1988, 1989, 1990, 1991 Stanford University
 * Copyright (c) 1991 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Stanford and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Stanford and Silicon Graphics.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL STANFORD OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */

#ifndef mash_transform_h
#define mash_transform_h

class Transform {
public:
	Transform();	/* identity */
	Transform(const Transform&);
	Transform(const Transform*);
	Transform(float a00, float a01, float a10,
		  float a11, float a20, float a21);
	void clear();

	int identity() const;
	int invertible() const;

	int operator ==(const Transform&) const;
	int operator !=(const Transform&) const;
	Transform& operator =(const Transform&);

	void premultiply(const Transform&);
	void postmultiply(const Transform&);
	void invert();

	void translate(float dx, float dy);
	void translate(double dx, double dy) {
		translate((float)dx, (float)dy);
	}
	void scale(float sx, float sy);
	void scale(double sx, double sy) { scale((float)sx, (float)sy); }
	void rotate(float angle);
	void skew(float sx, float sy);

	void map(float& x, float& y) const;
        void map(double& x, double& y) const;
	void map(float x, float y, float& tx, float& ty) const;
	void map(double x, double y, double& tx, double& ty) const;
	inline void map(float x, float y, int& tx, int& ty) const {
		float fx, fy;
		map(x, y, fx, fy);
		tx = int(fx);
		ty = int(fy);
	}
	inline void map(double x, double y, int& tx, int& ty) const {
		double dx, dy;
		map(x, y, dx, dy);
		tx = int(dx);
		ty = int(dy);
	}
	void imap(float& tx, float& ty) const;
	void imap(double& tx, double& ty) const;
	void imap(float tx, float ty, float& x, float& y) const;
	void imap(double tx, double ty, double& x, double& y) const;
	float det() const;
private:
	int identity_;
	float mat00, mat01, mat10, mat11, mat20, mat21;
	void update();
};

inline float Transform::det() const { return mat00*mat11 - mat01*mat10; }
inline int Transform::identity() const { return identity_; }
inline int Transform::invertible() const { return det() != 0; }

#endif // mash_transform_h
