/*
 * reflector.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint
static const char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/net/reflector.cc,v 1.7 2002/02/03 04:13:45 lim Exp $ (UCB)";
#endif

#include "tclcl.h"
#include "tk.h"

#ifndef WIN32
#include "sys/time.h"
#endif
#include "inet.h"
#include "net.h"

class Reflector : public TclObject, public SessionHandler {
public:
	Reflector(int mtu);
	~Reflector();
	virtual int command(int argc, const char*const* argv);
	virtual void recv(DataHandler*);
protected:
	int mtu_;
	DataHandler* alldh_;
	u_char* pktbuf_;

	/* FIXME */
	virtual void recv(CtrlHandler*) {}
	virtual void announce(CtrlHandler*) {}
};

static class ReflectorClass : public TclClass {
    public:
	ReflectorClass() : TclClass("Reflector") {}
	TclObject* create(int, const char*const* argv) {
		return (new Reflector(atoi(argv[4])));
	}
} reflector_class;

Reflector::Reflector(int mtu)
	:mtu_(mtu), alldh_(0)
{
	pktbuf_ = new u_char[2 * mtu];
}

Reflector::~Reflector()
{
	DataHandler* p = alldh_;
	while(p != 0) {
		DataHandler* t = p->next;
		delete p;
		p = t;
	}

	delete pktbuf_;
}

int Reflector::command(int argc, const char*const* argv)
{
	if (argc == 3) {
		if (strcmp(argv[1], "add-network") == 0) {
			Network* n = (Network*)TclObject::lookup(argv[2]);
			DataHandler* dh = new DataHandler;
			dh->manager(this);
			dh->net(n);
			dh->next = alldh_;
			alldh_ = dh;

			return (TCL_OK);
		}
		if (strcmp(argv[1], "remove-network") == 0) {
			Network* n = (Network*)TclObject::lookup(argv[2]);
			DataHandler** p;
			for (p = &alldh_; *p != 0; p = &(*p)->next) {
				if ((*p)->net() == n) {
					DataHandler* tmp = *p;
					*p = (*p)->next;
					delete tmp;
					/* network deleted in tcl. */
					return (TCL_OK);
				}
			}
			return (TCL_OK);
		}
	}

	return (TclObject::command(argc, argv));
}

void Reflector::recv(DataHandler* dh)
{
	u_int32_t addr;
	int port;
	int cc = dh->recv(pktbuf_, 2 * mtu_, addr, port);
	if (cc <= 0)
		return;

	DataHandler* p;
	for (p = alldh_; p != 0; p = p->next) {
		if (p == dh)
			continue;
		p->send(pktbuf_, cc);
	}
}
