/*
 * tcpchan.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef mash_tcpchan_h
#define mash_tcpchan_h

#include "config.h"
#include "tclcl.h"
#include "iohandler.h"
#include "tk.h"

class TCPServerHandler;
class TCPClientHandler;

class TCPServerChannel : public TclObject {
public:
	TCPServerChannel();
	~TCPServerChannel();
	int recv(u_char* buf, int len, u_int32_t&, u_int16_t&);
	void send(const u_char* buf, int len);
	void reset(void);
	inline int sock() { return sock_; }
	virtual int command(int argc, const char*const*argv);
	inline void handler(TCPServerHandler* h) { handler_ = h; }
private:
	int opensock(u_int16_t port) const;
	int connsock_;
	int sock_;
	u_int32_t fromaddr_;
	u_int16_t fromport_;
	int concurrent_;
	int parent_;
	TCPServerHandler* handler_;
};

class TCPClientChannel : public TclObject {
public:
	TCPClientChannel();
	~TCPClientChannel();
	int recv(u_char* buf, int len);
	void send(const u_char* buf, int len);
	inline int sock() { return sock_; }
	virtual int command(int argc, const char*const*argv);
	inline void handler(TCPClientHandler* h) { handler_ = h; }
	void closesock();

private:
	int opensock(u_int32_t addr, u_int16_t port) const;
	int sock_;
	TCPClientHandler* handler_;
};

class TCPClientHandler;
class TCPServerHandler;

class TCPClientManager {
public:
	virtual void recv(TCPClientHandler*) = 0;
};

class TCPServerManager {
public:
	virtual void recv(TCPServerHandler*) = 0;
};

class TCPClientHandler : public IOHandler, public TclObject {
public:
	inline TCPClientHandler() : manager_(0), chan_(0) {}
	virtual void dispatch(int) {
		manager_->recv(this);
	}
	inline TCPClientChannel* chan() const { return (chan_); }
	void reset(void) {
		chan(0);
	}
	virtual void chan(TCPClientChannel *c) {
		unlink();
		chan_ = c;
		if (c != 0) {
			c->handler(this);
			link(c->sock(), TCL_READABLE);
		}
	}
	inline int recv(u_char* bp, int len) {
		return (chan_->recv(bp, len));
	}
	inline void send(u_char* bp, int len) {
		chan_->send(bp, len);
	}
	inline void manager(TCPClientManager* sm) { manager_ = sm; }
	virtual int command(int argc, const char*const* argv);
protected:
	TCPClientManager* manager_;
	TCPClientChannel* chan_;
};

class TCPServerHandler : public IOHandler, public TclObject {
public:
	inline TCPServerHandler() : manager_(0), chan_(0) {}
	virtual void dispatch(int) {
		manager_->recv(this);
	}
	inline TCPServerChannel* chan() const { return (chan_); }
	void reset(void) {
		unlink();
		chan_->reset();
		link(chan_->sock(), TCL_READABLE);
	}
	virtual void chan(TCPServerChannel *c) {
		unlink();
		chan_ = c;
		if (c != 0) {
			c->handler(this);
			link(c->sock(), TCL_READABLE);
		}
	}
	inline int recv(u_char* bp, int len, u_int32_t& addr,
			u_int16_t& port) {
		return(chan_->recv(bp, len, addr, port));
	}
	inline void send(u_char* bp, int len) {
		chan_->send(bp, len);
	}
	inline void manager(TCPServerManager* sm) { manager_ = sm; }
	virtual int command(int argc, const char*const* argv);
protected:
	TCPServerManager* manager_;
	TCPServerChannel* chan_;
};

#endif /* mash_tcpchan_h */
