/*
 * module-temp_select.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "inet.h"
#include "rtp.h"
#include "tclcl.h"
#include "pktbuf.h"
#include "codec/module.h"

class TemporalSelectTargetState {
public:

  TemporalSelectTargetState() : target_(0), id_(0), next_(0) {};
  TemporalSelectTargetState(u_int32_t id, Module *target) : target_(target),
    id_(id), next_(0) {};
  Module *target_;
  u_int32_t id_;
  TemporalSelectTargetState *next_;
};

class TemporalSelectModule : public PacketModule {
public:
  TemporalSelectModule() : PacketModule(), target_list_(0),
    num_targets_(0), callback_(0)  {};

  virtual void recv(pktbuf *pb) = 0;
  virtual void update_target(u_int32_t target_id,
			     TemporalSelectTargetState *state) = 0;
  virtual TemporalSelectTargetState *register_target(u_int32_t id,
						     Module *target) = 0;
  virtual void unregister_target(u_int32_t id,
				 TemporalSelectTargetState *state) = 0;

  void execute_callback(u_int32_t ts);
  int command(int argc, const char*const* argv);

protected:
  void add_state(TemporalSelectTargetState *state);
  void del_state(TemporalSelectTargetState *state);
  TemporalSelectTargetState *get_state_by_id(u_int32_t id);

  TemporalSelectTargetState *target_list_;
  int num_targets_;
  char *callback_;
};
