/*
 * rep-encoder-semicompressed2jpeg.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>

#include <errno.h>
#include "inet.h"
#include "net.h"
#include "rtp.h"
#include "codec/dct.h"
#include "bsd-endian.h"
#include "Tcl.h"
#include "pktbuf-rtp.h"
#include "codec/module.h"
#include "vidreps.h"

#define HDRSIZE (sizeof(rtphdr) + 8)

#ifdef INT_64
#define NBIT 64
#define BB_INT INT_64
#else
#define NBIT 32
#define BB_INT u_int
#endif

#if BYTE_ORDER == LITTLE_ENDIAN
#if NBIT == 64
#define STORE_BITS(bb, bc)						\
{									\
    u_char t = bb>>56;							\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb>>48;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb>>40;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb>>32;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb>>24;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb>>16;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb>>8;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
}

#else

#define STORE_BITS(bb, bc)						\
{									\
    u_char t = bb>>24;							\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb>>16;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb>>8;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
}

#endif
#else

#if NBIT == 64
#define STORE_BITS(bb, bc)						\
{									\
    u_char t = bb;							\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb>>8;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb>>16;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb>>24;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb>>32;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb>>40;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb>>48;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb>>56;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
}
#else
#define OLD_STORE_BITS(bb, bc)						\
{									\
    u_char t = bb;							\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb>>8;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb>>16;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb>>24;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
}
#define STORE_BITS(bb, bc)						\
{									\
    u_char t = bb>>24;							\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb>>16;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb>>8;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
    t = bb;								\
    *bc++ = t;								\
    if (t == 0xff) *bc++ = 0;						\
}

#endif
#endif

#define PUT_BITS(bits, n, nbb, bb, bc)					\
{									\
    nbb += (n);								\
    if (nbb > NBIT)  {							\
	u_int extra = (nbb) - NBIT;					\
	bb |= (BB_INT)(bits) >> extra;					\
	STORE_BITS(bb, bc)						\
	bb = (BB_INT)(bits) << NBIT - extra;				\
	nbb = extra;							\
    } else								\
	bb |= (BB_INT)(bits) << NBIT - (nbb);				\
}

class SemicompressedToJpegEncoder : public EncoderModule {
public:
  SemicompressedToJpegEncoder();
  void setq(int q);
  void size(int w, int h);
  void recv(Buffer*);
  void recv(Semicompressed* semicomp_input);

protected:
  struct huffentry {
    u_short val;
    u_short nb;
  };

  int command(int argc, const char*const* argv);

  int flush(pktbuf* pb, int nbit, pktbuf* npb);
  int encode(const Semicompressed* fb);

//   void encode_blk(const short* blk, short* dcpred,
// 		  struct SemicompressedToJpegEncoder::huffentry* dcht,
// 		  struct SemicompressedToJpegEncoder::huffentry* acht);

  void encode_blk(short dc, short *dcpred,
		  const char *ac_indices,
		  const short *ac_values, int num_ac,
		  struct SemicompressedToJpegEncoder::huffentry* dcht,
		  struct SemicompressedToJpegEncoder::huffentry* acht,
		  int *qt);

  void encode_mcu(u_int mcu, const ScBlock *lum_blks, const ScBlock *cr_blks,
		  const ScBlock *cb_blks);

  /* bit buffer */
  BB_INT bb_;
  u_int nbb_;

  u_char* bs_;
  u_char* bc_;
  u_int offset_;

  u_char quant_;
  int lqt_[64];
  int cqt_[64];

  short lpred_;	// dc predictors
  short crpred_;
  short cbpred_;

  u_int nmcu_;
  u_char w_;			/* divided by 8 */
  u_char h_;
};

static class SemicompressedToJpegEncoderClass : public TclClass {
public:
  SemicompressedToJpegEncoderClass() : TclClass("Module/VideoEncoder/SemicompressedToJPEG") {}
  TclObject* create(int, const char*const*) {
    return (new SemicompressedToJpegEncoder);
  }
} semicompressed_to_jpeg_encoder_class_;

static const int ROWCOL_TO_ZAG[] = {
   0,  1,  5,  6, 14, 15, 27, 28,
   2,  4,  7, 13, 16, 26, 29, 42,
   3,  8, 12, 17, 25, 30, 41, 43,
   9, 11, 18, 24, 31, 40, 44, 53,
  10, 19, 23, 32, 39, 45, 52, 54,
  20, 22, 33, 38, 46, 51, 55, 60,
  21, 34, 37, 47, 50, 56, 59, 61,
  35, 36, 48, 49, 57, 58, 62, 63 };

static const int stdlqt[] = {
  16, 11, 10, 16, 24, 40, 51, 61,
  12, 12, 14, 19, 26, 58, 60, 55,
  14, 13, 16, 24, 40, 57, 69, 56,
  14, 17, 22, 29, 51, 87, 80, 62,
  18, 22, 37, 56, 68, 109, 103, 77,
  24, 35, 55, 64, 81, 104, 113, 92,
  49, 64, 78, 87, 103, 121, 120, 101,
  72, 92, 95, 98, 112, 100, 103, 99 };

static const int stdcqt[] = {
  17, 18, 24, 47, 99, 99, 99, 99,
  18, 21, 26, 66, 99, 99, 99, 99,
  24, 26, 56, 99, 99, 99, 99, 99,
  47, 66, 99, 99, 99, 99, 99, 99,
  99, 99, 99, 99, 99, 99, 99, 99,
  99, 99, 99, 99, 99, 99, 99, 99,
  99, 99, 99, 99, 99, 99, 99, 99,
  99, 99, 99, 99, 99, 99, 99, 99 };

static struct SemicompressedToJpegEncoder::huffentry ldht[] = {
  {0x0, 2}, {0x2, 3}, {0x3, 3}, {0x4, 3}, {0x5, 3}, {0x6, 3},
  {0xe, 4}, {0x1e, 5}, {0x3e, 6}, {0x7e, 7}, {0xfe, 8}, {0x1fe, 9}};

static struct SemicompressedToJpegEncoder::huffentry cdht[] = {
  {0x0, 2}, {0x1, 2}, {0x2, 2}, {0x6, 3}, {0xe, 4}, {0x1e, 5}, {0x3e, 6},
  {0x7e, 7}, {0xfe, 8}, {0x1fe, 9}, {0x3fe, 10}, {0x7fe, 11}};

static struct SemicompressedToJpegEncoder::huffentry laht[] = {
  {0x0a, 4}, {0x00, 2}, {0x01, 2}, {0x04, 3},
  {0x0b, 4}, {0x1a, 5}, {0x78, 7}, {0xf8, 8},
  {0x3f6, 10}, {0xff82, 16}, {0xff83, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x0c, 4}, {0x1b, 5}, {0x79, 7},
  {0x1f6, 9}, {0x7f6, 11}, {0xff84, 16}, {0xff85, 16},
  {0xff86, 16}, {0xff87, 16}, {0xff88, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x1c, 5}, {0xf9, 8}, {0x3f7, 10},
  {0xff4, 12}, {0xff89, 16}, {0xff8a, 16}, {0xff8b, 16},
  {0xff8c, 16}, {0xff8d, 16}, {0xff8e, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x3a, 6}, {0x1f7, 9}, {0xff5, 12},
  {0xff8f, 16}, {0xff90, 16}, {0xff91, 16}, {0xff92, 16},
  {0xff93, 16}, {0xff94, 16}, {0xff95, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x3b, 6}, {0x3f8, 10}, {0xff96, 16},
  {0xff97, 16}, {0xff98, 16}, {0xff99, 16}, {0xff9a, 16},
  {0xff9b, 16}, {0xff9c, 16}, {0xff9d, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x7a, 7}, {0x7f7, 11}, {0xff9e, 16},
  {0xff9f, 16}, {0xffa0, 16}, {0xffa1, 16}, {0xffa2, 16},
  {0xffa3, 16}, {0xffa4, 16}, {0xffa5, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x7b, 7}, {0xff6, 12}, {0xffa6, 16},
  {0xffa7, 16}, {0xffa8, 16}, {0xffa9, 16}, {0xffaa, 16},
  {0xffab, 16}, {0xffac, 16}, {0xffad, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0xfa, 8}, {0xff7, 12}, {0xffae, 16},
  {0xffaf, 16}, {0xffb0, 16}, {0xffb1, 16}, {0xffb2, 16},
  {0xffb3, 16}, {0xffb4, 16}, {0xffb5, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x1f8, 9}, {0x7fc0, 15}, {0xffb6, 16},
  {0xffb7, 16}, {0xffb8, 16}, {0xffb9, 16}, {0xffba, 16},
  {0xffbb, 16}, {0xffbc, 16}, {0xffbd, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x1f9, 9}, {0xffbe, 16}, {0xffbf, 16},
  {0xffc0, 16}, {0xffc1, 16}, {0xffc2, 16}, {0xffc3, 16},
  {0xffc4, 16}, {0xffc5, 16}, {0xffc6, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x1fa, 9}, {0xffc7, 16}, {0xffc8, 16},
  {0xffc9, 16}, {0xffca, 16}, {0xffcb, 16}, {0xffcc, 16},
  {0xffcd, 16}, {0xffce, 16}, {0xffcf, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x3f9, 10}, {0xffd0, 16}, {0xffd1, 16},
  {0xffd2, 16}, {0xffd3, 16}, {0xffd4, 16}, {0xffd5, 16},
  {0xffd6, 16}, {0xffd7, 16}, {0xffd8, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x3fa, 10}, {0xffd9, 16}, {0xffda, 16},
  {0xffdb, 16}, {0xffdc, 16}, {0xffdd, 16}, {0xffde, 16},
  {0xffdf, 16}, {0xffe0, 16}, {0xffe1, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x7f8, 11}, {0xffe2, 16}, {0xffe3, 16},
  {0xffe4, 16}, {0xffe5, 16}, {0xffe6, 16}, {0xffe7, 16},
  {0xffe8, 16}, {0xffe9, 16}, {0xffea, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0xffeb, 16}, {0xffec, 16}, {0xffed, 16},
  {0xffee, 16}, {0xffef, 16}, {0xfff0, 16}, {0xfff1, 16},
  {0xfff2, 16}, {0xfff3, 16}, {0xfff4, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x7f9, 11}, {0xfff5, 16}, {0xfff6, 16}, {0xfff7, 16},
  {0xfff8, 16}, {0xfff9, 16}, {0xfffa, 16}, {0xfffb, 16},
  {0xfffc, 16}, {0xfffd, 16}, {0xfffe, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0} };

static struct SemicompressedToJpegEncoder::huffentry caht[] = {
  {0x00, 2}, {0x01, 2}, {0x04, 3}, {0x0a, 4},
  {0x18, 5}, {0x19, 5}, {0x38, 6}, {0x78, 7},
  {0x1f4, 9}, {0x3f6, 10}, {0xff4, 12}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x0b, 4}, {0x39, 6}, {0xf6, 8},
  {0x1f5, 9}, {0x7f6, 11}, {0xff5, 12}, {0xff88, 16},
  {0xff89, 16}, {0xff8a, 16}, {0xff8b, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x1a, 5}, {0xf7, 8}, {0x3f7, 10},
  {0xff6, 12}, {0x7fc2, 15}, {0xff8c, 16}, {0xff8d, 16},
  {0xff8e, 16}, {0xff8f, 16}, {0xff90, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x1b, 5}, {0xf8, 8}, {0x3f8, 10},
  {0xff7, 12}, {0xff91, 16}, {0xff92, 16}, {0xff93, 16},
  {0xff94, 16}, {0xff95, 16}, {0xff96, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x3a, 6}, {0x1f6, 9}, {0xff97, 16},
  {0xff98, 16}, {0xff99, 16}, {0xff9a, 16}, {0xff9b, 16},
  {0xff9c, 16}, {0xff9d, 16}, {0xff9e, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x3b, 6}, {0x3f9, 10}, {0xff9f, 16},
  {0xffa0, 16}, {0xffa1, 16}, {0xffa2, 16}, {0xffa3, 16},
  {0xffa4, 16}, {0xffa5, 16}, {0xffa6, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x79, 7}, {0x7f7, 11}, {0xffa7, 16},
  {0xffa8, 16}, {0xffa9, 16}, {0xffaa, 16}, {0xffab, 16},
  {0xffac, 16}, {0xffad, 16}, {0xffae, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x7a, 7}, {0x7f8, 11}, {0xffaf, 16},
  {0xffb0, 16}, {0xffb1, 16}, {0xffb2, 16}, {0xffb3, 16},
  {0xffb4, 16}, {0xffb5, 16}, {0xffb6, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0xf9, 8}, {0xffb7, 16}, {0xffb8, 16},
  {0xffb9, 16}, {0xffba, 16}, {0xffbb, 16}, {0xffbc, 16},
  {0xffbd, 16}, {0xffbe, 16}, {0xffbf, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x1f7, 9}, {0xffc0, 16}, {0xffc1, 16},
  {0xffc2, 16}, {0xffc3, 16}, {0xffc4, 16}, {0xffc5, 16},
  {0xffc6, 16}, {0xffc7, 16}, {0xffc8, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x1f8, 9}, {0xffc9, 16}, {0xffca, 16},
  {0xffcb, 16}, {0xffcc, 16}, {0xffcd, 16}, {0xffce, 16},
  {0xffcf, 16}, {0xffd0, 16}, {0xffd1, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x1f9, 9}, {0xffd2, 16}, {0xffd3, 16},
  {0xffd4, 16}, {0xffd5, 16}, {0xffd6, 16}, {0xffd7, 16},
  {0xffd8, 16}, {0xffd9, 16}, {0xffda, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x1fa, 9}, {0xffdb, 16}, {0xffdc, 16},
  {0xffdd, 16}, {0xffde, 16}, {0xffdf, 16}, {0xffe0, 16},
  {0xffe1, 16}, {0xffe2, 16}, {0xffe3, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x7f9, 11}, {0xffe4, 16}, {0xffe5, 16},
  {0xffe6, 16}, {0xffe7, 16}, {0xffe8, 16}, {0xffe9, 16},
  {0xffea, 16}, {0xffeb, 16}, {0xffec, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x00, 0}, {0x3fe0, 14}, {0xffed, 16}, {0xffee, 16},
  {0xffef, 16}, {0xfff0, 16}, {0xfff1, 16}, {0xfff2, 16},
  {0xfff3, 16}, {0xfff4, 16}, {0xfff5, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0},
  {0x3fa, 10}, {0x7fc3, 15}, {0xfff6, 16}, {0xfff7, 16},
  {0xfff8, 16}, {0xfff9, 16}, {0xfffa, 16}, {0xfffb, 16},
  {0xfffc, 16}, {0xfffd, 16}, {0xfffe, 16}, {0x00, 0},
  {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0} };

static const char ss[] = {
  0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8 };

SemicompressedToJpegEncoder::SemicompressedToJpegEncoder() : EncoderModule(),
    bb_(0), nbb_(0), bs_(0), bc_(0), offset_(0), quant_(0),
    lpred_(0), crpred_(0), cbpred_(0), nmcu_(0), w_(0), h_(0)
{
    setq(30);
}

void
SemicompressedToJpegEncoder::setq(int q)
{
    quant_ = q;

    int s = (q>50) ? 200-q*2 : 5000/q;
    for (int i=0; i<64; i++) {
	int v = (stdlqt[i] * s + 50)/ 100;
	if (v<1)
	    lqt_[i] = 1;
	else if (v>255)
	    lqt_[i] = 255;
	else
	    lqt_[i] = v;

	v = (stdcqt[i] * s + 50)/ 100;
	if (v<1)
	    cqt_[i] = 1;
	else if (v>255)
	    cqt_[i] = 255;
	else
	    cqt_[i] = v;
    }
}

void
SemicompressedToJpegEncoder::size(int w, int h)
{
    FrameModule::size(w, h);
    if (w&0xf || h&0xf) {
	fprintf(stderr, "SemicompressedToJpegEncoder: bad geometry: %dx%d\n", w, h);
	exit(1);
    }
    w_ = w>>3;
    h_ = h>>3;
    nmcu_ = (w_>>1) * h_;
}

int
SemicompressedToJpegEncoder::command(int argc, const char*const* argv)
{
    // is this the proper place for this?
    if (argc == 2 && strcmp(argv[1], "frame-format") == 0) {
	Tcl& tcl = Tcl::instance();
	tcl.result("422");
	return (TCL_OK);
    }
    if (argc == 3 && strcmp(argv[1], "q") == 0) {
	setq(atoi(argv[2]));
	return (TCL_OK);
    }
    if (argc == 3 && strcmp(argv[1], "recv") == 0) {
      Semicompressed *input = (Semicompressed *) TclObject::lookup(argv[2]);
      if (input != 0) {
	recv(input);
      }
      return (TCL_OK);
    }
    return (EncoderModule::command(argc, argv));
}

void
SemicompressedToJpegEncoder::recv(Semicompressed* semi_input)
{
  if (!(semi_input->w_ == width_ &&
	semi_input->h_ == height_)) {
    size(semi_input->w_, semi_input->h_);
  }
  encode(semi_input);
}

void
SemicompressedToJpegEncoder::recv(Buffer* bp)
{
  recv((Semicompressed *) bp);
  return;
}

int
SemicompressedToJpegEncoder::flush(pktbuf* pb, int nbit, pktbuf* npb)
{
    u_char* obc = bc_;

    /* flush bit buffer */
    STORE_BITS(bb_, bc_);

    int cc = (nbit + 7) >> 3;

    /*FIXME*/
    if (cc == 0 && npb != 0)
	abort();

    pb->len = cc + HDRSIZE;
    rtphdr* rh = (rtphdr*)pb->data;
    if (npb == 0)
	rh->rh_flags |= htons(RTP_M);

    if (npb != 0) {
	u_char* nbs = &npb->data[HDRSIZE];
	int extra = obc - (bs_ + (nbit >> 3));
	if (extra > 0)
	    memcpy(nbs, bs_ + (nbit >> 3), extra);
	bs_ = nbs;
	bc_ = nbs + extra;
    }
    /* DEBUG */
#ifdef bogus
    {
      static int frame_num = 0;
      static int packet_num = 0;
      FILE *fp;
      char fname[200];

      sprintf(fname, "tmp/f%d_p%d", frame_num, packet_num);
      fp = fopen(fname, "w");

      printf("Writing %d bytes\n", pb->len);
      fwrite(pb->data, 1, pb->len, fp);
      fclose(fp);
      packet_num++;
      if (rh->rh_flags & htons(RTP_M)) {
	frame_num++;
	packet_num = 0;
      }
    }
#endif

    target_->recv(pb);

    return (cc + HDRSIZE);
}

#define SSSS(n) (((n)&~0xff) ? (8+ss[(n)>>8]) : ss[n])

void
SemicompressedToJpegEncoder::encode_blk(short dc, short *dcpred,
					const char *ac_indices,
					const short *ac_values, int num_ac,
					struct huffentry* dcht,
					struct huffentry* acht,
					int *qt)
{
  int i;
  BB_INT bb = bb_;
  u_int nbb = nbb_;
  u_char* bc = bc_;
  int prev_pos = 0;

  /* code dc (already quantized) */
  short diff = dc - *dcpred;
  *dcpred = dc;

  u_char len;

  if (diff < 0){
    len = SSSS(-diff);
    huffentry e = dcht[len];
    PUT_BITS(e.val, e.nb, nbb, bb, bc);
    PUT_BITS((diff-1)&(~(-1<<len)), len, nbb, bb, bc);
  } else {
    len = SSSS(diff);
    huffentry e = dcht[len];
    PUT_BITS(e.val, e.nb, nbb, bb, bc);
    PUT_BITS(diff, len, nbb, bb, bc);
  }


  if (num_ac > 0) {
    int num_nonzero_ac = 0;
    u_int32_t sort_space[63];

    for (i=0; i<num_ac; i++) {
      int qval = qt[ac_indices[i]];
      short level = (ac_values[i] + (qval/2)) / qval;

      if (level != 0) {
	sort_space[num_nonzero_ac] = (ROWCOL_TO_ZAG[ac_indices[i]] << 16) |
	  ((u_int32_t) ((unsigned short) level));
	num_nonzero_ac++;
      }
    }

    num_ac = num_nonzero_ac;

    for (i=0; i<num_ac; i++) {
      for (int j=i+1; j<num_ac; j++) {
	if (sort_space[i] > sort_space[j]) {
	  u_int32_t tmp;
	  tmp = sort_space[i];
	  sort_space[i] = sort_space[j];
	  sort_space[j] = tmp;
	}
      }
    }

    for (i=0; i<num_ac; i++) {
      int zpos = (sort_space[i] >> 16);
      short level = (sort_space[i] & 0xffff);
      int run = zpos - prev_pos - 1;
      prev_pos = zpos;

      if (level < 0) {
	len = SSSS(-level);
	while (run & ~0xf) {
	  huffentry e = acht[0xf0];
	  PUT_BITS(e.val, e.nb, nbb, bb, bc);
	  run -= 16;
	}
	huffentry e = acht[(run<<4) | len];
	PUT_BITS(e.val, e.nb, nbb, bb, bc);
	PUT_BITS((level-1)&(~(-1<<len)), len, nbb, bb, bc);
      } else {
	len = SSSS(level);
	while (run & ~0xf) {
	  huffentry e = acht[0xf0];
	  PUT_BITS(e.val, e.nb, nbb, bb, bc);
	  run -= 16;
	}
	huffentry e = acht[(run<<4) | len];
	PUT_BITS(e.val, e.nb, nbb, bb, bc);
	PUT_BITS(level, len, nbb, bb, bc);
      }
    }
  }

  if (prev_pos != 63) {
    huffentry e = acht[0];
    PUT_BITS(e.val, e.nb, nbb, bb, bc);
  }

  bb_ = bb;
  nbb_ = nbb;
  bc_ = bc;
}

void
SemicompressedToJpegEncoder::encode_mcu(u_int mcu,
					const ScBlock *lum_blks,
					const ScBlock *cr_blks,
					const ScBlock *cb_blks)
{
  const ScBlock *scb;

  int bidx = mcu * 2;

  scb = &(lum_blks[bidx]);
  encode_blk(((((scb->dc - 128) * 8) + (lqt_[0]/2)) / lqt_[0]),
	     &lpred_,
	     scb->index, scb->value, scb->numOfAC,
	     ldht, laht, lqt_);

  scb = &(lum_blks[bidx+1]);
  encode_blk(((((scb->dc - 128) * 8) + (lqt_[0]/2)) / lqt_[0]),
	     &lpred_,
	     scb->index, scb->value, scb->numOfAC,
	     ldht, laht, lqt_);


  scb = &(cr_blks[mcu]);
  encode_blk((((scb->dc * 8) + (cqt_[0] / 2)) / cqt_[0]),
	     &crpred_,
	     scb->index, scb->value, scb->numOfAC,
	     cdht, caht, cqt_);

  scb = &(cb_blks[mcu]);
  encode_blk((((scb->dc * 8) + (cqt_[0] / 2)) / cqt_[0]),
	     &cbpred_,
	     scb->index, scb->value, scb->numOfAC,
	     cdht, caht, cqt_);
}


#ifdef KPATEL_BOGUS
void
SemicompressedToJpegEncoder::encode_blk(const short* blk, short* dcpred,
					struct huffentry* dcht,
					struct huffentry* acht)
{
  BB_INT bb = bb_;
  u_int nbb = nbb_;
  u_char* bc = bc_;

  /* code dc */
  short diff = blk[0] - *dcpred;
  *dcpred = blk[0];

  u_char len;

  if (diff < 0){
    len = SSSS(-diff);
    huffentry e = dcht[len];
    PUT_BITS(e.val, e.nb, nbb, bb, bc);
    PUT_BITS((diff-1)&(~(-1<<len)), len, nbb, bb, bc);
  } else {
    len = SSSS(diff);
    huffentry e = dcht[len];
    PUT_BITS(e.val, e.nb, nbb, bb, bc);
    PUT_BITS(diff, len, nbb, bb, bc);
  }

  /* code ac terms */
  int run = 0;
  const u_char* rowzag = &ROWZAG[0];
  for (int zag; (zag = *++rowzag) != 0; ) {
    int level = blk[zag];
    if (level != 0) {
      if (level < 0) {
	len = SSSS(-level);
	while (run & ~0xf) {
	  huffentry e = acht[0xf0];
	  PUT_BITS(e.val, e.nb, nbb, bb, bc);
	  run -= 16;
	}
	huffentry e = acht[(run<<4) | len];
	PUT_BITS(e.val, e.nb, nbb, bb, bc);
	PUT_BITS((level-1)&(~(-1<<len)), len, nbb, bb, bc);
      } else {
	len = SSSS(level);
	while (run & ~0xf) {
	  huffentry e = acht[0xf0];
	  PUT_BITS(e.val, e.nb, nbb, bb, bc);
	  run -= 16;
	}
	huffentry e = acht[(run<<4) | len];
	PUT_BITS(e.val, e.nb, nbb, bb, bc);
	PUT_BITS(level, len, nbb, bb, bc);
      }
      run = 0;
    } else {
      run++;
    }
  }

  if (run > 0) {
    /* EOB */
    huffentry e = acht[0];
    PUT_BITS(e.val, e.nb, nbb, bb, bc);
  }

  bb_ = bb;
  nbb_ = nbb;
  bc_ = bc;
}

void
SemicompressedToJpegEncoder::encode_mcu(u_int mcu,
					const ScBlock *lum_blks,
					const ScBlock *cr_blks,
					const ScBlock *cb_blks)
{
  const ScBlock *scb;
  short blk[64];
  int qval;

  int bidx = mcu * 2;

  memset(blk, 0, 128);
  /*  for(int i=0; i<64; i++) {
      blk[i] = 0;
      }
   */

  scb = &(lum_blks[bidx]);
  blk[0] = (((scb->dc - 128) * 8) + (lqt_[0]/2)) / lqt_[0];
  for (int i=0; i<scb->numOfAC; i++) {
    int qval = lqt_[scb->index[i]];
    blk[scb->index[i]] = (scb->value[i] + (qval/2))/qval;
  }
  encode_blk(blk, &lpred_, ldht, laht);

  memset(blk, 0, 128);
  /*  for(int i=0; i<64; i++) {
      blk[i] = 0;
      }
   */

  scb = &(lum_blks[bidx+1]);
  blk[0] = (((scb->dc - 128) * 8) + (lqt_[0]/2)) / lqt_[0];
  for (int i=0; i<scb->numOfAC; i++) {
    int qval = lqt_[scb->index[i]];
    blk[scb->index[i]] = (scb->value[i] + (qval/2))/qval;
  }
  encode_blk(blk, &lpred_, ldht, laht);

  memset(blk, 0, 128);
  /*  for(int i=0; i<64; i++) {
      blk[i] = 0;
      }
   */

  scb = &(cr_blks[mcu]);
  blk[0] = ((scb->dc * 8) + (cqt_[0] / 2)) / cqt_[0];
  for(int i=0; i<scb->numOfAC; i++) {
    qval = cqt_[scb->index[i]];
    blk[scb->index[i]] = (scb->value[i] + (qval/2)) / qval;
  }
  encode_blk(blk, &crpred_, cdht, caht);

  memset(blk, 0, 128);
  /*  for(int i=0; i<64; i++) {
      blk[i] = 0;
      }
   */

  scb = &(cb_blks[mcu]);
  blk[0] = ((scb->dc * 8) + (cqt_[0] / 2)) / cqt_[0];
  for(int i=0; i<scb->numOfAC; i++) {
    qval = cqt_[scb->index[i]];
    blk[scb->index[i]] = (scb->value[i] + (qval/2)) / qval;
  }
  encode_blk(blk, &cbpred_, cdht, caht);
}

#endif

int
SemicompressedToJpegEncoder::encode(const Semicompressed* vf)
{
  pktbuf* pb = pool_->alloc(htonl(vf->ts_), RTP_PT_JPEG);
  bs_ = &pb->data[HDRSIZE];
  bc_ = bs_;
  int fragsize = mtu_ - HDRSIZE;
  u_int ec = fragsize << 3;

  bb_ = 0;
  nbb_ = 0;
  offset_ = 0;
  lpred_ = 0;
  crpred_ = 0;
  cbpred_ = 0;

  /* RTP/JPEG header */
  rtphdr* rh = (rtphdr*)pb->data;
  u_int* h = (u_int*)(rh+1);
  h[0] = htonl(offset_);
  h[1] = htonl(quant_ << 16 | w_ << 8 | h_);

  int cc = 0;

  for (u_int mcu = 0; mcu < nmcu_; mcu++) {
    encode_mcu(mcu, vf->lum_->firstBlock,
	       vf->cr_->firstBlock,
	       vf->cb_->firstBlock);
    u_int cbits = (bc_ - bs_) << 3;
    if (cbits > ec) {
      pktbuf* npb = pool_->alloc(htonl(vf->ts_), RTP_PT_JPEG);
      cc += flush(pb, fragsize<<3, npb);
      offset_ += fragsize;
      pb = npb;

      /* RTP/JPEG header */
      rh = (rtphdr*)pb->data;
      u_int* h = (u_int*)(rh+1);
      h[0] = htonl(offset_);
      h[1] = htonl(quant_ << 16 | w_ << 8 | h_);
    }
  }

  cc += flush(pb, ((bc_ - bs_)<<3) + nbb_, 0);
  return (cc);
}

