/*
 * renderer-null.cc --
 *
 *      A null renderer: it acts as a frame sink.
 *
 *      This object (Renderer/Null in Otcl, NullRenderer in C++) is 
 *      interesting for two reasons. The first one is to provide an 
 *      easy-to-interface renderer for the simple-video-rx script. 
 *      All decoder require having a renderer after them, and interfacing 
 *      a video window renderer made the script too complicated for 
 *      docent purposes. Secondly, it's a good place to look for in 
 *      case you need to create a Renderer object that wants to process 
 *      the incoming frames in a different way than displaying them. In 
 *      this case you should modify NullRenderer::recv() to add your own 
 *      processing
 *
 * Copyright (c) 2001-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


#include <stdlib.h>
#include "renderer.h"
#include "vw.h"
#include "rv.h"

#include "tclcl.h"
#include "module.h"
#include "postdct.h"


class NullRenderer : public Renderer {
	public:
		inline NullRenderer() {};
//inline NullRenderer() {printf ("NullRenderer::NullRenderer()\n");};
		virtual int command(int argc, const char*const* argv);
	protected:
		virtual void recv(Buffer*);
		virtual void recv(Buffer*, int, int);
		virtual void resize(int w, int h);
		virtual void render(const u_char* /*frm*/, int /*off*/,
				int /*x*/, int /*w*/, int /*h*/) {};
		virtual void push(const u_char* /*frm*/, int /*miny*/,
				int /*maxy*/, int /*minx*/, int /*maxx*/) {};
};


int NullRenderer::command (int argc, const char*const* argv) {
	if (argc == 3) {
		if (strcmp(argv[1], "irthresh") == 0) {
			//int irthresh_ = atoi(argv[2]);
			return (TCL_OK);
		}
	}
	return (Renderer::command(argc, argv));
}

void NullRenderer::recv (Buffer* bp) {
	recv(bp, CODEC_ANY, 0);
}

void NullRenderer::recv (Buffer* bp, int /* codec */, int /* quality */) {
	const VideoFrame* vf = (VideoFrame*)bp;
	if (!samesize(vf))
		resize(vf->width_, vf->height_);
	//YuvFrame* p = (YuvFrame*)vf;

	// we could want to print something about the frame
	//printf ("frame with timestamp %i, size %i x %i\n", 
	//		p->ts_, p->width_, p->height_);
	return;
}

void NullRenderer::resize (int w, int h) {
	// print something about the frame
	printf ("resizing to %ix%i\n", w, h);

	width_ = w;
	height_ = h;
	return;
}


static class NullRendererClass : public TclClass {
public:
	NullRendererClass() : TclClass("Renderer/Null") {}
  TclObject* create(int argc, const char*const* /* argv */) {
		if (argc != 4)
				abort();
		return (new NullRenderer());
	}
} nullrenderer_class;

