# avswitch-ui.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1996-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/avswitch-client/avswitch-ui.tcl,v 1.14 2002/02/03 04:21:34 lim Exp $


#
# UI for talking to an AVSwitchServer
#
Class AVSwitchUI


#
# init method takes window and and address specificationx
#
AVSwitchUI public init {w addrspec} {

    $self instvar al_ audio_ video_ routingType_ in_update_

    # if addrspec includes a name, turn it into IP addr
    set firstchar [string index $addrspec 0]
    if [string match \[a-zA-Z\] $firstchar] {
	set n [lindex [split $addrspec "/"] 0]
	set p [lindex [split $addrspec "/"] 1]
        set s [gethostbyname $n]
        if { $s == "" } {
            puts "cannot find address for '$n'"
            exit
        }
        set addrspec $s/$p
    }

    set routingType_ b
    set al_ [new ALM/AVSw/Client $addrspec $self]
    for {set j 1} {$j < 9} {incr j} {
	set audio_($j) 0
	set video_($j) 0
    }
    set in_update_ 0

    $al_ announce refresh_settings
    $self build_gui $w
    update
    $self refresh_ui
}

#
# destructor method
#
AVSwitchUI public destroy {} {
    $self instvar al_
    delete $al_
    eval [list $self] next
}

AVSwitchUI public print_status {} {
    $self instvar audio_ video_

    puts ""
    puts "       Routing"
    puts "   1:2:3:4:5:6:7:8"
    for {set i 1} {$i <= 8} {incr i} {
	puts -nonewline "$i: "
	if {$audio_($i) == $video_($i)} {
	    # just a "B"
	    $self put_letter "B" $audio_($i)
	    puts ""
	} else {
	    # put a "V" and "A"
	    if {$audio_($i) < $video_($i)} {
		$self put_letter "A" $audio_($i)
		$self put_letter "V" [expr $video_($i) - $audio_($i)]
		puts ""
	    } else {
		$self put_letter "V" $video_($i)
		$self put_letter "A" [expr $audio_($i) - $video_($i)]
		puts ""
	    }
	}
    }
    puts ""
}

AVSwitchUI private put_letter {letter dist} {
    for {set j 1} {$j < $dist} {incr j} {
	puts -nonewline "  "
    }
    puts -nonewline "$letter "
}

AVSwitchUI private build_gui {w} {
    $self instvar al_ routingType_ matrix_ input_labels_

    # build bottom informational label
    set il $w.infolabel
    frame $il -relief groove
    label $il.l -text "A/V Switch Controller (326 Soda CoLab)"
    pack $il -side bottom -fill x -expand 1
    pack $il.l -in $il -side bottom

    # build button colums
    set b $w.btns
    frame $b -relief groove
    pack $b -side left -anchor s
    button $b.b1 -command "$al_ announce refresh_settings" \
	    -text "resynchronize"
    button $b.b2 -command "$al_ announce test_LEDs" -text "test lights"
    button $b.b3 -command "$self print_status" -text "print status"
    button $b.e -command "exit" -text "EXIT"
    pack $b.e $b.b3 $b.b2 $b.b1 -fill x -side bottom

    frame $b.routing -relief groove
    label $b.routing.label -text "Route:"
    radiobutton $b.routing.a -variable routingType -text "Audio" -value a \
	    -fg darkgreen -command "$self set routingType_ a"
    radiobutton $b.routing.v -variable routingType -text "Video" -value v \
	    -fg blue -command "$self set routingType_ v"
    radiobutton $b.routing.b -variable routingType -text "Both" -value b \
	    -fg "#b03060" -command "$self set routingType_ b"
    pack $b.routing.label -in $b.routing -anchor w -side left
    pack $b.routing.b $b.routing.v $b.routing.a -in $b.routing
    pack $b.routing -fill x -expand 1 -pady 2 -side bottom
    $b.routing.$routingType_ invoke

    # build routing matrix
    set m $w.matrix
    set matrix_ $m
    frame $m
    pack $m -side right
    set rowLabels [list "monitor 1" "monitor 2" "monitor 3" "VCR" \
	    "(null)" "diamond" "heart" "club"]

    for {set i 1} {$i <= 8} {incr i} {
        frame $m.rowFrame$i
	label $m.rowFrame$i.l -text [lindex $rowLabels [expr $i-1]]
    }

    for {set i 1} {$i <= 8} {incr i} {
        for {set j 1} {$j <= 8} {incr j} {
            checkbutton $m.r$i$j -command "$self invoke_button $i $j"
	}
    }
    # these are for the iput labels
    $self build_input_labels
    frame $m.rowFrame0
    pack $m.rowFrame0 -expand 1 -in $m -anchor w
    label $m.rowFrame0.l -image $input_labels_
    pack $m.rowFrame0.l -in $m.rowFrame0 -side left -padx 3
    for {set i 1} {$i <= 8} {incr i} {
        pack $m.rowFrame$i -expand 1 -in $m -anchor w
	pack $m.rowFrame$i.l -in $m.rowFrame$i -side right
    }
    for {set i 1} {$i <= 8} {incr i} {
        for {set j 1} {$j <= 8} {incr j} {
            pack $m.r$i$j -in $m.rowFrame$i -side left
        }
    }

    bind . <q> exit
}

AVSwitchUI private repaint_matrix {} {
    $self instvar audio_ video_ matrix_ in_update_

    if {$in_update_ == 1} {
	return
    }

    set m $matrix_

    # check if still waiting for update
    if {[lsearch [array get audio_] 0] != -1 || \
	    [lsearch [array get video_] 0] != -1} {
#puts "waiting for update..."
	[$self set al_] announce refresh_settings
	return
    }

    set in_update_ 1

    for {set i 1} {$i <= 8} {incr i} {
        for {set j 1} {$j <= 8} {incr j} {
            $m.r$i$j deselect
	}
    }
    for {set i 1} {$i <= 8} {incr i} {
	if {$audio_($i) == $video_($i)} {
	    $m.r$i$audio_($i) configure -selectcolor "#b03060"
	    $m.r$i$audio_($i) select
	} else {
	    $m.r$i$audio_($i) configure -selectcolor darkgreen
	    $m.r$i$audio_($i) select
	    $m.r$i$video_($i) configure -selectcolor blue
	    $m.r$i$video_($i) select
	}
    }
    set in_update_ 0
}

AVSwitchUI private invoke_button {i j} {
    $self instvar routingType_ audio_ video_
    #puts "$routingType_: $i $j"

    set al [$self set al_]
    if {$routingType_ == "a"} {
	set audio_($i) $j
	$al announce "route_audio $i $j"
    } elseif {$routingType_ == "v"} {
	set video_($i) $j
	$al announce "route_video $i $j"
    } else {
	set audio_($i) $j
	set video_($i) $j
	$al announce "route_both $i $j"
    }
    $self repaint_matrix
}

AVSwitchUI private refresh_ui {} {
    $self repaint_matrix
}


#
# This is an embedded gif of vertical input labels
#

# -- These cmds generate a list that can then be rotated, saved
# -- as a .gif, and put into the avswitch via conversion by image2tcl
#
#set columnLabels [list "heart" "diamond" "club" "VCR" "cam1 (red)" \
#		"cam2 (yellow)" "cam3 (blue)" "cam4 (green)"]
#for  {set i 1} {$i <= 8} {incr i} {
#	label .l$i -text [lindex $columnLabels [expr $i-1]]
#	pack .l$i -anchor w -pady  3 }
#
# -- The result for the current inputs are embedded in the following
AVSwitchUI private build_input_labels {} {
    $self instvar input_labels_

    image create photo AVSwInputs
    AVSwInputs put \x47\x49\x46\x38\x39\x61\xC2\x0\x56\x0\x91\x0\x0\xD8\xD8\xD8\x0\x0\x0\xFF\xFF\xFF\xFF\xFF\xFF\x21\xF9\x4\x0\x0\x0\x0\x0\x2C\x0\x0\x0\x0\xC2\x0\x56\x0\x0\x2\xFF\x84\x8F\xA9\xCB\xED\xF\xA3\x9C\x31\xD8\x4B\xB3\xDE\xBC\xFB\xF\x2A\xD7\x88\x85\xE6\x89\xA6\x6A\x56\x22\xED\xA\xC7\xF2\x2C\x5\x8E\x4D\xE7\xFA\xCE\xF7\xFE\xF\xC\xA\x87\xC4\x90\xA5\x68\x20\xE1\x90\x4C\x18\x49\xA8\x1C\x35\xA7\xAA\xA7\xEF\x95\x3C\x52\xB7\x27\x6D\x6F\xB9\x0\x73\xC7\x13\x2B\xF9\x8C\xBE\x49\xD3\xEC\x76\x58\xFC\x35\xBB\xE7\x9\x79\xDC\x4E\x77\xE3\xBF\xF9\xBE\x8\xBE\xA1\xC4\x1\xE8\x57\x18\x18\xE5\x55\x23\x68\xA8\xB7\x46\x81\x5\x0\xA9\xB6\xC7\xC8\x15\xC5\x72\x53\xA9\xF9\x20\x46\xA8\x83\xE1\xB9\xD9\x45\xC9\x59\x17\x24\x95\x28\x8A\x82\x98\xA\x71\x79\x68\x13\x9A\x19\x99\xA4\x5A\xD5\x2A\x39\xD9\xAA\x78\xB4\xEB\x5A\x4B\x6B\xBB\x3A\xCB\x83\x63\xC\xEB\x28\xCC\xC4\x1A\x8\x2C\xDB\x40\xAA\x7C\x8A\x88\x9C\x2B\xD\xC4\x3C\x6D\xED\xDA\x7B\x6D\x92\x5D\x46\x8D\xD\xFA\xEC\x5D\x76\x50\x5E\x27\xCE\xB2\x88\x19\x9C\x6E\x5E\xEA\xA2\x9D\x7C\xFE\x1E\xF\xF2\xAA\x1\x6A\x34\xD8\x8E\xDF\x21\x9A\xAE\x48\xF0\x88\xB1\xDB\x6\x70\xC7\xB1\x60\x7\xEB\x29\x4A\x38\x2A\xD6\x20\x67\xD5\xA\xBA\xB0\x8\x91\x1\x2A\x8C\xFF\x4\x5\xCE\xF0\x95\xD1\xDE\xC2\x7D\xE\xB9\xE9\x7B\xF4\x2F\x64\xD\x8A\x57\xD6\xA1\xF4\xA8\x52\x1D\xCC\x3F\xF8\xC0\xF9\x99\xF9\x7\x24\x2F\x9D\xBA\x70\x9A\x4C\x49\x87\x67\x38\x84\x1A\x81\x56\xB0\xD9\xF\x58\x21\xA1\x2F\x99\xCE\x7B\xBA\xF\x9D\xD4\x2E\xA6\xC\x39\xE5\x54\xE2\xAA\x52\x8E\xC\x59\x7E\x33\xDA\xC8\x27\x3A\x2C\xE9\x90\xEE\x24\x97\x42\xEC\x96\x93\xE1\x3C\x98\x3D\xAB\x34\xA6\x5C\x19\x60\xD3\x84\x2A\x6B\x30\x6F\xD5\x5F\xD0\x56\xD5\x45\x3\x89\x68\x16\x38\x82\x3B\xE6\xE4\x75\x98\xEA\x26\x56\x5\x19\x37\xFD\x9B\x93\x6D\xD2\xC5\x6A\x7\x17\x8E\xAC\xF5\x62\xC9\x7C\x90\xE7\x4A\x93\xEC\x39\xB4\xE8\x78\x95\x47\x2F\xED\x6C\x7A\xF1\xDE\xD4\x45\x9E\x71\xED\xE4\x39\x15\xC6\x5E\x97\xC7\xB2\x85\x4D\xB2\x34\xE5\x44\x16\xDF\xF6\x74\xE4\xFB\x27\x57\x24\xC1\x35\x66\x99\x2A\x12\xAA\xBD\xB8\x1D\x75\xEF\x46\xD\x55\x4B\xEF\xB8\x1C\xA5\x87\xF9\xBA\x99\xCD\xF0\xB1\xB6\x7B\x77\x1A\x2E\x91\xE6\x7\xD0\x6D\xB6\x23\x37\xEC\xEE\xFC\xA1\x37\xF9\x58\x7\x35\x6F\x3E\xE2\x60\x7F\xD9\xB1\xD6\xFF\x4D\x9F\x2C\x74\xCC\xAF\xEF\xBF\xFF\x21\x6F\x9F\x7F\xFF\x9\xC8\x5F\x75\x29\x1\xF8\x9B\x81\x62\x2D\x91\xD9\x6A\x1\x4D\xE6\x56\x7A\x8F\x40\xD8\x55\x5\xEA\x45\xD5\x5E\x86\xE3\x9\x57\xDD\x37\x17\xF2\x55\x61\x45\xF9\x35\x68\x19\x89\xCD\xC9\xA6\xDB\x7E\x25\x12\xD8\x5D\x65\x8\x42\xA3\x62\x8B\x24\xDE\xE6\xD5\x63\x99\x15\x37\xA0\x8B\x14\x4E\xA4\xA1\x71\xF7\xF4\x98\x47\x7C\x21\x36\x3\x24\x4D\x2C\xCA\x54\x9B\x8C\xB3\x39\x68\xE3\x88\xFD\x1D\xA9\x59\x60\xC7\x89\x58\x91\x77\xEA\x54\x89\x65\x6E\x50\xAE\x28\xA4\x8\x35\xF2\x38\xA1\x97\x45\x12\xB9\x61\x91\xFC\x10\x39\x52\x84\x61\x32\x79\xD6\x93\x49\xCA\xE8\x24\x92\x4\xAD\xB7\xE5\x89\x37\x7E\x47\xA5\x96\x26\xC6\x8\x67\x55\x69\x86\xB9\xA7\x8B\x7C\xB2\xD4\xE1\x8F\xEE\xFC\xB9\x92\xA1\x84\x5A\x55\xE7\xA2\x18\x22\x6A\xA1\xA2\xC9\x55\xF8\xA2\x97\x95\x22\xE9\xDC\x78\xB1\xBC\x39\x67\x9D\xB4\xCD\xB8\x29\x2E\x5B\x86\xA\x25\x8E\xE2\x25\x65\xE2\x3B\xE0\x4D\x89\x66\x97\x96\x34\x2A\x57\x8C\xA6\xFA\x38\xE4\x51\x9C\x22\xB7\x2A\x73\x6B\xE6\x1A\xE2\xA5\x51\xA\xCA\x9D\x5B\xA0\x6\xCB\xE\xB1\x28\x19\xDB\x16\xAB\xBA\x36\x82\xF9\x1A\x9B\x2F\x91\xB9\x2C\x88\xD1\xCA\xF3\xA1\xB4\xBD\x2\x59\x68\xB5\x1\xF2\x3A\x6D\x5E\xD9\x76\xDB\x57\x74\x2E\xD\xE5\xA9\xAC\xB0\x72\x99\x65\x43\x9C\xEA\x33\x6B\x8E\x1\x8D\xEA\x6A\x8A\xB0\xCA\xFB\x42\x1\x0\x3B

    set input_labels_ AVSwInputs
}


#----------------------------------------------

import AnnounceListenManager

#
# AVSwitch RPC-style interface client
#
Class ALM/AVSw/Client -superclass AnnounceListenManager


ALM/AVSw/Client public init {addrspec parent {mtu 1500}} {
    eval [list $self] next $addrspec $mtu

    $self instvar parent_
    set parent_ $parent
    $self ttl 16
}

#
# receive (only) matrix state updates of the form
# "v: <array> ; a: <array>"
#
ALM/AVSw/Client private recv_announcement {addr port data size} {
    #puts "Msg: $addr/$port\[$size\]: $data"
    $self instvar parent_

    # filter other client's requests
    if {$data == "refresh_settings"} {return}

    set t [split $data ";"]
    set vid [lindex $t 0]
    set aud [lindex $t 1]
    set vid [string trim  $vid " "]
    set aud [string trim  $aud " "]
    if {[string range $vid 0 2] != "v: " || [string range $aud 0 2] != "a: "} {
		puts "bad msg received from AVSw server: $data"
		return
    }
    #puts "got status"
    set vid [string range $vid 3 end]
    set aud [string range $aud 3 end]
    $parent_ array set audio_ $aud
    $parent_ array set video_ $vid
    $parent_ refresh_ui
}

