# mbv2-srm.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/mbv2/mbv2-srm.tcl,v 1.9 2002/02/03 04:21:59 lim Exp $


# make MBv2Session be an observable

import mashutils AddressBlock


# in order to allow apps (such as collaborator) that import MBv2 to work
# even if mbv2 is not compiled into the mash binary, we explicitly define
# dummy classes MBv2Session, MBv2Sender and MBv2Source here, in case they
# don't already exist
if { [Class info instances MBv2Session] == "" } {
	Class MBv2Session
	Class MBv2Sender
	Class MBv2Source
} else {
	MBv2Session superclass \
			[concat [MBv2Session info superclass] Observable]
}

MBv2Session public init { spec cname } {
	set ab [new AddressBlock $spec]
	set ttl [$ab ttl]
	if { $ttl=={} } { set ttl -1 }
	$self next [$ab addr] [$ab sport] [$ab rport] $ttl
	delete $ab

	$self set spec_ $spec
	# create the sender object
	$self instvar sender_
	set sender_ [new MBv2Sender $self $cname]
	# notify the C++ side of this object
	$self sender $sender_
}


MBv2Session public spec { } {
	$self instvar spec_
	return $spec_
}


MBv2Session public sender { args } {
	if { [llength $args] == 0 } {
		return [$self set sender_]
	} else {
		eval [list $self] next $args
	}
}


MBv2Session public canvasmgr { canvmgr } {
	$self set canvmgr_ $canvmgr
}


MBv2Session public get_canvas { pageid } {
	if [catch {set c [$self get_canvas_ $pageid]} m] {
		global errorInfo
		puts $m\n$errorInfo
		return ""
	}
	return $c
}


MBv2Session public get_canvas_ { pageid } {
	$self instvar canvmgr_
	if ![info exists canvmgr_] return ""
	set c [$canvmgr_ get_canvas $pageid]
	return $c
}


MBv2Session public source_name { srcid } {
	$self instvar canvmgr_
	return [$canvmgr_ source_name $srcid]
}


MBv2Session public source_update { src info } {
	set info  [split $info \n]
	set name  [lindex $info 0]
	set cname [lindex $info 1]
	$self notify_observers source_update $src $name $cname
}


MBv2Session public app_info { sender name cname } {
	set info "$name\n$cname"
	$sender app_info $info
	$self source_update $sender $info
}


MBv2Session public activity { srcid pageid cmdid canvid islocal } {
	$self notify_observers activity $srcid $pageid $cmdid $canvid $islocal
}


MBv2Sender superclass MBv2Source
