# ui-univ.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1996-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/uc/ui-univ.tcl,v 1.13 2002/02/03 04:22:33 lim Exp $


import mashutils Trace Observer RendezvousManager UIGenerator SrvAllocUI

# import some default client UIs
import AVSwitchUI CameraUI PowerSwitchUI RvicClientUI

# load http namespace
::http::formatQuery


#Trace on
#Trace add UniversalUI
#Trace add checkButtonInvoke


# ---  Notes / Bugs  ---------------
# Checkbuttons:
# - clicking too rapidly will crash it due to a race(?) condition:
#     somehow a second invoke get called before a first one finishes.
# ----------------------------------


#
# a UI that wraps client UI agents.
#
Class UniversalUI -superclass Observer


# init method takes
# args are a tk window to parent the UniversalUI
# and a list of pairs of the form
# <br> 'Client-UI-agent-class' 'Server-address-spec'
# <br>i.e.,<br> AVSwitchUI spade/1211 CameraUI spade/1212
#
UniversalUI public init {w args} {
    Trc $class "--> ${class}::$proc"
    $self next

    $self parse_components $args
    $self read_mysrvs_files
    $self init_gui $w
    $self read_omappings_file
    $self init_rendez
    $self update_gui
}

#
UniversalUI public destroy {} {
    $self instvar rv_
    $rv_ detach_observer $self
    $self next
}

# build list of components: each client UI agent can have one or
# more servers (addresses) it can connect to.
UniversalUI private parse_components {args} {
    Trc $class "--> ${class}::$proc $args"
    $self instvar components_ active_
    set args [lindex $args 0]

    foreach {agent addrspec} $args {
	# import native agents
	if {[string first "WPI:" $agent]!=0 && [string first "-" $agent]!=0} {
	    import $agent
	    if {[info commands $agent] == ""} {
		puts "Cannot find class $agent .. ignoring it"
		continue
	    }
	    # if addrspec includes a name, turn it into IP addr
	    set n [lindex [split $addrspec "/"] 0]
	    set p [lindex [split $addrspec "/"] 1]
	    set s [gethostbyname $n]
	    if { $s == "" } {
		puts "cannot find address for '$n'... ignoring it."
		continue
	    }
	    set addrspec $s/$p
	}

	# only add components once
	if {[array names components_ $agent] == "" || \
		[lsearch -exact $components_($agent) $addrspec] == -1} {
	    lappend components_($agent) $addrspec
	}
    }
    foreach i "[array names components_]" {
	if {[array names active_ $i] == ""} {
	    # checkbuttons default off
	    set active_($i) 0
	}
    }
    #parray components_
}

# read in saved/"custom-designed" services <p> (i.e., things the
# user has saved in their `mysrvs' directory, either for use outside
# the location where it normally dynamically discovered or as
# a totally new service built upon other services.
#<p>
# These are XML files for use with automatic UI generation,
# but since the XML can embed whole UIs with the <UI> tag,
# this covers all cases (mixed use).
#
UniversalUI private read_mysrvs_files {} {
    set d [$self get_option mySrvsDir]
    Trc $class "${class}::${proc} : mySrvsDir = `$d'"
    if {![file isdirectory $d] || [catch {glob $d/*} catchRes]}  {
	puts "Personal services directory not specified/accessable/empty:"
	puts " No personal services will be loaded."
    } else {
	foreach f [glob $d/*] {
	    $self parse_components "-[file tail $f] local-file"
	}
    }

}


# --------------------------------------------------
# Methods for dealing with GUI stuff
# --------------------------------------------------


#
UniversalUI private init_gui {w} {
    Trc $class "--> ${class}::$proc"
    $self instvar components_ curAddr_ w_ uigen_
    set w_ $w
    set uigen_ [new UIGenerator]

    # list of clients
    frame $w.listFrame -relief sunken
    pack $w.listFrame -side left -expand 1

    # footer
    frame $w.listFrame.foot -relief groove
    label $w.listFrame.foot.l -text "  UC  v[version]"
    pack $w.listFrame.foot.l -fill x
    pack $w.listFrame.foot -side bottom -fill x -expand 1

    # application UI side frame
    frame $w.appFrame
    pack $w.appFrame -side right -fill y -expand 1

    bind . <q> exit
}

# updates list of components based on contents of compnents_ array
UniversalUI private update_gui {} {
    Trc $class "--> ${class}::$proc"
    $self instvar components_ curAddr_ w_
    set w $w_
    set need_repack 0

    foreach uiType "[array names components_]" {
	if {[info commands $w.listFrame.cb$uiType] == ""} {
	    set need_repack 1
	    # for each type we have a checkbox
	    checkbutton $w.listFrame.cb$uiType -text "$uiType" \
		    -command "$self checkButtonInvoke $uiType"
	}
	set count 0
	foreach addr [lsort $components_($uiType)] {

	    set addrlabel [lindex [split $addr /] 0]
	    set addrlabel [lookup_host_name $addrlabel]
	    if ![invalid_addr $addrlabel] {
		set addrlabel $addr
	    } else {
		set addrlabel [lindex [split $addrlabel .] 0]
	    }

	    if {[info commands $w.listFrame.rb$uiType$count] == ""} {
		set need_repack 1

		# under each type we have a radiobutton for each addr
		radiobutton $w.listFrame.rb$uiType$count -padx 10 \
			-text "$addrlabel" \
			-command "$self radioButtonInvoke $uiType $addr" \
			-variable dummyVar$uiType -value $count
		if {$count == 0} {
		    set curAddr_($uiType) $addr
		    $w.listFrame.rb$uiType$count invoke
		}
	    } else {
		$w.listFrame.rb$uiType$count configure \
			-text "$addrlabel" \
			-command "$self radioButtonInvoke $uiType $addr" \
			-value $count
	    }
	    incr count
	}
    }
    if $need_repack {
	foreach i [info commands $w.listFrame.cb*] {pack forget $i}
	foreach i [info commands $w.listFrame.rb*] {pack forget $i}
	foreach uiType "[lsort [array names components_]]" {
	    pack $w.listFrame.cb$uiType -side top -anchor w
	    set count 0
	    foreach addr $components_($uiType) {
		pack $w.listFrame.rb$uiType$count -side top -anchor w
		incr count
	    }
	}
    }
}

#
# toggles active_($agent), which indicates whether the UI for
# the agent is being shown
#
UniversalUI private checkButtonInvoke {agent} {
    Trc $class "--> ${class}::$proc"
    Trc $proc "--> ${class}::$proc"
    #puts $agent

    $self instvar active_ agents_ w_ curAddr_ uigen_

    if {$active_($agent) == 0} {
	# was off: build and pack it

	frame $w_.appFrame.ag$agent
	pack $w_.appFrame.ag$agent -side right

	if {[string first "WPI:" $agent]==0} {
        global env
	    set filename [string range $agent 4 end]
	    set filename [file join $env(HOME) .mash WPI $filename]
	    set o [$uigen_ GenerateUIfromFile $filename $w_.appFrame.ag$agent]
	    # set this to list of sub-agents allocated internally to gen'd UI
	    set agents_($agent) $o
	} elseif {[string first "-" $agent]==0} {
	    set filename [string range $agent 1 end]
	    set dir [$self get_option mySrvsDir]
	    set filename [file join [glob $dir] $filename]
	    set o [$uigen_ GenerateUIfromFile $filename $w_.appFrame.ag$agent]
	    set agents_($agent) $o
	} else {
	    set agents_($agent) \
		    [new $agent $w_.appFrame.ag$agent $curAddr_($agent)]
	}
	set active_($agent) 1
    } else {
	# was on, destroy the agent

	# can be a list due to multiple <UI> tags in a gen'd UI
	foreach a $agents_($agent) {
	    Trc $class "deleting `$a'"
	    delete $a
	}
	pack forget $w_.appFrame.ag$agent
	destroy $w_.appFrame.ag$agent
	Trc $class "destroyed $w_.appFrame.ag$agent"
	set active_($agent) 0
    }
    Trc $proc "<-- ${class}::$proc"
}

#
UniversalUI private radioButtonInvoke {agent addr} {
    Trc $class "--> ${class}::$proc"
    #puts "$agent $addr"
    $self instvar curAddr_ active_

    if {$curAddr_($agent) == $addr} {
	return
    }
    set curAddr_($agent) $addr
    if {$active_($agent)} {
	update
	$self checkButtonInvoke $agent
	update
	$self checkButtonInvoke $agent
	update
    }
}




# --------------------------------------------------
# Methods for dealing with a RendezvousManager and
#  its upcalls
# --------------------------------------------------


#
UniversalUI private init_rendez {} {
    Trc $class "--> ${class}::$proc"
    $self instvar rv_

    set rspeclist [$self get_option rendez]
    if {$rspeclist==""} {return}

    set rv [RendezvousManager info instances]
    if {[llength $rv] > 1} {
	puts "Warning: Multiple RendezvousManagers"
	set rv [lindex $rv 0]
    }
    if {$rv == ""} {
	set rv_ [new RendezvousManager $rspeclist]
    } else {
	set rv_ $rv
	foreach s [split $rspeclist ,] {
	    $rv_ add_spec $s
	}
    }

    $rv_ attach_observer $self
}

# some example msgs -- (This is never called! -- it is an e.g.!)
UniversalUI private test_msgs {} {
    Trc $class "--> ${class}::$proc"
    $self instvar rv_
    after 2000 "$rv_ recv_msg w x y \
	    {obj-mapping: server=mash-object:ServObjName\
	    client=mash-object:ClientObjName} z"
    after 4000 "$rv_ recv_msg w x y \
	    {will-provide: mash-object=ServObjName ctrlspec=AddrSpec} z"
    after 6000 "$rv_ recv_msg w x y \
	    {will-provide: name=326 mash-object=Serv2ObjName \
	    ctrlspec=mercenary/9988 \
	    WPI=http://www.cs.berkeley.edu/~hodes/WPI/326power.xml} z"
    after 8000 "$rv_ recv_msg w x y \
	    {will-provide: name=326-w-ui mash-object=Serv2ObjName \
	    ctrlspec=mercenary/9988 \
	    WPI=http://www.cs.berkeley.edu/~hodes/WPI/326power-w-ui.xml} z"
    after 9000 "$rv_ recv_msg w x y \
	    {will-provide: name=405lights ctrlspec=htsr/6902 \
	    WPI=http://www.cs.berkeley.edu/~hodes/WPI/405lights.xml} z"
}

# a new server is available, so allocate the client
UniversalUI private new_service_avail {rspec agent ctrladdr} {
    Trc $class "--> ${class}::$proc"
    $self parse_components "$agent $ctrladdr"
    $self update_gui
}



# Accepts an upcall from an (Observable) RendezvousManager when a msg of
# type ``will-provide'' is received.
#<p>
# Checks for msgs of the form:
# <br>
# "will-provide: mash-object=`ObjName' ctrlspec=`AddrSpec' [`Attr'=`Val'] ..."
# <br>or<br>
# "will-provide: WPI=http://... [`Attr'=`Val'] ..."
# <br>
# which are announcements of available services
#
UniversalUI private rendez_recv_will-provide {rvmsg} {
    Trc $class "--> ${class}::$proc"
    set ob [$rvmsg get_field mash-object]
    if {$ob != ""} {
	# is a mash object: check for matching client mash object
	set clForObj [$self get_omapping $ob]
	if {$clForObj != ""} {
	    set ad [$rvmsg get_field ctrlspec]
	    if {$ad != ""} {
		$self new_service_avail [$rvmsg rspec] $clForObj $ad
		return
	    }
	} else {
	    Trc $class "unknown client object for server `$ob'"
	}
    }
    # if we got here, either its not a mash object, or we have no
    # client for it, or no ctrladdr -- attempt to generate a UI
    $self use_WPI $rvmsg
}

# recv a `can-allocate' method -- allocate a SrvAllocUI agent for it.
#
UniversalUI private rendez_recv_can-allocate {rvmsg} {
    Trc $class "--> ${class}::$proc"
    $self instvar rv_
    set rspec [$rvmsg rspec]
    $self new_service_avail $rspec SrvAllocUI $rspec
}


#
UniversalUI private use_WPI {rvmsg} {
    Trc $class "--> ${class}::$proc"
    $self instvar rv_

    set url [$rvmsg get_field WPI]
    if {$url != ""} {
	set name [$rvmsg get_field name]
	if {$name == ""} {
	    puts "Using a `will-provide' WPI with no name field"
	}
	if {[$self get_WPI $url $name] == 0} {return}
	# let the application know that this new service is
	# available but needs to have its UI dynamically generated
	# by prepending "WPI:" to its component name
	set spec [$rvmsg rspec]
	$self new_service_avail $spec WPI:$name [$rv_ get_spec_name $spec]
    } else {
	puts "no WPI for dynamically generating a UI: ignoring new service."
    }
}

# Checks for msgs of the form:
# <br>
# "object-mapping: server=mash-object=`ObjName' client=mash-object=`ObjName'"
# <p>
# which are mappings from a server type to a client type.
#
UniversalUI private rendez_recv_obj-mapping {rvmsg} {
    Trc $class "--> ${class}::$proc"
    set cli "" ; set ser ""
    set data [$rvmsg get_msg]
    foreach i [lrange $data 1 end] {
	if {[string first "server=" $i]==0} {
	    set idx [string first = $i]
	    set ser [string range $i [expr $idx+1] end]
	}
	if {[string first "client=" $i]==0} {
	    set idx [string first = $i]
	    set cli [string range $i [expr $idx+1] end]
	}
    }
    if {$cli == "" || $ser == ""} {
	puts "bad `obj-mapping:' message: $data"
	return
    }
    foreach i "$cli $ser" {
	set obType [lindex [split $i :] 0]
	if {$obType != "mash-object"} {
	    puts "ignoring unknown obj type: $obType"
	    return
	}
    }
    set idx [string first : $cli]
    set cli [string range $cli [expr $idx+1] end]
    set idx [string first : $ser]
    set ser [string range $ser [expr $idx+1] end]
    if {[$self set_omapping $ser $cli]} {
	puts "adding mapping from $ser to $cli"
    } else {
	# we've already mapped it, no msg to user
    }
}



# load mappings:
#   "server object to client object"
#   "client object to WRI"
#
UniversalUI private read_omappings_file {{filename ""}} {
    Trc $class "--> ${class}::$proc"

    set mf $filename
    if {$filename == ""} {
        global env
        set mf [file join $env(HOME) .mash obj-mappings]
    }
    if [file readable $mf] {
	set fp [open $mf r]
	set filedata [read $fp]
	set linedata [split $filedata "\n"]
	foreach i $linedata {
	    set j [string trim $i]
	    if {$j == ""} {continue}
	    if {[string index $j 0] == "#"} {continue}
	    if {[llength $j] != 2} {
		puts "error in mapping file `$mf' format:"
		puts "  `$j'"
		continue
	    }
	    $self set_omapping [lindex $j 0] [lindex $j 1]
	}
	close $fp
    } else {
	puts "Mapping file `$mf' not found/readable..."
    }
}

# get client object name for a given server object name
# or return {} if no mapping available
UniversalUI public get_omapping {serverObj} {
    Trc $class "--> ${class}::$proc"
    $self instvar obj_mappings_
    if {[array names obj_mappings_ $serverObj] != ""} {
	return $obj_mappings_($serverObj)
    } else {
	return ""
    }
}

# set serverObj mapping to clientObj ; returns 1 if it
# is a new mapping or 0 if not
UniversalUI public set_omapping {serverObj clientObj} {
    Trc $class "--> ${class}::$proc"
    $self instvar obj_mappings_
    #puts "UniversalUI:set_omapping : $serverObj $clientObj"

    set old ".Invalid."
    if {[array names obj_mappings_ $serverObj] != ""} {
	set old $obj_mappings_($serverObj)
    }
    set obj_mappings_($serverObj) $clientObj
    if {$old == $clientObj} {
	return 0
    } else {
	return 1
    }
}


#
# Get the WPI at `url', save it to a file under ~/.mash/WPI/
#
UniversalUI private get_WPI {url obj_name} {
    Trc $class "--> ${class}::$proc"

    if {$obj_name == ""} {
	set obj_name [$self URLToFilename $url]
    }
    global env
    set path [file join $env(HOME) .mash WPI]
    if ![file isdirectory $path] {
	puts "Creating directory `$path' to hold WPIs."
	file mkdir $path
    }
    set fullname [file join $path $obj_name]
    if ![file readable $fullname] {
	#puts "getting `$url', putting in $fullname ..."
	return [$self copyURLtoFile $url $fullname]
    }
    return 1
}

# url-to-file copy
# <br> returns ::http state token on success, 0 on error
#
UniversalUI private copyURLtoFile { url file {chunk 4096} } {
    Trc $class "--> ${class}::$proc"
    puts "Requesting URL $url ..."
    set out [open $file w]
    set token [::http::geturl $url -channel $out -blocksize $chunk]
    close $out
    set retVal [::http::code $token]
    if {[lindex $retVal 1] != 200} {
	puts "Error: HTTP request failed: $retVal"
	return 0
    }
    ::http::reset $token
    return $token
}

#
UniversalUI private URLToFilename {url} {
    Trc $class "--> ${class}::$proc"
    set name [split $url /]
    set name [join $name ,]
    #puts "url `$url' maps to filename `$name'"
    return $name
}

#
UniversalUI private FilenameToURL {filename} {
    Trc $class "--> ${class}::$proc"
    set url [split $filename ,]
    set url [join $name /]
    return $url
}

