# anm-view-nam.tcl --
#
#       AnmView/Nam
#           Viewer of (Network Animator) Nam Animations
#
# Copyright (c) 1993-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#-----------------------------------------------
#  AnmView/Nam --
#        Viewer of (Network Animator) Nam Animations
#

Class AnmView/Nam -superclass AnmView

AnmView/Nam instproc init {{pathname {}}} {
        DbgVar pathname
        $self next $pathname
}

AnmView/Nam instproc attach_datasrc {datasrc} {
        $self next $datasrc
}

AnmView/Nam instproc destroy {} {
        $self next
}

AnmView/Nam instproc handle {eId event} {
        $self instvar objects_ edges_

        # (c.r. DataSrc/Local/Nam instproc convert_... for format of event)

        set objType [removeFirst event]
        # DbgOut "handle $eId $event"
        # DbgVar event
        if ![info exists objects_($eId)] {
                set obj [eval new AnmObj/$objType $eId $event]
                $self insert_AnmObj $obj
        }
}
