# ui-stats.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1993-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/common/ui-stats.tcl,v 1.28 2002/02/03 04:25:43 lim Exp $


#FIXME this module needs a lot more work.

import TopLevelWindow Timer Observer Configuration

#
# This abstract base class implements some common features of TopLevelWindows
# that can be easily quit.
#
Class QuitWindow -superclass TopLevelWindow

#
# A toplevel window for displaying information about a source, along with providing access
# to more detailed information, such as network statistics.
#
Class InfoWindow -superclass {QuitWindow Timer} -configuration {
	infoHighlightColor LightYellow2
	# list of sdes items to display in info window
	sdesList "cname tool email note"
}

#
# A toplevel window for displaying the SCUBA votes for a source.
#
Class ScubaInfoWindow -superclass {QuitWindow Timer Observer}

#
# An abstract base class for creating a toplevel window for displaying
# continuously updated statistics on a source.  The three columns of the
# table are "EWA", "Delta", and "Total", while the rows and data-values
# are user-defined.
# <p>
# Derived subclasses must implement the following methods: <br>
#    <dd> <i>create-plot-window name</i>
#    <dd> <i>delete-plot-window w</i>
#
Class StatWindow -superclass {QuitWindow Timer} -configuration {
	statsFilter 0.0625
}

#
# A toplevel window for displaying a table of continuously updated RTP
# statistics for a given source.  The three columns of the table are
# "EWA", "Delta", and "Total", while the rows and data-values are
# user-defined.
#
Class RtpStatWindow -superclass StatWindow

#
# Not yet implemented.
#
Class GlobalStatWindow -superclass StatWindow

#
# A toplevel window for displaying the output of mtrace to/from a source.
#
Class MtraceWindow -superclass TopLevelWindow

#
# Add the <i>path</i> and <i>quitMethod</i> of this toplevel window to the data structure.
#
QuitWindow public init { path quitMethod } {
	$self next $path
	$self instvar quitMethod_
	set quitMethod_ $quitMethod
}

#
# Evaluates the quitMethod of this toplevel window.
#
QuitWindow instproc quit {} {
	$self instvar quitMethod_
	eval $quitMethod_
}

#
proc get-playout src {
	set d [$src handler]
	if { "$d" != "" } {
		#FIXME assume 8Khz */
		return [expr [$d playout] >> 3]
	}
	return 0
}

#
# Creates a row within widget, <i>r</i>.  On the left side of the row,
# place a button named <i>name</i>, of the supplied <i>width</i>, that
# executes <i>cmd</i> when selected.  To the right of the button,
# include three labels using the supplied <i>relief</i>.
#
StatWindow instproc create-row { r name width cmd relief } {
	set f [$self get_option smallfont]
	button $r.name -text $name -font $f -anchor w -width $width \
		-command $cmd -pady 2 -padx 2 -borderwidth 2 \
		-highlightthickness 0 -relief raised
	label $r.smooth -font $f -anchor e -width 8 \
		-relief $relief -borderwidth 1 -pady 1
	label $r.diff -font $f -anchor e -width 8 \
		-relief $relief -borderwidth 1 -pady 1
	label $r.total -font $f -anchor e -width 8 \
		-relief ridge -borderwidth 1 -pady 1

	pack $r.name -anchor w -fill x -side left -pady 1 -padx 4
	pack $r.smooth $r.diff $r.total \
		-expand 1 -fill both -anchor e -side left
}

#
# Inside a frame within widget, <i>w</i>, create three columns: "EWA",
# "Delta", and "Total", and a row for every type of stat in the
# <i>stats</i> list.
#
StatWindow instproc create-panel { w stats } {
	set f [$self get_option smallfont]
	set p $w.f
	frame $p
	set top [winfo toplevel $w]
	set gain [$self get_option statsFilter]

	set r $p.legend
	frame $r
	label $r.smooth -font $f -anchor c -width 8 -text EWA \
		-relief ridge -borderwidth 1
	label $r.diff -font $f -anchor c -width 8 -text Delta \
		-relief ridge -borderwidth 1
	label $r.total -font $f -anchor c -width 8 -text Total \
		-relief ridge -borderwidth 1
	pack $r.total $r.diff $r.smooth -side right
	pack $r -anchor e

	#
	# save list of stats because they might change and we want to
	# remember the rate variables that we have created
	#
	$self instvar statCache_
	set statCache_ $stats

	set n [llength $stats]

	$self instvar width_
	set width_ 10
	set i 0
	while { $i < $n } {
		set v [string len [lindex $stats $i]]
		if { $v > $width_ } {
			set width_ $v
		}
		incr i 2
	}

	$self instvar rv_diff_ rv_smooth_
	set i 0
	while { $i < $n } {
		set name [lindex $stats $i]
		incr i
		set value [lindex $stats $i]
		incr i
		set id [string tolower $name]
		set r $p.$id
		frame $r

		set cmd "$self create-plot-window $name"
		$self create-row $r $name $width_ $cmd ridge
		pack $r -pady 0

		set rv_diff_($id) $value
		set rv_smooth_($id) $value

		rate_variable rv_diff_($id) 1.0 "%.1f"
		rate_variable rv_smooth_($id) $gain "%.1f"
	}
	$self instvar statWindow_
	set statWindow_ $p

	pack $w.f -anchor c
}

#
# Returns true if the key-value statList, <i>s1</i>, has changed with
# respect to statList, <i>s2</i>.
#
StatWindow instproc stats-changed { s1 s2 } {
	set n [llength $s1]
	if { $n != [llength $s2] } {
		return 1
	}
	set i 0
	while { $i < $n } {
		if { [lindex $s1 $i] != [lindex $s2 $i] } {
			return 1
		}
		incr i 2
	}
	return 0
}

#
# Re-evaluate the statList using the <i>method</i> supplied to the
# StatWindow's init method, and update the data displayed in the
# StatWindow if necessary.
#
StatWindow instproc stat-update {} {
	$self instvar rv_diff_ rv_smooth_ statCache_

	$self instvar method_ statWindow_
	set stats [eval $method_]
	if [$self stats-changed $stats $statCache_] {
		$self unset_rvs
		pack forget $w.frame
		destroy $w.frame
		frame $w.frame -borderwidth 2 -relief groove
		$self create-panel $w.frame $stats
		pack $w.frame -after $w.title -expand 1 -fill x -anchor center
	}

	set p $statWindow_
	set i 0
	set n [llength $stats]
	while { $i < $n } {
		set id [string tolower [lindex $stats $i]]
		incr i
		set cntr [lindex $stats $i]
		incr i
		set rv_diff_($id) $cntr
		set rv_smooth_($id) $cntr
		$p.$id.total configure -text $cntr
		$p.$id.diff configure -text $rv_diff_($id)
		$p.$id.smooth configure -text $rv_smooth_($id)
	}
	$self instvar src_
	if [winfo exists $p.playout.total] {
		$p.playout.total configure -text [get-playout $src_]ms
	}
}

#
# Unset all the rate variables associated with a window,
# so that the C storage is freed up
#
StatWindow instproc unset_rvs {} {
	$self instvar statCache_ rv_diff_ rv_smooth_
	if [info exists statCache_] {
		set n [llength $statCache_]
		for { set i 0 } { $i < $n } { incr i 2 } {
			set id [string tolower [lindex $statCache_ $i]]
			unset rv_diff_($id) rv_smooth_($id)
		}
		unset statCache_
	}
}

#
proc stat_destroy src {
	destroy $src
	global stat_method win_src
	if [info exists stat_method($src)] {
		unset stat_method($src)
	}
	if [info exists win_src($src)] {
		unset win_src($src)
	}
}

#
# Not used... <br>
# Destroy widget at path <i>w</i>.
#
InfoWindow instproc info_destroy { w src } {
#FIXME
	global info_x info_y
	set info_x($src) [winfo rootx $w]
	set info_y($src) [winfo rooty $w]
	destroy $w
}

#
# Not used... <br>
# Destroy widget at path <i>w</i>.
#
ScubaInfoWindow instproc info_destroy { w src } {
	global info_x info_y
	set info_x($src) [winfo rootx $w]
	set info_y($src) [winfo rooty $w]
	destroy $w
}

#
# Keep restarting a timer that causes a stat_update on expiration.
#
StatWindow private timeout {} {
	$self stat-update
	$self sched 1000
}

#
# Create a window with widgetpath, <i>w</i>, titled <i>windowName</i>.
# The <i>titleText</i> will be displayed as a label across the top of
# the window.  The supplied <i>method</i> should return a list of stats,
# which will serve as rows for a three-column ("EWA", "Delta", and
# "Total") table.  The command used to quit the window should be
# supplied as <i>quitCmd</i>.
#
StatWindow public init { w windowName titleText method quitCmd } {
	$self next $w $quitCmd
	$self create-window $w $windowName

	set f [$self get_option smallfont]
	frame $w.title -borderwidth 2 -relief groove
	label $w.title.main -borderwidth 0 -anchor w -text $titleText
	label $w.title.name -borderwidth 0 -anchor w
	frame $w.frame -borderwidth 2 -relief groove

	$self instvar method_
	set method_ $method
	$self create-panel $w.frame [eval $method]

	pack $w.title.name -anchor w
	pack $w.title.main -anchor w
	pack $w.title -fill x
	pack $w.frame -expand 1 -fill x -anchor center

	wm geometry $w +[winfo pointerx .]+[winfo pointery .]
	wm deiconify $w
	# start up the timer
	$self sched 1000

	button $w.dismiss -relief raised -font $f \
		-command "$self quit" -text Dismiss
	pack $w.dismiss -anchor c -pady 4

        wm protocol $w WM_DELETE_WINDOW "$self quit"
}

#
# Delete all the plot windows.
#
StatWindow instproc destroy {} {
	#
	#FIXME should change this so plot windows can remain
	# mapped even if we destroy stat windows.
	# this would require bookeeping the plot-windows in
	# the active source so we could delete them when
	# the source is deleted.
	#
	$self instvar plot_win_
	foreach w [array names plot_win_] {
		$self delete-plot-window $w
	}
	$self next
}

#
# Create a StatWindow with widgetpath, <i>w</i>, titled using some
# representation of <i>src</i>.  The <i>titleText</i> will be displayed
# as a label across the top of the window.  The supplied <i>method</i>
# should return a list of stats, which will serve as rows for a
# three-column ("EWA", "Delta", and "Total") table.  A final row along
# the bottom will represent "Playout".  The command used to quit the
# window should be supplied as <i>quitCmd</i>.
#
RtpStatWindow public init { w src titleText method quitCmd } {
	$self next $w [$src getid] $titleText $method $quitCmd
	$w.title.name configure -textvariable src_nickname($src)
	$self instvar src_
	set src_ $src

	#
	# Special-case playout estimator since it's not a counter
	#
	$self instvar statWindow_ width_
	set r $statWindow_.playout
	frame $r
	# FIXME don't create-plot-window unless you add Playout value to statList.
	# currently "stat-get Playout" returns -1
	# set cmd "$self create-plot-window Playout"
	set cmd ""
	$self create-row $r Playout $width_ $cmd flat
	pack $r -pady 0
}

#
# Return the value of the stat in the statList that corresponds to the key <i>id</i>.
# Return -1 if not found.
#
RtpStatWindow instproc stat-get id {
	$self instvar method_
	set stats [eval $method_]
	set k [lsearch -exact $stats $id]
	return [lindex $stats [expr $k + 1]]
}

#
# Displays another toplevel window for the src being represented in this
# RtpStatWindow, plotting the data in the statList with the key
# <i>name</i>.
#
RtpStatWindow instproc create-plot-window name {
	$self instvar plot_win_ src_
	set id [string tolower $name]
	set w .plot$src_$id
	if [info exists plot_win_($w)] {
		$self delete-plot-window $w
	} else {
		set plot_win_($w) [new PlotWindow $w $src_ $name \
					"$self stat-get $name" \
					"$self delete-plot-window $w"]
	}
}

#
# Delete the PlotWindow for the src being represented in this
# RtpStatWindow.
#
RtpStatWindow instproc delete-plot-window w {
	$self instvar plot_win_
	delete $plot_win_($w)
	unset plot_win_($w)
}

#
# Not yet implemented.
#
Class GlobalWindow -superclass StatWindow

#
GlobalWindow public init { w titleText method quitCmd } {
	$self next $w "RTP Stats" $titleText $method $quitCmd
}

#
proc has_src w {
	global win_src
	if [string compare $win_src($w) GLOBAL] {
		return 1
	} else {
		return 0
	}
}

#
# A toplevel window that plots data along a timescale as it is generated.
#
Class PlotWindow -superclass {QuitWindow Timer}

#
# Keep restarting a timer that causes the <i>generator</i> to re-evaluate the data plotted in this window.
#
PlotWindow private timeout {} {
	$self instvar rv_plot_ generator_ path_
	set rv_plot_ [eval $generator_]
	$path_.frame.sc set $rv_plot_
	$self sched 1000
}

#
proc relabel_stripchart {w min max perDiv} {
	$w configure -text " range $min to $max,  $perDiv/div"
}

#
# Creates a toplevel window at widgetpath <i>w</i> for plotting the data
# called <i>name</i> for the source, <i>src</i>, generated by the
# <i>generator</i> command.  The command used to quit the window should
# be supplied as <i>quitCmd</i>.
#
PlotWindow public init { w src name generator quitCmd } {
	$self next $w $quitCmd
	$self create-window $w "plot window"
	catch "wm resizable $w true false"
	$self instvar generator_
	set generator_ $generator

	set f [$self get_option smallfont]
	frame $w.title -borderwidth 2 -relief groove
	label $w.title.main -borderwidth 0 -anchor w -text $name
	frame $w.frame -borderwidth 2 -relief groove

	stripchart $w.frame.sc -max 200 -min 1 -stripwidth 1 -width 1 \
		-autoscale 2 -rescale_command "relabel_stripchart $w.bf.lab" \
		-relief groove -striprelief flat -tickcolor gray95 -hticks 30
	pack $w.frame.sc -expand 1 -fill both

	# force more reasonable initial size
	frame $w.brace -width 250
	pack $w.brace

	if [string match Source/* [$src info class]] {
		label $w.title.name -borderwidth 0 -anchor w \
			-textvariable src_nickname($src)
		pack $w.title.name -anchor w
	}
	pack $w.title.main -anchor w
	pack $w.title -fill x
	pack $w.frame -expand 1 -fill both -anchor center

	#
	# create a new rate-variable.  would be nice to just use
	# rv_diff but the stat window that this plot comes from can
	# be deleted while leaving this one in place.
	# FIXME hack: don't use a rate-variable for the playout estimator
	# since we want actual value not differences
	$self instvar rv_plot_
	if { "$name" != "Playout" } {
		rate_variable rv_plot_ 1.0 "%.1f"
	}

	wm geometry $w +[winfo pointerx .]+[winfo pointery .]
	wm deiconify $w
	# start up the timer
	$self sched 1000

	frame $w.bf
	label $w.bf.lab -borderwidth 0 -font $f -anchor w -text "No data"
	pack $w.bf.lab -side left -expand 1 -fill x
	button $w.bf.dismiss -relief raised -font $f -anchor e \
		-command "$self quit" -text Dismiss
	pack $w.bf.dismiss -side right -pady 4 -padx 4
	pack $w.bf -expand 1 -fill x

        wm protocol $w WM_DELETE_WINDOW "$self quit"
}

#
# what we want printed in the info window for our format etc.
# (i.e., info window code is app independent but this info isn't,
#  so we have this hackish callback)
#
proc info_text src {
	set d [$src handler]
	set fmt [$src format_name]

	if {[[$src set sm_] info class] == "VideoAgent"} {
		if { "$d" != "" } {
			set fmt "$fmt [$d cmd info] ([$d width]x[$d height])"
		}
	} elseif {[[$src set sm_] info class] == "AudioAgent"} {
		if { "$d" != "" } {
			set n [expr [$d block-size] / 160]
			if { $n > 1 } {
				set fmt $fmt/$n
			}
		}
		if { $fmt == "" } {
			set fmt none
		}
	}

	return "format: $fmt"
}

#
# Create a top-level window using widgetpath, <i>w</i>, to display summary statistics
# of source, <i>src</i>.  The <i>parent</i> must implement the methods: <br>
#    <dd> delete-info-window
#    <dd> create-rtp-window
#    <dd> create-decoder-window
# <br>
# Info displayed includes: <br>
#   <dd> <i>src</i> nickname
#   <dd> <i>src</i> address
#   <dd> items in <i>sdesList</i> (a resource defined in the options database)
#   <dd> buttons for retrieving "Stats...": "RTP" & "Decoder"
# <br>
# "smallfont" must be in options database before invoking this method.
#
InfoWindow public init { w src parent } {
	$self instvar src_
	set src_ $src

	$self next $w "$parent delete-info-window"
	$self create-window $w [$src getid]
	set f [$self get_option smallfont]
	frame $w.title -borderwidth 2 -relief groove
	label $w.title.name -borderwidth 0 -font $f -anchor w \
		-textvariable src_nickname($src)
	label $w.title.info -borderwidth 0 -font $f -anchor w \
		-text [$src addr]
	label $w.title.timeData -borderwidth 0 -font $f -anchor w
	label $w.title.timeCtrl -borderwidth 0 -font $f -anchor w

	frame $w.frame -borderwidth 2 -relief groove

	pack $w.title.name $w.title.info -fill x

        foreach sdes [$self get_option sdesList] {
		label $w.title.$sdes -borderwidth 0 -font $f -anchor w
		pack $w.title.$sdes -fill x
	}
	label $w.title.srcid -borderwidth 0 -font $f -anchor w
	pack $w.title.srcid -fill x

	pack $w.title.timeData $w.title.timeCtrl -fill x

	pack $w.title -fill x

	set p $w.bot
	frame $p

	set m $p.mb.menu
	menubutton $p.mb -text Stats... -menu $m -relief raised -width 8 \
		-font $f
	menu $m
	$m add command -label RTP -command "$parent create-rtp-window" -font $f
	$m add command -label Decoder \
		-command "$parent create-decoder-window" -font $f

	button $p.dismiss -relief raised -font $f \
		-command "$self quit" -text Dismiss

	pack $p.mb -side left -padx 8
	pack $p.dismiss -side right -padx 8
	pack $p -anchor c -pady 4 -fill x

        wm protocol $w WM_DELETE_WINDOW "$self quit"

	$self info_update

	global info_x info_y
	if [info exists info_x($src) ] {
		set x $info_x($src)
		set y $info_y($src)
	} else {
		set x [winfo pointerx .]
		set y [winfo pointery .]
	}

	#
	# Need to do an update so that $w gets laid out allowing us to
	# look up its size.  This is tricky because of a possible race:
	# if the user releases the mouse, summary_window might get
	# destroyed during the update idletasks.  So we check
	# that the window still exists before proceeeding.
	#
	update idletasks
	if ![winfo exists $w] { return }

	#
	# Check if window goes off the bottom or right.  Don't need
	# to check top or left since upper-left corner is at mouse.
	#
	set right [expr [winfo screenwidth .] - [winfo reqwidth $w] - 5]
	if { $x > $right } {
		set x $right
	}
	set bot [expr [winfo screenheight .] - [winfo reqheight $w] - 5]
	if { $y > $bot } {
		set y $bot
	}
	wm geometry $w +$x+$y
	wm deiconify $w

	# start a timer that will invoke $self::timeout on expiration
	$self sched 3000
}

#
# Updates information regarding the <i>src</i> represented by this window including: <br>
#   <dd> the last data
#   <dd> the last control
#   <dd> items in <i>sdesList</i> (a resource defined in the options database)
#   <dd> the id/address
#   <dd> the sdes note
#
InfoWindow instproc info_update {} {
	$self instvar path_ src_
	set w $path_
	set src $src_
	set decoder [$src handler]
	set fmt [$src format_name]
	if { $fmt == "" } { set fmt "?" }
	$w.title.info configure -text [info_text $src]
	set t [$src lastdata]
	if { $t == "" } { set t "never" }
	$w.title.timeData configure -text "last data $t"
	set t [$src lastctrl]
	if { $t == "" } { set t "never" }
	$w.title.timeCtrl configure -text "last control $t"

	foreach sdes [$self get_option sdesList] {
		$w.title.$sdes configure -text "$sdes: [$src sdes $sdes]"
	}
	$w.title.srcid configure -text "srcid: [$src srcid]/[$src addr]"
	if { [$src srcid] != [$src ssrc] } {
		if ![winfo exists $w.title.mixer] {
			label $w.title.mixer -borderwidth 0 \
				-font [$self get_option smallfont] -anchor w
			pack $w.title.mixer -after $w.title.srcid -fill x
		}
		$w.title.mixer configure -text "mixer: [$src ssrc]/[$src addr]"
	} elseif [winfo exists $w.title.mixer] {
		pack forget $w.title.mixer
		destroy $w.title.mixer
	}
	set note [$src sdes note]
	if { $note != "" } {
		set bg [$self get_option infoHighlightColor]
	} else {
		set bg [$self get_option background]
	}
	$w.title.note configure -background $bg
}

#
# Keep restarting a timer that causes an info_update on expiration.
#
InfoWindow private timeout {} {
	$self info_update
	$self sched 3000
}

#
# Keep restarting a timer that causes an info_update on expiration.
#
ScubaInfoWindow private timeout {} {
	$self info_update
	$self sched 1000
}

#
# Create a top-level window using widgetpath, <i>w</i>, to display summary statistics
# of source, <i>src</i>.  The <i>parent</i> must implement the method: <br>
#    <dd> delete-scuba-window
# <br>
# Info displayed includes: <br>
#   <dd> <i>src</i> nickname
#   <dd> individual SCUBA Votes
#   <dd> Aggregate SCUBA Vote
# <br>
# "smallfont" must be in options database before invoking this method.
#
ScubaInfoWindow public init { w src parent scuba_sess } {
	$self instvar src_ parent_ scuba_sess_
	set src_ $src
	set scuba_sess_ $scuba_sess

	$self next $w "$parent delete-scuba-window"
	$self create-window $w [$src getid]
	set f [$self get_option smallfont]
	frame $w.title -borderwidth 2 -relief groove
	label $w.title.name -borderwidth 0 -anchor w \
		-textvariable src_nickname($src)
	label $w.title.info -borderwidth 0 -anchor w -text "SCUBA Votes"

	frame $w.frame -borderwidth 2 -relief groove

	pack $w.title.name $w.title.info -fill x

	pack $w.title -fill x

	frame $w.frame.total -relief ridge -borderwidth 1
	label $w.frame.total.t -text "Aggregate Vote:" -font $f
	label $w.frame.total.val -text 0 -font $f
	pack $w.frame.total.t $w.frame.total.val -side left -anchor w
	pack $w.frame.total -fill x -expand 1 -side bottom
	pack $w.frame -fill both -expand 1 -side top

	set p $w.bot
	frame $p
	button $p.dismiss -relief raised -font $f \
		-command "$self quit" -text Dismiss

	pack $p.dismiss
	pack $p -anchor c -pady 4 -fill x

        wm protocol $w WM_DELETE_WINDOW "$self quit"

	global scubainfo_x scubainfo_y
	if [info exists scubainfo_x($src) ] {
		set x $scubainfo_x($src)
		set y $scubainfo_y($src)
	} else {
		set x [winfo pointerx .]
		set y [winfo pointery .]
	}

	#
	# Need to do an update so that $w gets laid out allowing us to
	# look up its size.  This is tricky because of a possible race:
	# if the user releases the mouse, summary_window might get
	# destroyed during the update idletasks.  So we check
	# that the window still exists before proceeeding.
	#
	update idletasks
	if ![winfo exists $w] { return }

	#
	# Check if window goes off the bottom or right.  Don't need
	# to check top or left since upper-left corner is at mouse.
	#
	set right [expr [winfo screenwidth .] - [winfo reqwidth $w] - 5]
	if { $x > $right } {
		set x $right
	}
	set bot [expr [winfo screenheight .] - [winfo reqheight $w] - 5]
	if { $y > $bot } {
		set y $bot
	}
	wm geometry $w +$x+$y
	wm deiconify $w
}

#
# Updates information regarding the <i>src</i> represented by this window including: <br>
#   <dd> individual SCUBA Votes
#   <dd> Aggregate SCUBA Vote
#
ScubaInfoWindow instproc info_update {} {
	$self instvar path_ src_ scuba_sess_
	set w $path_.frame

	set sm [$scuba_sess_ source-manager]
	if { [$sm info vars local_] == "" } {
		return
	}
	set localsrc [$sm set local_]

	set total 0
	set al [$sm active_list]
	foreach src $al {
		set srcid [$src srcid]
		set voters [$scuba_sess_ array names scoretab_ *:$srcid]
		set subtotal 0
		foreach v $voters {
			set subtotal \
			    [expr $subtotal+[$scuba_sess_ set scoretab_($v)]]
		}
		set tot($src) $subtotal
		set total [expr $total+$subtotal]
	}
	if { $total > 0 } {
		set avg [expr $tot($src_)/$total]
	} else {
		set avg 0
	}
	set srcid [$src_ srcid]
	set voters [$scuba_sess_ array names scoretab_ *:$srcid]
	set sm [$scuba_sess_ source-manager]
	foreach s [$sm set sources_] {
		if { $s == $src_ } {
			continue
		}
		$w.s$s.v configure -text "= 0.0"
	}
	foreach v $voters {
		set sender [lindex [split $v :] 0]
		$w.s$sender.v configure \
				-text "= [$scuba_sess_ set scoretab_($v)]"
	}
	$w.total.val configure -text $avg
}

#
# Add the vote from the new <i>src</i> to the ScubaInfoWindow.
#
ScubaInfoWindow instproc register { src } {
	$self instvar path_ scuba_sess_ src_
	if { $src == $src_ } {
		return
	}
	set f [$self get_option smallfont]
	set w $path_.frame
	global src_nickname
	frame $w.s$src

	set sm [$scuba_sess_ source-manager]
	if { [$sm set local_] == $src } {
		label $w.s$src.t -text "Local Receiver" -font $f
	} else {
		label $w.s$src.t -textvariable src_nickname($src) -font $f
	}
	label $w.s$src.v -text  "= 0.0" -font $f
	pack $w.s$src.t -side left  -anchor w
	pack $w.s$src.v -side right -anchor e
	pack $w.s$src -fill both -expand 1
}

#
# Remove the vote of the unregistered <i>src</i> from the ScubaInfoWindow.
#
ScubaInfoWindow instproc unregister { src } {
	$self instvar path_ src_
	if { $src == $src_ } {
		return
	}
	set w $path_.frame
	destroy $w.s$src
}

#
# If the <i>src</i> being deactivated is the subject of this ScubaInfoWindow, delete the window.
#
ScubaInfoWindow instproc deactivate { src } {
	$self instvar src_ path_
	if { $src == $src_ } {
		destroy $path_
	}
}

#
# Instantiate, but do not yet display or iconify, a dismissable, x/y
# scrollable toplevel using the provided widgetpath, <i>w</i>.  Also
# label this window and its icon to identify the source, <i>src</i>. Use
# the <i>dir</i> parameter to specify the direction of the trace
# (e.g. "to" or "from".)<br> The options database must define smallfont
# before this method is invoked.
#
MtraceWindow public init {w src dir} {
        $self instvar w_ src_ dir_
	set w_ $w
	set src_ $src
	set dir_ $dir
	if ![winfo exists $w] {
#                $self next $w "$parent delete-info-window"
                $self create-window $w [$src getid]
		set f [$self get_option smallfont]
		frame $w.t
		scrollbar $w.t.yscroll -command "$w.t.text yview" -relief sunken
		scrollbar $w.t.xscroll -command "$w.t.text xview" -relief sunken \
			-orient horiz
		text $w.t.text -height 24 -width 80 -setgrid true -wrap none \
			-font fixed -relief sunken -borderwidth 2 \
			-xscrollcommand "$w.t.xscroll set" \
			-yscrollcommand "$w.t.yscroll set"
		pack $w.t.yscroll -side right -fill y
		pack $w.t.xscroll -side bottom -fill x
		pack $w.t.text -side left -padx 0 -pady 0 -fill both -expand yes
		set p $w.b
		frame $p
		button $p.dismiss -relief raised -font $f \
			-command "destroy $w" -text Dismiss
		pack $p.dismiss -side right -padx 8
		pack $w.t -side top -fill both -expand yes
		pack $p -side bottom -pady 2 -fill x
		wm geometry $w +[winfo pointerx .]+[winfo pointery .]
		wm deiconify $w
                wm protocol $w WM_DELETE_WINDOW "destroy $w"
		update idletasks
		if ![winfo exists $w] { return }
	}
}

#
# Execute the mtrace and output the results within this window.
#
MtraceWindow instproc do_mtrace {} {
        $self instvar w_ src_ dir_
	global V
	set rtpagent $V(sm)
	set net [$rtpagent network]
	if {$dir_=="to"} {
		set cmd "|mtrace [$net interface] [$net addr] [$src_ addr]"
	} else {
		set cmd "|mtrace [$src_ addr] [$net addr]"
	}
	if [catch "open {$cmd} r" fd] {
		$w_.t.text insert end "mtrace error: $fd"
		return
	}
	fconfigure $fd -blocking 0
	fileevent $fd readable "$self read_mtrace $fd"
}

#
# Read the output of the mtrace from a file into this window.
#
MtraceWindow instproc read_mtrace {fd} {
        $self instvar w_
	if [winfo exists $w_] {
		$w_.t.text insert end [read $fd 1]
		$w_.t.text yview end
		if [eof $fd] {
			fileevent $fd readable {}
			catch "close $fd"
		}
	} else {
		fileevent $fd readable {}
		catch "close $fd"
	}
}



#FIXME
proc destroy_rtp_stats src {
	if [winfo exists .rtp$src] {
		foreach statwin [StatWindow info instances] {
		    if [$src == [$statwin set src_]] {
			$statwin unset_rvs
		    }
		}
		stat_destroy $src
	}
# Not yet
#	if [winfo exists .info$src] {
#		info_destroy .info$src $src
#	}
#	global rv_plot win_src
#	foreach w [array names rv_plot] {
#		if { "$win_src($w)" == "$src" } {
#			plot_destroy $w
#		}
#	}
}
