# almclient-transcoder.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import AnnounceListenManager/AS/Client

Class AnnounceListenManager/AS/Client/Transcoder/Video -superclass \
	AnnounceListenManager/AS/Client



AnnounceListenManager/AS/Client/Transcoder/Video instproc \
	init {agent megactrl {srv_loc {}} {bw 500} } {
    $self instvar m_agent
    $self instvar service_instance_

    if { $srv_loc == {} } {
	set srv_loc "static:transcoder"
    }

    $self next $megactrl $bw $srv_loc

    set service_instance_ "[pid]:[localaddr]:transcoder"
    set m_agent $agent
}


AnnounceListenManager/AS/Client/Transcoder/Video instproc service_name {} {
    #puts "service_name"
    return Transcoder/Video
}

AnnounceListenManager/AS/Client/Transcoder/Video instproc service_instance {} {
    $self instvar service_instance_
    return $service_instance_
}

AnnounceListenManager/AS/Client/Transcoder/Video instproc agent_data {} {
    #puts "agent_data"
    $self instvar ssd_

    set aTranscoderInfo(InputSession) "224.24.24.24/24242"
    set aTranscoderInfo(OutputSession) "225.25.25.25/25252"

    set aTranscoderInfo(SourceList) ""
    set aTranscoderInfo(Default) "128000 H261"

    set msg [list [array get aTranscoderInfo]]

    #	append msg "Seqno $ssd_(seqno)\n"
    #	append msg "Filename $ssd_(filename)\n"
    #	append msg "Offset $ssd_(offset)\n"
    #	append msg "ClientAddr $ssd_(localaddr)\n"
    #	append msg "UnicastPort $ssd_(unicast_port)\n"

    return $msg
}



AnnounceListenManager/AS/Client/Transcoder/Video instproc register { atype aspec addr \
	srv_name srv_inst msg } {
}


AnnounceListenManager/AS/Client/Transcoder/Video instproc unregister { atype aspec addr \
	srv_name srv_inst msg } {
}


AnnounceListenManager/AS/Client/Transcoder/Video instproc recv_msg { atype aspec addr srv_name srv_loc srv_inst ssg_port msg } {
    puts "alm/client/transcoder:recv_msg-$msg"

    $self instvar m_agent
    $self instvar service_instance_

    if {$srv_inst != $service_instance_} {
	return
    }

    if {[string length $msg] > 0} {
	$m_agent ReceiveMessage $msg
    }

}
