# almserver-trancoder.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import AnnounceListenManager/AS/Service

Class AnnounceListenManager/AS/Service/Transcoder -superclass AnnounceListenManager/AS/Service

Class AnnounceListenManager/AS/Service/Transcoder/Video -superclass AnnounceListenManager/AS/Service/Transcoder


#
AnnounceListenManager/AS/Service/Transcoder/Video public init \
	{ agent specAS iBW specService } {
    $self next $agent $specAS $iBW $specService

    $self instvar m_iLastSeqNum
    $self instvar m_specService
    $self instvar m_agent

    # Initialize data
    set m_iLastSeqNum 0
    set m_specService $specService
    set m_agent $agent
}

# callback for AS
AnnounceListenManager/AS/Service/Transcoder/Video public service_name {} {
    return Transcoder/Video
}


# Recv a message, check if it's for us, and check if the seqno has incremented
# If not, then it's a keep alive message, and we can ignore it.  If so, then
# pass the message in to the archive agent
AnnounceListenManager/AS/Service/Transcoder/Video public recv_msg \
	{ atype aspec addr srv_name srv_loc srv_inst ssg_port msg } {
    $self instvar m_iLastSeqNum
    $self instvar m_specService
    $self instvar m_agent

    if { $srv_name == "DEATH" } {
	puts stderr "Received death packet from $aspec at $addr - exiting."
	$self announce_death
	exit 0
    }

    $self next $atype $aspec $addr $srv_name $srv_loc $srv_inst $ssg_port $msg

    if {$m_specService != $srv_inst} {
	return
    }

    # give the agent the message
    $m_agent ReceiveMessage $msg
}

# SSACServer sets the agent-data for the return messages
AnnounceListenManager/AS/Service/Transcoder/Video public agent_data {} {
    return "nothing much!"
}

