# fca-localrcvr.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


################## local receiver ####################
Class FCARcvr/Tcl/Local -superclass FCARcvr/Tcl
FCARcvr/Tcl/Local instproc init { mgr srcId } {
    # outstandingPkts_ requests_ pendingCancelIds_ pendingRls_
    # haveImportant_
    $self next $mgr $srcId
    $self set outstandingPkts_ {}
    #$self set haveImportant_ 0
}


# whether there are more ADUs to send
FCARcvr/Tcl/Local instproc more_ADU {} {
    $self instvar outstandingPkts_
    return [llength $outstandingPkts_]
}


#--- SRM callbacks ---#
#FCARcvr/Tcl/Local instproc handle_request { fcaPkt } {
#    DbgOut "FCARcvr/Tcl/Local::handle_request, repair request feed back to \
#	    local rcvr."
#    return
#}


# return FCA_Packet to be sent by periodic_update
FCARcvr/Tcl/Local instproc create_sa { fcaPkt } {
    $self instvar requests_ important_ mgr_ srcId_
    $fcaPkt set pktType "PKT_PARTICIPANT_SA"
    $fcaPkt set maxRequestId [$requests_ maxRequestId]
    $fcaPkt set maxImportantSeqno [$important_ maxSeqno]
}


# return FCA_Packet filled by next_ADU
FCARcvr/Tcl/Local instproc next_ADU {} {
    $self instvar outstandingPkts_
    if { [llength $outstandingPkts_] == 0 } {
	DbgOut "no outstanding packets"
	return ""
    }
    DbgOut "Outstanding pkt list: *$outstandingPkts_*"
    set pkt [lindex $outstandingPkts_ 0]
    set outstandingPkts_ [lreplace $outstandingPkts_ 0 0]
    return $pkt
}


# SRM callbacks
FCARcvr/Tcl/Local instproc handle_SA {fcaPkt} {
#    DbgOut "FCARcvr/Tcl/Local::handle_SA, SA feedback to local rcvr"
    return
}


#FCARcvr/Tcl/Local instproc handle_reply {fcaPkt} {
#    DbgOut "FCARcvr/Tcl/Local::handle_reply, reply feedback to local rcvr"
#    return
#}



#--- send messages ---#\
# called from UI
# floorRequest is of class FCAFloorRequest
# floorRequest only have floorTypes and comment set
FCARcvr/Tcl/Local instproc sendFloorRequest { ftypes comment } {
    $self instvar mgr_ outstandingPkts_ srcId_ requests_

    set requestId [expr [$requests_ maxRequestId] + 1]
    set floorRequest [new FCAFloorRequest $srcId_ $requestId \
	    $ftypes $comment]
    $requests_ got_request $requestId $floorRequest
    DbgOut "Added request *$floorRequest* for $srcId_:$requestId"

    set fcd [$mgr_ fcDynamics]
    $fcd new_pending_request $floorRequest
    ## UI
    #[$mgr_ set uiMgr_] add_pending $floorRequest

    set fcaPkt [new FCA_Packet]
    $fcaPkt set pktType "PKT_FLOOR_REQUEST"
    $fcaPkt set requestId $requestId
    $fcaPkt set comment $comment
    $fcaPkt set floors $ftypes
    $fcaPkt set numFloors [llength $ftypes]

    lappend outstandingPkts_ $fcaPkt
    $mgr_ request_send $fcaPkt
}



#Called from UI, request is of Class FCAFloorRequest
FCARcvr/Tcl/Local instproc sendFloorCancel { request } {
    $self instvar mgr_ outstandingPkts_ requests_ important_
    set requestId [$request requestId]
    set fcDynamics [$mgr_ fcDynamics]

    set fcaPkt [new FCA_Packet]
    $fcaPkt set pktType "PKT_FLOOR_CANCEL"

    DbgOut "Trying to remove [$request srcId]:$requestId from the admit q"
    if { [$fcDynamics remove_admitted_request [$request srcId] $requestId] } {
	# this is an admitted request; we must set a seqno for this cancel
	$fcaPkt set seqno [$important_ add cancel $requestId]
    } else {
	# this is probably a pending request

	$fcDynamics delete_pending_request [$request srcId] $requestId
	$fcaPkt set seqno 0
    }

    $requests_ cancel $requestId
    $fcaPkt set requestId $requestId
    lappend outstandingPkts_ $fcaPkt
    $mgr_ request_send $fcaPkt
}


# called from UI
FCARcvr/Tcl/Local instproc sendFloorRelease { ftype instance } {
    $self instvar mgr_ nextFcaPkt_ pendingRls_ srcId_ \
	    outstandingPkts_
    #set $haveImportant_ 1
    set $fcd [$mgr fcDynamics]
    set grantSeq [$fcd getLastGrantSeq $ftype $instance]
    set releaseRq [new FloorGrant $ftype $instance $grantSeq $srcId_]

    # save
    set pendingRls_([$floorRelease set grantSeqNo_]) $floorRelease
    # update UI
    [$mgr_ set uiMgr_] release_received $ftype $instance

    set fcaPkt [new FCA_Packet]
    $fcaPkt set pktType "PKT_FLOOR_RELEASE"
    $fcaPkt set srcId  $srcId_
    $fcaPkt set grantSeqno $grantSeq
    $fcaPkt set floorType $ftype
    $fcaPkt set floorInstance $instance
    $fcaPkt set isGrant 0

    lappend outstandingPkts_ $fcaPkt
    $mgr_ request_send $fcaPkt
}


################# moderator local receiver ###############
# next_ADU is inherited from above
Class FCARcvr/Tcl/LocalModerator -superclass { FCARcvr/Tcl/Local FCARcvr/Tcl/Moderator }

FCARcvr/Tcl/LocalModerator instproc init { mgr srcId } {
    $self next $mgr $srcId
    $self instvar topGrantSeq_
    set topGrantSeq_ 1
}

#---- SRM Callbacks ----#

# return FCA_Packet to be sent by periodic_update
FCARcvr/Tcl/LocalModerator instproc create_sa { fcaPkt } {
    $self instvar mgr_
    $self next $fcaPkt
    $fcaPkt set pktType "PKT_MODERATOR_SA"
    set fcd [$mgr_ fcDynamics]
    $fcaPkt set currentState [$fcd moderator_state]
#    DbgOut "FCARcvr/Tcl/LocalModerator::create_sa, about to send mod SA "
}

#---- Send messages ----#
# sendFloorRequest sendFloorRelease sendFloorCancel inherited from Local



# requests is a list of {srcId requestId} pairs
FCARcvr/Tcl/LocalModerator instproc sendQueueUpdate { isAdd requests state } {
    DbgOut "Sending queue update for *$requests*"
    $self instvar mgr_ outstandingPkts_
    set fcaPkt [new FCA_Packet]
    $fcaPkt set pktType "PKT_QUEUE_UPDATE"
    $fcaPkt set moderatorState $state
    $fcaPkt set numUpdates [llength $requests]
    $fcaPkt set pktUpdates {}
    DbgOut "isAdd is $isAdd"
    foreach rq $requests {
	set pktUpdate [new FCA_Packet]
	$pktUpdate set srcId [lindex $rq 0]
	$pktUpdate set requestId [lindex $rq 1]
	$pktUpdate set isAdd $isAdd


	# don't bother updating the UI here!

	## update UI
	#if {$isAdd} {
	#    [$mgr_ set uiMgr_] add_admit $rq
	#} else {
	#    [$mgr_ set uiMgr_] remove_admit $rq
	#}


	$fcaPkt lappend pktUpdates $pktUpdate
    }

    lappend outstandingPkts_ $fcaPkt
    $mgr_ request_send $fcaPkt
}


#FCARcvr/Tcl/LocalModerator instproc sendCancelUpdate {srcId requestId state} {
#    $self instvar mgr_ outstandingPkts_
#    set fcaPkt [new FCA_Packet]
#    $fcaPkt set pktType "PKT_CANCEL_UPDATE"
#    $fcaPkt set moderatorState $state
#    $fcaPkt set numUpdates 1
#
#    set pktUpdate [new FCA_Packet]
#    $pktUpdate set srcId $srcId
#    $pktUpdate set requestId $requestId
#    $fcaPkt set pktUpdates $pktUpdate
#
#    lappend outstandingPkts_ $fcaPkt
#    $mgr_ request_send $fcaPkt
#}





# called by UI floor grant to someone who is not in the admitted floor
# request list
FCARcvr/Tcl/LocalModerator instproc uiGrantParticipant { ftypes srcId } {
    $self instvar mgr_ topGrantSeq_
    # create request object
    set rq [new FCAFloorRequest $srcId 0 $ftypes ""]
    $self uiGrant $rq
}


# called by UI request is of type FCAFloorRequest
FCARcvr/Tcl/LocalModerator instproc uiGrant { request } {
    $self instvar mgr_ topGrantSeq_

    set fcd [$mgr_ fcDynamics]
    set grants {}
    set fcdChanged 0

    foreach ftype [$request set floorTypes_] {
	set instance [$fcd getFreeInstance $ftype]
	if { $instance == -1 } {
	    ## !! for now
	    set instance 0
	}
	lappend grants "$topGrantSeq_ $ftype $instance"
	if { [$fcd grant_floor $ftype $instance [$request srcId] \
		[$request requestId] $topGrantSeq_] } {
	    set fcdChanged 1
	}
	incr topGrantSeq_ 1
    }

    if { $fcdChanged } {
	set state [$fcd incr_moderator_state]
	set isGrant 1
	$self send_grant_update "PKT_GRANT_UPDATE" [$request srcId] \
		[$request requestId] 1 $grants $state
    } else {
	DbgOut "no floor is granted, something wrong"
    }
}


# grants is a list of {grantSeq floorType floorInstance} pairs
FCARcvr/Tcl/LocalModerator instproc send_grant_update { pktType srcId \
	requestId isGrant grants moderatorState } {
    $self instvar mgr_ outstandingPkts_ topGrantSeq_

    # packetize and send out
    set fcaPkt [new FCA_Packet]
    $fcaPkt set pktType $pktType
    $fcaPkt set moderatorState $moderatorState
    $fcaPkt set numUpdates [llength $grants]
    $fcaPkt set pktUpdates {}

    foreach grant $grants {
	set pktUpdate [new FCA_Packet]
	#$pktUpdate set isGrant $isGrant
	$pktUpdate set srcId $srcId
	$pktUpdate set grantSeqno [lindex $grant 0]

	$pktUpdate set requestId $requestId
	$pktUpdate set floorType [lindex $grant 1]
	$pktUpdate set floorInstance [lindex $grant 2]
	$fcaPkt lappend pktUpdates $pktUpdate
    }
    lappend outstandingPkts_ $fcaPkt
    $mgr_ request_send $fcaPkt
}



# request for the floor only if we don't already have a pending/admitted
# request for the same floor-type

FCARcvr/Tcl/Local instproc auto_request_floor { floorType } {
    set r [$self set requests_]
    $r instvar requests_
    foreach entry [array names requests_ *] {
	if { [$r have $entry] } {
	    # make sure this entry contains a valid request object
	    set ftypes [[$r get $entry] floorTypes]
	    if { [lsearch $ftypes $floorType] != -1 } {
		# we found a matching entry,why should we care to add a new one
		return
	    }
	}
    }

    # we should create a new request
    $self sendFloorRequest $floorType \
	    "$floorType floor requested by media agent"
}



# called when the admitted queue has available slots
# return list of new requests that have been admitted
#FCARcvr/Tcl/LocalModerator instproc admitRequests {} {
#    $self instvar mgr_
#    set returnlist {}
#    set fcd [$mgr_ fcDynamics]
#    while {![$fcd isRequestQFull]} {
#	set pRqst [$fcd nextPendingRequest]
#	if { $pRqst != "" } {
#	    set success [$fcd newFloorRequest $pRqst]
#	    if {$success} {
#		set returnlist [lappend $returnlist $pRqst]
#	    } else {
#		DbgOut "FCARcvr/Tcl/LocalModerator::admit, failed"
#	    }
#	} else {
#	    DbgOut "next pending request is blank"
#	}
#    }
#    return $returnlist
#}

# called when the floor instances have vacancies, return FloorGrant object
#FCARcvr/Tcl/LocalModerator instproc admitNewHolder {ftype instance} {
#    $self instvar mgr_ topGrantSeq_
#    set fcd [$mgr_ fcDynamics]
#    set rqst [$fcd getFloorRequest $ftype $instance]
#    if {$rqst == ""} {
#	DbgOut "no admitted floor requests in the queue"
#	return ""
#    }
#    set success [$fcd grantHolder $ftype $instance [$rqst set srcId_] $topGrantSeq_]
#    if { $success } {
#	$fcd deleteFloorRequest [$rqst set srcId_] [$rqst set requestId_]
#	set grantUpdate [new FloorGrant $ftype $instance $topGrantSeq_ [$rqst set srcId_] [$rqst set requestId_]]
#	incr topGrantSeq_ 1
#	return $grantUpdate
#    }
#    return ""
#}
