# al-mgamon.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/mgamon/al-mgamon.tcl,v 1.19 2002/02/03 04:27:48 lim Exp $

import AnnounceListenManager/AS SDPParser

Class AnnounceListenManager/AS/MeGaMon -superclass AnnounceListenManager/AS

AnnounceListenManager/AS/MeGaMon instproc init { agent spec bw } {
	$self next $spec $bw mgamon
	$self instvar sdp_ agent_
	set agent_ $agent
	set sdp_ [new SDPParser]
}

AnnounceListenManager/AS/MeGaMon instproc send_announcement {} {
	puts stderr "MeGa Monitor send_announcement called!"
	return ""
}

AnnounceListenManager/AS/MeGaMon instproc recv_msg { atype aspec addr srv_name srv_loc srv_inst ssg_port m } {
	$self instvar agent_ avgdelta_ sdp_
	if { $srv_name == "DEATH" } {
		return
	}

	if {$atype == "client" || $atype == "srv"} {
		if {$srv_name != "Mars"} {
			set m [$sdp_ parse $m]
			$agent_ recv_msg $atype $aspec $addr "$m" $avgdelta_($aspec)
			if { $m != "" } {
				delete $m
			}
		} else {
			$agent_ recv_msg $atype $aspec $addr $srv_name $avgdelta_($aspec)
		}
	}

}

AnnounceListenManager/AS/MeGaMon instproc register { atype aspec addr srv_name srv_inst msg } {
	$self instvar agent_ sdp_
	if {$srv_name != "Mars"} {
		set m [$sdp_ parse $msg]
		$agent_ register $atype $aspec $addr "$m"
		if { $m != "" } {
			delete $m
		}
	} else {
		$agent_ register $atype $aspec $addr $srv_name
	}
}

AnnounceListenManager/AS/MeGaMon instproc unregister { atype aspec addr srv_name srv_inst msg } {
	$self instvar agent_ sdp_
	if {$srv_name != "Mars"} {
		set msg [$sdp_ parse $msg]
		$agent_ unregister $atype $aspec $addr "$msg"
		if { $msg != "" } {
			delete $msg
		}
	} else {
		$agent_ unregister $atype $aspec $addr $srv_name
	}
}
