# edge-detect-sc.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import DaliSubprogram

Class EdgeDetectScSubprogram -superclass DaliSubprogram

EdgeDetectScSubprogram instproc init {args} {
    eval $self next $args;

    # Set up inputs

    $self instvar input_id_list_;
    $self instvar input_info_;

    lappend input_id_list_ i1

    set input_info_(i1,spec) "";
    set input_info_(i1,trigger) 0;
    set input_info_(i1,buffertype) Semicompressed;
    set input_info_(i1,buffername) [new VidRep/Semicompressed];
    set input_info_(i1,decoder) "";

    # Set up outputs

    $self instvar output_id_list_;
    $self instvar output_info_;

    lappend output_id_list_ o1;

    set output_info_(o1,spec) "";
    set output_info_(o1,buffertype) Semicompressed;
    set output_info_(o1,buffername) [new VidRep/Semicompressed];
    set output_info_(o1,encoder) "";
    set output_info_(o1,format) SC;
    set output_info_(o1,vagent) "";
    set output_info_(o1,geometry) [list 0.0 0.0 1.0 1.0];
    set output_info_(o1,geometry_change) 0;

    # Set up parameters

    $self instvar parameter_id_list_;
    $self instvar parameter_info_;

    set parameter_id_list_ "";
}

EdgeDetectScSubprogram instproc set_output_geometry {id geometry} {
    $self instvar output_info_;

    set output_info_($id,geometry) $geometry;
    set output_info_($id,geometry_change) 1;
}

EdgeDetectScSubprogram instproc trigger {} {
    $self instvar input_info_;
    $self instvar output_info_;
    $self instvar init_done_;
    $self instvar smooth_;
    $self instvar uncomp_input_;
    $self instvar uncomp_output_;
    $self instvar inframe_lum_clip_;

    set in_frame $input_info_(i1,buffername);
    set out_frame $output_info_(o1,buffername);

    if {![info exists init_done_]} {
	if {[$in_frame set w_] == 0} {
	    return;
	}

	set init_done_ 1;

	set x0 [lindex $output_info_(o1,geometry) 0];
	set y0 [lindex $output_info_(o1,geometry) 1];
	set x1 [lindex $output_info_(o1,geometry) 2];
	set y1 [lindex $output_info_(o1,geometry) 3];

	set xp0 [expr ((int([$in_frame set true_w_] * $x0) + 8) / 16) * 16];
	set xp1 [expr ((int([$in_frame set true_w_] * $x1) + 8) / 16) * 16];
	set yp0 [expr ((int([$in_frame set true_h_] * $y0) + 4) / 8) * 8];
	set yp1 [expr ((int([$in_frame set true_h_] * $y1) + 4) / 8) * 8];

	set sub_w [expr $xp1 - $xp0];
	set sub_h [expr $yp1 - $yp0];

	set in_l [$in_frame get_lum_name];

	set inframe_lum_clip_ [sc_clip $in_l [expr $xp0/8] [expr $yp0/8] [expr $sub_w/8] [expr $sub_h/8]];

	$out_frame set true_w_ [$in_frame set true_w_];
	$out_frame set true_h_ [$in_frame set true_h_];
	$out_frame set xoff_ $xp0;
	$out_frame set yoff_ $yp0;
	$out_frame set w_ $sub_w
	$out_frame set h_ $sub_h
	$out_frame set h_subsample_ 2;
	$out_frame set v_subsample_ 1;
	$out_frame allocate;

	set out_cr [$out_frame get_cr_name];
	set out_cb [$out_frame get_cb_name];

	set smooth_ [new VidRep/Uncompressed];
	$smooth_ copy_geometry $out_frame;
	$smooth_ allocate;

	set uncomp_input_ [new VidRep/Uncompressed];
	$uncomp_input_ copy_geometry $out_frame;
	$uncomp_input_ allocate

	set uncomp_output_ [new VidRep/Uncompressed];
	$uncomp_output_ copy_geometry $out_frame;
	$uncomp_output_ allocate
    }

    if {$output_info_(o1,geometry_change) ==  1} {
	set x0 [lindex $output_info_(o1,geometry) 0];
	set y0 [lindex $output_info_(o1,geometry) 1];
	set x1 [lindex $output_info_(o1,geometry) 2];
	set y1 [lindex $output_info_(o1,geometry) 3];

	set xp0 [expr ((int([$in_frame set true_w_] * $x0) + 8) / 16) * 16];
	set xp1 [expr ((int([$in_frame set true_w_] * $x1) + 8) / 16) * 16];
	set yp0 [expr ((int([$in_frame set true_h_] * $y0) + 4) / 8) * 8];
	set yp1 [expr ((int([$in_frame set true_h_] * $y1) + 4) / 8) * 8];

	set sub_w [expr $xp1 - $xp0];
	set sub_h [expr $yp1 - $yp0];

	set in_l [$in_frame get_lum_name];

	sc_free $inframe_lum_clip_;
	set inframe_lum_clip_ [sc_clip $in_l [expr $xp0/8] [expr $yp0/8] [expr $sub_w/8] [expr $sub_h/8]];

	$out_frame set true_w_ [$in_frame set true_w_];
	$out_frame set true_h_ [$in_frame set true_h_];
	$out_frame set xoff_ $xp0;
	$out_frame set yoff_ $yp0;
	$out_frame set w_ $sub_w
	$out_frame set h_ $sub_h
	$out_frame set h_subsample_ 2;
	$out_frame set v_subsample_ 1;
	$out_frame allocate;

	set out_cr [$out_frame get_cr_name];
	set out_cb [$out_frame get_cb_name];

	$smooth_ copy_geometry $out_frame;
	$smooth_ allocate;

	$uncomp_input_ copy_geometry $out_frame;
	$uncomp_input_ allocate

	$uncomp_output_ copy_geometry $out_frame;
	$uncomp_output_ allocate
    }


    set uncomp_in_l [$uncomp_input_ get_lum_name];
    set smooth_l [$smooth_ get_lum_name];
    set uncomp_out_l [$uncomp_output_ get_lum_name];
    set out_l [$out_frame get_lum_name];

    sc_to_byte_with_bias $inframe_lum_clip_ $uncomp_in_l 0;
    byte_smooth $uncomp_in_l $smooth_l 2;
    byte_edge_detect_canny $smooth_l $uncomp_out_l 5 10;
    byte_to_sc $uncomp_out_l $out_l 0;

    $out_frame set ts_ [$in_frame set ts_];

    set encoder $output_info_(o1,encoder);

    if {$encoder != ""} {
	$encoder recv $out_frame;
    }
    $self send_completion_token;
}
