# sc-spatial-combiner.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import GraphComm

Class ScSpatialCombiner

ScSpatialCombiner instproc init {id cntrl_spec} {
    $self next;

    $self instvar output_id_list_;
    $self instvar output_info_;

    $self instvar subgraph_list_;
    $self instvar subgraph_info_;

    $self instvar sid_;

    $self instvar id_;
    $self instvar comm_obj_;

    $self instvar callback_array_;

    set output_id_list_ "";

    set id_ $id;

    set cntrl_spec [split $cntrl_spec "/"];
    set addr [lindex $cntrl_spec 0];
    set port [lindex $cntrl_spec 1];
    set ttl [lindex $cntrl_spec 2];

    set comm_obj_ [new GraphComm/ScSpatialCombiner $self $id_ $addr $port $ttl];

    set sid_ -1;
    set subgraph_list_ "";

#### Testing only stuff below
    $self instvar test_mode_;

    set test_mode_ [$self get_option spatial_test_mode];
    puts "Test mode is: $test_mode_"
#####

#### Testing counters for frame drops and hits
    $self instvar hit_cntr_ miss_cntr_ cntr_reset_
    set hit_cntr_ 0
    set miss_cntr_ 0
    set cntr_reset_ 1
####

}

ScSpatialCombiner instproc add_subgraph {new_subgraph} {
    $self instvar subgraph_info_ subgraph_list_ sid_;
    $self instvar comm_obj_ id_

    foreach sid $subgraph_list_ {
	if {$subgraph_info_($sid,spec) == $new_subgraph} {
	    return;
	}
    }

    incr sid_;

    lappend subgraph_list_ $sid_;

    set subgraph_info_($sid_,spec) $new_subgraph;
    set subgraph_info_($sid_,comm_obj) [new GraphComm/ScCombToSubgraph $self $id_ $new_subgraph];


    # Map trigger commands from above.

    $subgraph_info_($sid_,comm_obj) send_map_command [list map_trigger_cmds [$comm_obj_ primary_addr] [$comm_obj_ primary_port] [$comm_obj_ primary_ttl]];

    # Map inputs up. Send input info down.

    $comm_obj_ send_map_command [list map_inputs [$subgraph_info_($sid_,comm_obj) primary_addr] [$subgraph_info_($sid_,comm_obj) primary_port] [$subgraph_info_($sid_,comm_obj) primary_ttl]];

    $comm_obj_ update_new_subgraph $subgraph_info_($sid_,comm_obj);

    # Map parameters up and down

    $subgraph_info_($sid_,comm_obj) send_map_command [list map_parameters [$comm_obj_ primary_addr] [$comm_obj_ primary_port] [$comm_obj_ primary_ttl]];

    $comm_obj_ send_map_command [list map_parameters [$subgraph_info_($sid_,comm_obj) primary_addr] [$subgraph_info_($sid_,comm_obj) primary_port] [$subgraph_info_($sid_,comm_obj) primary_ttl]];


    # Recalculate any existing divisions
    $self recalculate_division

}

ScSpatialCombiner instproc update_rate_trigger {oid period} {
    $self instvar comm_obj_;
    $self instvar rate_triggers_ rate_trigger_periods_;

    $comm_obj_ instvar input_names_ input_info_;

    if {[info exists rate_trigger_periods_($oid)]} {
	if {$period < $rate_trigger_periods_($oid)} {
	    return;
	}
    }

    foreach i $input_names_ {
	if {[info exists input_info_($i,trigger,cur_value)]} {
	    if {[lindex $input_info_($i,trigger,cur_value) 0] == "auto"} {
		if {[lindex $input_info_($i,trigger,cur_value) 1] == 1} {
		    if {$period > 0} {
			puts "Limiting trigger on $i to [expr 90000.0/$period] fps"

			if {[info exists rate_triggers_($oid)]} {
			    after cancel $rate_triggers_($oid);
			}

			$self instvar subgraph_list_ subgraph_info_;

			foreach s $subgraph_list_ {
			    set cobj $subgraph_info_($s,comm_obj);
			    $cobj set_input_attr $i trigger [list rate_limited 1 0 $period];
			}

#			set rate_triggers_($oid) [after 1000 "$self incr_rate_trigger $oid"]
#			set rate_trigger_periods_($oid) $period;
		    } else {
			puts "Turning trigger limits off"
			$self instvar subgraph_list_ subgraph_info_;

			foreach s $subgraph_list_ {
			    set cobj $subgraph_info_($s,comm_obj);
			    $cobj set_input_attr $i trigger [list auto 1];
			}

			if {[info exists rate_trigger_periods_($oid)]} {
			    unset rate_trigger_periods_($oid);
			}
		    }
		}
	    }
	}
    }
}

ScSpatialCombiner instproc incr_rate_trigger {oid} {
    $self instvar rate_triggers_ rate_trigger_periods_

    if {![info exists rate_triggers_($oid)]} {
	return;
    }
    unset rate_triggers_($oid);

    set period [expr int($rate_trigger_periods_($oid) * 0.9)];

    unset rate_trigger_periods_($oid);

    $self update_rate_trigger $oid $period;
}

ScSpatialCombiner instproc send_completion_token {} {
    $self instvar comm_obj_;

    $comm_obj_ send_trigger_command "trigger_completion_token";
}

ScSpatialCombiner instproc incr_hit_cntr {} {
    $self instvar hit_cntr_;
    incr hit_cntr_;
}

ScSpatialCombiner instproc incr_miss_cntr {} {
    $self instvar miss_cntr_;
    incr miss_cntr_;

    $self instvar subgraph_list_;

    if {[expr $miss_cntr_ % [llength $subgraph_list_]] == 0} {
	$self send_completion_token;
    }
}

ScSpatialCombiner instproc update_hitbased_rate_trigger {} {
    $self instvar hit_cntr_ miss_cntr_ cntr_reset_;
    $self instvar last_cntr_update_
    $self instvar subgraph_list_

    if {$cntr_reset_} {
	set last_cntr_update_ [clock clicks];
	set hit_cntr_ 0;
	set miss_cntr_ 0;
	set cntr_reset_ 0;
    } else {
	set now [clock clicks];
	set delta [expr $now - $last_cntr_update_];
	set hit_rate [expr ($hit_cntr_ * 1000000.0) / $delta];
	if {[llength $subgraph_list_] > 0} {
	    set miss_rate [expr ($miss_cntr_ * 1000000.0) / ([llength $subgraph_list_] * $delta)];
	} else {
	    set miss_rate [expr ($miss_cntr_ * 1000000.0) / ($delta)];
	}

	puts "Hit rate = $hit_rate ($hit_cntr_ / $delta); Miss rate = $miss_rate ($miss_cntr_ / ([llength $subgraph_list_] * $delta)); Combined rate = [expr $hit_rate + $miss_rate]";

	set hit_cntr_ 0;
	set miss_cntr_ 0;
	set last_cntr_update_ $now;

	if {[expr $hit_rate + $miss_rate] > 0.0} {
	    set new_rate [expr int(90000.0 / (1.1 * ($hit_rate + $miss_rate)))];
	} else {
	    set new_rate 0
	}

	$self instvar output_id_list_;
	foreach o $output_id_list_ {
	    $self update_rate_trigger $o $new_rate;
	}

    }
    after 1500 $self update_hitbased_rate_trigger
}

ScSpatialCombiner instproc del_subgraph {subgraph_to_del} {
    $self instvar subgraph_list_ subgraph_info_;

    set sid_to_del "";
    foreach s $subgraph_list_ {
	if {$subgraph_info_($s,spec) == $subgraph_to_del} {
	    set sid_to_del $s;
	    break;
	}
    }
    if {$sid_to_del == ""} return;

    delete $subgraph_info_($sid_to_del,comm_obj);
    unset subgraph_info_($sid_to_del,comm_obj);
    unset subgraph_info_($sid_to_del,spec);

    set idx [lsearch $subgraph_list_ $sid_to_del];
    set subgraph_list_ [lreplace $subgraph_list_ $idx $idx];

    $self recalculate_division;
}

ScSpatialCombiner instproc recalculate_division {} {
    $self instvar subgraph_list_;
    $self instvar subgraph_info_;
    $self instvar output_id_list_;

    set num_subgraph [llength $subgraph_list_];

    set x0 0.0
    set x1 1.0

    foreach s $subgraph_list_ {
	set idx [lsearch $subgraph_list_ $s];
	set comm_obj $subgraph_info_($s,comm_obj);

	set y0 [expr ($idx * 1.0) / ($num_subgraph * 1.0)];
	set y1 [expr ($idx * 1.0 + 1.0) / ($num_subgraph * 1.0)];

	foreach o $output_id_list_ {
	    $comm_obj set_output_attr $o geometry [list $x0 $y0 $x1 $y1];
	}
    }
}

ScSpatialCombiner instproc new_output {subgraph_comm o} {

    $self instvar output_id_list_ subgraph_list_
    $self instvar subgraph_info_ output_info_

    if {[lsearch $output_id_list_ $o] == -1} {
	lappend output_id_list_ $o;

	# Brand new output discovered.

	set spec [$self GenerateSpec];
	set spec_split [split $spec "/"];
	set addr [lindex $spec_split 0];
	set port [lindex $spec_split 1];

	set output_info_($o,combiner_obj) [new Module/Combine/Spatial/SC];
	set vagent_array_($addr,$port) [new ScSpatialCombinerVideoAgent $addr/$port $output_info_($o,combiner_obj)];
	set output_info_($o,vagent) $vagent_array_($addr,$port);
	set output_info_($o,in_spec) $addr/$port;
	set output_info_($o,out_vagent) "";

	set output_info_($o,sc_decoder) [new Module/VideoDecoder/SCToSemicompressed];
	set output_info_($o,sc_buffer) [new VidRep/Semicompressed];
	$output_info_($o,sc_decoder) set_frame_buffer $output_info_($o,sc_buffer);

	set output_info_($o,encoder) [new Module/VideoEncoder/SemicompressedToJPEG];
	set output_info_($o,bufferpool) [new BufferPool/RTP];
	$output_info_($o,encoder) buffer-pool $output_info_($o,bufferpool);
	$output_info_($o,encoder) mtu [$self get_option mtu];
	$output_info_($o,sc_decoder) set_callback "$self incr_hit_cntr; $output_info_($o,encoder) recv $output_info_($o,sc_buffer); $self send_completion_token"

	$output_info_($o,combiner_obj) target $output_info_($o,sc_decoder);

	# Reflect new output in our control session

	$self instvar comm_obj_;

	$comm_obj_ create_output $o;

	##### Testing only
	$output_info_($o,combiner_obj) off_synch_cmd "$self incr_miss_cntr";
	$self instvar test_mode_
	if {[lindex $test_mode_ 0] == "rate"} {
	    # Set up rate limiting trigger
	    $self update_hitbased_rate_trigger;
	}
    }

    $subgraph_comm create_output $o;
    $subgraph_comm create_output_attr $o spec;
    $subgraph_comm create_output_attr $o geometry;
    $subgraph_comm set_output_attr $o spec $output_info_($o,in_spec);

    foreach s $subgraph_list_ {
	if {$subgraph_info_($s,comm_obj) == $subgraph_comm} {
	    break;
	}
    }
    set idx [lindex $subgraph_list_ $s];
    set num_subgraph [llength $subgraph_list_];

    set x0 0.0;
    set x1 1.0;
    set y0 [expr ($idx * 1.0) / ($num_subgraph * 1.0)];
    set y1 [expr ($idx * 1.0 + 1.0) / ($num_subgraph * 1.0)];

    $subgraph_comm set_output_attr $o geometry [list $x0 $y0 $x1 $y1];
}

ScSpatialCombiner instproc set_output_spec {out_id spec} {
    $self instvar output_id_list_ output_info_

    if {[lsearch $output_id_list_ $out_id] == -1} {
	return;
    }

    set combiner_obj $output_info_($out_id,combiner_obj);

    set spec_split [split $spec "/"];

    set addr [lindex $spec_split 0];
    set port [lindex $spec_split 1];

    set output_info_($out_id,out_vagent) [new VideoAgent $self $addr/$port];
    $output_info_($out_id,out_vagent) local_bandwidth 30000000;

    $combiner_obj ssrc [$output_info_($out_id,out_vagent) get_local_srcid];
    $output_info_($out_id,bufferpool) srcid [$output_info_($out_id,out_vagent) get_local_srcid];
    [$output_info_($out_id,out_vagent) get_transmitter] set loopback_ 0
    $output_info_($out_id,encoder) target [$output_info_($out_id,out_vagent) get_transmitter];

    ##### Testing only
    $self instvar test_mode_
    if {[lindex $test_mode_ 1] != "xcode"} {
	$combiner_obj target [$output_info_($out_id,out_vagent) get_transmitter];
    }
}

ScSpatialCombiner instproc GenerateSpec {} {
    # OK, this is a REAL hack

    global spec_generator;

    if {![info exists spec_generator(init)]} {
	set spec_generator(init) 1;
	set spec_generator(b1) 224;
	set spec_generator(b2) 5;
	set spec_generator(b3) 9;
	set spec_generator(b4) 1;
	set spec_generator(port) 22334;
    }

    incr spec_generator(b4);

    return "$spec_generator(b1).$spec_generator(b2).$spec_generator(b3).$spec_generator(b4)/$spec_generator(port)/16";
}


Class GraphComm/ScSpatialCombiner -superclass GraphComm

GraphComm/ScSpatialCombiner instproc init {sc_combiner id addr port ttl} {
    $self next $id $addr $port $ttl;

    $self instvar sc_combiner_;

    set sc_combiner_ $sc_combiner;
}


GraphComm/ScSpatialCombiner instproc recv_misc {data} {
    $self next $data;

    $self instvar sc_combiner_;

    set cmd [lindex $data 0];

    switch -exact -- $cmd {
	add_subgraph {
	    $sc_combiner_ add_subgraph [lindex $data 1];
	}
	del_subgraph {
	    $sc_combiner_ del_subgraph [lindex $data 1];
	}
    }
}

GraphComm/ScSpatialCombiner instproc update_output_attr_value {output_name attr_name value} {
    $self next $output_name $attr_name $value;

    if {$attr_name == "spec"} {
	$self instvar sc_combiner_;

	$sc_combiner_ set_output_spec $output_name $value;
    }
}

GraphComm/ScSpatialCombiner instproc update_new_subgraph {subgraph_comm} {
    $self instvar input_info_ input_names_

    foreach i $input_names_ {
	$subgraph_comm create_input $i;
	foreach a $input_info_($i,attr_list) {
	    $subgraph_comm create_input_attr $i $a
	    if {[info exists input_info_($i,$a,cur_value)]} {
		$subgraph_comm set_input_attr $i $a $input_info_($i,$a,cur_value);
	    }
	}
    }
    $self instvar map_cmd_list_;
    if {[info exists map_cmd_list_]} {
	foreach cmd $map_cmd_list_ {
	    $subgraph_comm send_map_command $cmd;
	}
    }
}


GraphComm/ScSpatialCombiner instproc new_input {new_name} {
    $self instvar sc_combiner_

    $self next $new_name;

    $sc_combiner_ instvar subgraph_list_ subgraph_info_

    foreach s $subgraph_list_ {
	set comm_obj $subgraph_info_($s,comm_obj)
	$comm_obj create_input $new_name;
    }
}

GraphComm/ScSpatialCombiner instproc new_input_attribute {input_name attr_name} {
    $self instvar sc_combiner_

    $self next $input_name $attr_name

    $sc_combiner_ instvar subgraph_list_ subgraph_info_

    foreach s $subgraph_list_ {
	set comm_obj $subgraph_info_($s,comm_obj)
	$comm_obj create_input_attr $input_name $attr_name;
    }
}

GraphComm/ScSpatialCombiner instproc update_input_attr_value {input_name attr_name value} {
    $self instvar sc_combiner_

    $self next $input_name $attr_name $value

    $sc_combiner_ instvar subgraph_list_ subgraph_info_

    foreach s $subgraph_list_ {
	set comm_obj $subgraph_info_($s,comm_obj)
	$comm_obj set_input_attr $input_name $attr_name $value
    }
}

GraphComm/ScSpatialCombiner instproc recv_map_command {cmd} {
    $self instvar sc_combiner_ map_cmd_list_

    set type [lindex $cmd 0];
    set addr [lindex $cmd 1];
    set port [lindex $cmd 2];
    set ttl [lindex $cmd 3];

    switch -exact -- $type {
	map_trigger -
	map_triggers -
	map_parameter -
	map_parameters {
	    if {[info exists sc_combiner_]} {
		$sc_combiner_ instvar subgraph_list_ subgraph_info_

		foreach s $subgraph_list_ {
		    set comm_obj $subgraph_info_($s,comm_obj)
		    $comm_obj send_map_command $cmd;
		}
	    }
	    lappend map_cmd_list_ $cmd;
	}
	default {
	    $self next $cmd;
	}
    }
}



Class GraphComm/ScCombToSubgraph -superclass GraphComm

GraphComm/ScCombToSubgraph instproc init {sc_combiner id spec} {
    set spec [split $spec "/"];
    set addr [lindex $spec 0];
    set port [lindex $spec 1];
    set ttl [lindex $spec 2];

    $self next $id $addr $port $ttl;

    $self instvar sc_combiner_;

    set sc_combiner_ $sc_combiner;
}

GraphComm/ScCombToSubgraph instproc new_output {new_name} {
    $self next $new_name;

    $self instvar sc_combiner_;

    $sc_combiner_ new_output $self $new_name;
}


import VideoAgent

Class ScSpatialCombinerVideoAgent -superclass VideoAgent

ScSpatialCombinerVideoAgent instproc init {spec combiner} {
    eval $self next $self $spec;

    $self instvar combiner_;

    set combiner_ $combiner;
}

ScSpatialCombinerVideoAgent instproc create_decoder src {
    $self instvar combiner_;

    set d [$src handler];
    if {$d != ""} {
	delete $d;
    }

    return $combiner_;
}

ScSpatialCombinerVideoAgent instproc deactivate src {
    puts "$src has been deactivated!!!!";
}
