# ui-client.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1996-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/rvic-client/ui-client.tcl,v 1.20 2002/02/03 04:29:33 lim Exp $


#
# client for rvic
#
Class RvicClientUI


#
# constuctor takes <br>
# `w', a window to build itself in, and <br>
# `ctrladdrSpec', the address spec of the server to talk to.
#
RvicClientUI public init {w ctrladdrspec} {
	$self instvar al_ layouts_

	set origAddr $ctrladdrspec

	# if addrspec includes a name, turn it into IP addr
	set firstchar [string index $ctrladdrspec 0]
	if [string match \[a-zA-Z\] $firstchar] {
		set n [lindex [split $ctrladdrspec "/"] 0]
		set p [lindex [split $ctrladdrspec "/"] 1]
		set s [gethostbyname $n]
		if { $s == "" } {
			puts "cannot find address for '$n'..."
			return -1
		}
		set ctrladdrspec $s/$p
	}

	# create rvic's announce-listen manager object
	set al_ [new ALM/RvicClient $ctrladdrspec $self]

	# initialize with one layout -- 'Single' 1 full-screen vw
	set layouts_(Single) "1.0x1.0+0.0+0.0"

	$self build_gui $w $origAddr
}

#
RvicClientUI public destroy {} {
	$self instvar al_
	$al_ destroy
	eval [list $self] next
}

#
# builds the client gui in windows `w'.  `subtitle' is a
# string appended to the informational bottom label, ie,
# the address/port of the rvic server it is connected to.
#
RvicClientUI private build_gui {w subtitle} {
	$self instvar al_ status_ w_ numSrcs_ \
			currSrc_ numVWs_ layout_switching_ addrspec_
	set w_ $w
	set numSrcs_ 0
	set currSrc_ ""
	set numVWs_ 0
	set layout_switching_ off

	# build bottom informational label
	set il $w.infolabel
	frame $il -relief groove
	label $il.l -text "rvic client for  $subtitle"
	pack $il -side bottom -fill x -expand 1
	pack $il.l -in $il -side bottom

	# build frame for buttons representing video-windows
	frame $w.vws -width 320 -height 240 -relief groove
	pack $w.vws -side left

	# build middle src list panel
	frame $w.srcs -relief groove
	label $w.srcs.l -text "Sources:" -anchor w
	pack $w.srcs -side bottom
	pack $w.srcs.l -side top -fill x -expand 1

	# build layouts, switching. update, ... buttons/menubuttons
	set m $w.layouts.menu
	menubutton $w.layouts -text Layouts... -menu $m -relief raised
	menu $m -tearoff 0
	$m add command -label Single -command "$self set_layout Single"
	pack $w.layouts -side top -expand 1 -fill x

	button $w.refresh -text "Refresh" -command "$al_ request_full_update"
	pack $w.refresh -side top -expand 1 -fill x

	# the address label and switch button
	#frame $w.address
	#label $w.address.info -anchor w -text "Session: "
	#set addrspec_ $w.address.info

	#button $w.address.switch -text "Switch Address"\
	#		-command "$al_ switch_address 224.1.2.3/12345"
	#pack $w.address.info $w.address.switch -side top -fill x -expand 1
	#pack $w.address -side top -expand 1 -fill x

	#
	checkbutton $w.match -text "Match layout to \# srcs" \
			-variable [$self tkvarname match_srcs_button_state] \
			-command "$self invoke_match_srcs_button"
	pack $w.match -side top -expand 1 -fill x ; # -anchor w

	set m  $w.vswitch.menu
	menubutton $w.vswitch -text "Voice Switch..." -menu $m -relief raised
	menu $m -tearoff 0
	foreach ii {1 2 3 4 5 6 7 8 9} {
		$m add checkbutton -label "Voice-switch $ii" \
				-command "$self toggle_voice_switch $ii"
	}
	pack $w.vswitch -side right -expand 1

	set m  $w.tswitch.menu
	menubutton $w.tswitch -text "Timer Switch..." -menu $m -relief raised
	menu $m -tearoff 0
	foreach ii {1 2 3 4 5 6 7 8 9} {
		$m add checkbutton -label "Timer-switch $ii" -command \
		"$self toggle_timer_switch $ii"
	}
	pack $w.tswitch -side left -expand 1

	bind . <q> exit
	bind . <n> {}

	# setup timeout rate; request current state,
	# then start occasional re-querying
	set t [new Timer/Periodic 5000]
	$t randomize 1
	$al_ timer $t
	$al_ request_full_update
	$al_ start
}


# set local layout and then send update to the server
#
RvicClientUI public set_layout {layout} {
	$self instvar al_ currLayout_
	$self set_local_layout $layout
	$al_ announce "Set MonitorStyle $currLayout_"
	# grab vw-->cname mappings
	$al_ announce "Set VideoWindow"
}


# set current "layout" of buttons representing vwins to name in
# param 'layout'
#
RvicClientUI public set_local_layout {layout} {
	$self instvar layouts_ currLayout_

	set i [lsearch [array get layouts_] $layout]
	if {$i == -1} {
		puts "Bad layout name: $layout"
		return
	}
	set currLayout_ $layout
	$self update_layout $layouts_($currLayout_)
}

# move to "next" layout in the layout list and announce the change to
# the server
#
RvicClientUI public next_layout {} {
	$self instvar layouts_ currLayout_ al_

	if {![info exists currLayout_]} {
		set index 0
	} else {
		set l [array get layouts_]
		set index [lsearch $l $currLayout_]
		incr index 2
		if {$index >= [llength $l]} {
			set index 0
		}
	}
	set currLayout_ [lindex [array get layouts_] $index]
	#puts "currLayout = $currLayout_"
	$self update_layout $layouts_($currLayout_)
	$al_ announce "Set MonitorStyle $currLayout_"
}


#
# update the list of possible "layouts" of the buttons representing
# remote video windows.  `layoutsList' is expected to be a list
# of the form:<br>
# layoutName {WxH+X+Y [WxH+X+Y ...] } <br>
# layoutName2 {WxH+X+Y [WxH+X+Y ...] } <br>
# ...
#
RvicClientUI private update_layouts_list {layoutList} {
	$self instvar w_ layouts_ currLayout_

	$w_.layouts.menu delete 0 end
	foreach {name values} $layoutList {
		set layouts_($name) "$values"
		#puts "- $name -=- $values -"
		$w_.layouts.menu add command -label $name \
				-command "$self set_layout $name"
	}
	# if first update, set to first layout
	if {![info exists currLayout_]} {
		$self set_local_layout "[lindex $layoutList 0]"
		#puts "setting layout to [lindex $layoutList 0]"
	}
}


#
# update radio buttons src list to the strings in list srcNamesList
# <br> updates the numSrcs_ and currSrc_ instvars to match
#
RvicClientUI private update_src_list {srcNamesList} {
	$self instvar w_ numSrcs_ currSrc_

	set s $srcNamesList
	set fr $w_.srcs
	set newLen [llength $s]
	if {$srcNamesList == ""} {set newLen 0}

	# add/delete buttons to match number of srcs
	if {$numSrcs_ < $newLen} {
		for {set i [expr $numSrcs_+1]} {$i <= $newLen} {incr i} {
			radiobutton $fr.rb$i -variable srcs -value $i
		}
	} elseif {$numSrcs_ > $newLen} {
		for {set i [expr $newLen+1]} {$i <= $numSrcs_} {incr i} {
			destroy $fr.rb$i
		}
	}
	set numSrcs_ $newLen

	# update contents and pack 'em
	for {set i 1} {$i <= $numSrcs_} {incr i} {
		set l [lindex $s [expr $i-1]]
		$fr.rb$i configure -text "$l" \
				-command "$self set currSrc_ \"$l\""
		pack $fr.rb$i -in $fr -side top -anchor w -padx 4
	}

	if {[info exists currSrc_]} {
		set i [lsearch -exact $srcNamesList $currSrc_]
	} else {
		set i -1
	}
	if {$i != -1} {
		set currSrc_ [lindex $s $i]
		$fr.rb[expr $i+1] select
	} else {
		set currSrc_ [lindex $s 0]
		if {[info commands $fr.rb1] != ""} {$fr.rb1 select}
	}
}


#
# updates the src address label
#
RvicClientUI private update_src_address {address} {
	$self instvar w_ numSrcs_ currSrc_
	$self instvar addrspec_

	if ![info exists addrspec_] {
		return
	}
	$addrspec_ configure -text "Session: $address"
}


#
# update buttons representing video windows (a "layout") to list of
# 4-tuples passed in that each represent a button.  4-tuples include
# relative position in 0.0..1.0 (-xrel, -yrel) of frame representing
# the remote "full screen" and the height and width of the individual
# button, again each relative in 0.0..1.0 <br>
# ... thus, tuple = `HxW+X+Y', like a geometry string
#
RvicClientUI private update_layout {tupleList} {
	$self instvar numVWs_ w_

	#puts "update to tupleList: $tupleList"

	set t $tupleList
	set newLen [llength $t]
	set fr $w_.vws

	# add/delete buttons to match number of srcs
	if {$numVWs_ < $newLen} {
		for {set i [expr $numVWs_+1]} {$i <= $newLen} {incr i} {
			button $fr.b$i -command "$self hit_layout_button $i" -text $i
		}
	} elseif {$numVWs_ > $newLen} {
		for {set i [expr $newLen+1]} {$i <= $numVWs_} {incr i} {
			destroy $fr.b$i
		}
	}
	set numVWs_ $newLen

	# update size and place 'em
	for {set i 1} {$i <= $numVWs_} {incr i} {
		set geomList [split [lindex $tupleList [expr $i-1]] "+x"]
		foreach {w h x y} $geomList {
			place configure $fr.b$i \
					-relx $x -rely $y -relwidth $w -relheight $h
		}
	}
}

#
# user hits on layout button: sends message asking that the currently
# selected source (the radiobutton) be used as the new source for
# the video-window corresponding to the button.
#
RvicClientUI private hit_layout_button {num} {
	$self instvar currSrc_ al_

	$al_ announce "Set VideoWindow\n$num $currSrc_"
	$self set_button_label $num $currSrc_
}

#
# make button `num' have label `label'
#
RvicClientUI private set_button_label {num label} {
	$self instvar w_
	if {[string length $label] > 8} {
		set label "[string range $label 0 7]..."
	}
	if {[info commands $w_.vws.b$num] != ""} {
		$w_.vws.b$num configure -text "$label"
	}
}

# called when user toggles the "match layout to # srcs" button
RvicClientUI private invoke_match_srcs_button {} {
	$self instvar al_ layout_switching_
	$self tkvar match_srcs_button_state
	if $match_srcs_button_state {
		set state on
	} else {
		set state off
	}
	$al_ announce "Set Autoswitchlayout $state"
	set layout_switching_ $state
}


# either get the value of the layout_switching_ variable, or
# set the layout_switching_ variable by updating the
# "match layout to # srcs" checkbutton to match
RvicClientUI public set_layout_switching {{onoff ""}} {
	$self instvar layout_switching_ w_
	if {$onoff == ""} {
		return $layout_switching_
	} else {
		if {$layout_switching_ != $onoff} {
			$w_.match invoke
		}
	}
	if {$layout_switching_ != "on" && $layout_switching_ != "off"} {
		puts "Error: bad arg to set_layout_switching: $onoff"
	}
}

#
RvicClientUI private toggle_timer_switch {num} {
	$self instvar timer_onoff_ al_ no_announce_
	if {![info exists timer_onoff_($num)] || $timer_onoff_($num) == 0} {
		set timer_onoff_($num) 1
		set r "Set TimerSwitchList\n$num *"
	} else {
		set timer_onoff_($num) 0
		set r "Set TimerSwitchList\n$num"
	}
	if ![info exists no_announce_] {
		$al_ announce $r
	}
}

#
RvicClientUI private toggle_voice_switch {num} {
	$self instvar voice_onoff_ al_ no_announce_
	if {![info exists voice_onoff_($num)] || $voice_onoff_($num) == 0} {
		set voice_onoff_($num) 1
		set r "Set VoiceSwitchList\n$num *"
	} else {
		set voice_onoff_($num) 0
		set r "Set VoiceSwitchList\n$num"
	}
	if ![info exists no_announce_] {
		$al_ announce $r
	}
}

#
RvicClientUI public update_vs_checkbuttons {data} {
	$self instvar w_ voice_onoff_ no_announce_
	set no_announce_ 1
	# turn 'em all off
	foreach num {1 2 3 4 5 6 7 8 9} {
		if {[info exists voice_onoff_($num)] && $voice_onoff_($num) == 1} {
			$w_.vswitch.menu invoke [expr $num-1]
		}
	}
	# then turn on the notated ones
	set data [split $data "\n"]
	set data [lrange $data 1 end]
	foreach i $data {
		if {$i == ""} {continue}
		set num [lindex $i 0]
		$w_.vswitch.menu invoke [expr $num-1]
	}
	unset no_announce_
}

#
RvicClientUI public update_ts_checkbuttons {data} {
	$self instvar w_ timer_onoff_ no_announce_
	set no_announce_ 1
	# turn 'em all off
	foreach num {1 2 3 4 5 6 7 8 9} {
		if {[info exists timer_onoff_($num)] && $timer_onoff_($num) == 1} {
			$w_.tswitch.menu invoke [expr $num-1]
		}
	}
	# then turn on the notated ones
	set data [split $data "\n"]
	set data [lrange $data 1 end]
	foreach i $data {
		if {$i == ""} {continue}
		set num [lindex $i 0]
		$w_.tswitch.menu invoke [expr $num-1]
	}
	unset no_announce_
}

# ---- # ---- # ---- # ---- # ---- # ---- # ---- # ----
# ---- # ---- # ---- # ---- # ---- # ---- # ---- # ----

import AnnounceListenManager Timer/Periodic

#
# rvicClient message interface
#
Class ALM/RvicClient -superclass AnnounceListenManager

#
ALM/RvicClient public init {spec parent {mtu 1500}} {

	set port_ [lindex [split $spec "/"] 1]
	set addr "[lindex [split $spec "/"] 0]/"
	if {[string first / $spec] == -1} {
		set port_ $spec
		set addr ""
	}
	# addressblocks only allow even ports -- emulate this
	if {$port_ % 2 != 0} {
		puts "WARNING: you specified an odd port: decrementing 1"
		incr port_ -1
		set spec "$addr$port_"
	}

	eval [list $self] next $spec $mtu

	$self instvar parent_
	set parent_ $parent
}

#
# receive updates from rvic server
#
ALM/RvicClient private recv_announcement {addr port data size} {
	#puts "Msg: $addr/$port\[$size\]: [lrange $data 0 0]"
	$self instvar parent_

	if {[string first "MonitorStyleList" $data] ==0} {
		# this blows away the "\n"s
		set data [lrange $data 1 end]
		$parent_ update_layouts_list $data
	} elseif {[string first "SourceList" $data] ==0} {
		set data [split $data "\n"]
		set data [lrange $data 1 end]
		$parent_ update_src_list $data
	} elseif {[string first "MonitorStyle" $data] ==0} {
		set data [lrange $data 1 end]
		$parent_ set_local_layout $data
	} elseif {[string first "VideoWindow" $data] ==0} {
		set lines [split $data "\n"]
		set lines [lrange $lines 1 end]
		set counter 1
		foreach i $lines {
			$parent_ set_button_label $counter [lrange $i 1 end]
			incr counter
		}
	} elseif {[string first "Autoswitchlayout" $data] ==0} {
		$parent_ set_layout_switching [lindex $data 1]
	} elseif {[string first "VoiceSwitchList" $data] ==0} {
		$parent_ update_vs_checkbuttons $data
	} elseif {[string first "TimerSwitchList" $data] ==0} {
		$parent_ update_ts_checkbuttons $data
	} elseif {[string first "SessionAddress" $data] ==0} {
		set data [split $data "\n"]
		set data [lrange $data 1 end]
		$parent_ update_src_address $data
	} else {
		puts "Unknown msg from $addr/$port\[$size\]: $data"
	}
	#$parent_ refresh_ui
}

#
# alternates through all the state update messages
#
ALM/RvicClient private send_announcement {} {
	$self instvar whichMsg_ parent_

	if {![info exists whichMsg_]} {
		set whichMsg_ -1
	}
	incr whichMsg_ 1
	if {$whichMsg_ > 7} {set whichMsg_ 0}

	switch $whichMsg_ {
		0 {set msg "Get SourceList"}
		1 {set msg "Get MonitorStyleList"}
		2 {set msg "Set MonitorStyle"}
		3 {set msg "Set VideoWindow"}
		4 {set msg "Set Autoswitchlayout [$parent_ set_layout_switching]"}
		5 {set msg "Set TimerSwitchList"}
		6 {set msg "Set VoiceSwitchList"}
		7 {set msg "Get SessionAddress"}
	}
	$self announce $msg
}

#
# sends all messages necessary to update all state
#
ALM/RvicClient private request_full_update {} {
	set an "Get MonitorStyleList"
	append an "\nGet SourceList"
	append an "\nSet MonitorStyle"
	append an "\nSet VideoWindow"
	append an "\nSet Autoswitchlayout"
	append an "\nSet TimerSwitchList"
	append an "\nSet VoiceSwitchList"
	append an "\nGet SessionAddress"
	$self announce $an
}

#
# set remote vic's session address
#
ALM/RvicClient public switch_address {address} {
	set msg "Set SessionAddress $address"
	$self announce $msg
}



