# al-server-ssac.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/ssac/al-server-ssac.tcl,v 1.12 2002/02/03 04:30:10 lim Exp $


import AnnounceListenManager/AS/Service SSACServer

# Mars is the MASH Archive Service.  The Mars archive server runs on the
# AS1 active service framework, and uses the SSAC protocol for
# communication with clients (currently, the client application is
# called rover).  This class handles the announce/listen operation of
# SSAC.  The SSACServer class handles the usage of the protocol.
# <p> Status: alpha <p> Author: Angela Schuett

Class AnnounceListenManager/AS/Service/Mars -superclass AnnounceListenManager/AS/Service


# On receipt of the first announcement, create a SSACServer object, pass
# it the first SSAC message.  The SSAC protocol is carried in the SSD field
# of AS1 announcements.
AnnounceListenManager/AS/Service/Mars public init {argv} {

	$self instvar  ssac_ timemap_ lastseqno_ ssd_ serv_inst_

	#puts "***********************"
	#puts "$argv"
	#puts "***********************"

	set ssd [lindex $argv 0]
	set serv_inst_ [lindex $argv 1]
	set uniqport [lindex $argv 2]
	set megactrl [lindex $argv 4]

	$self next $self $megactrl 20000 $serv_inst_

	# Initialize agent-data

	set ssd_(filename) ""
	set ssd_(duration) ""
	set ssd_(sesslist) ""

	set lastseqno_ 0
	set ssac_ [new SSACServer $self $ssd $uniqport $megactrl]
}

#
AnnounceListenManager/AS/Service/Mars public service_name {} {
	return Mars
}



# Recv a message, check if it's for us, and check if the seqno has incremented
# If not, then it's a keep alive message, and we can ignore it.  If so, then
# pass the message in to the archive agent
AnnounceListenManager/AS/Service/Mars public recv_msg {atype aspec addr srv_name srv_loc srv_inst ssg_port ssd} {

	$self instvar ssac_  lastseqno_ serv_inst_

	if { $srv_name == "DEATH" } {
		puts stderr "Received death packet from $aspec at $addr - exiting."
		$self announce_death
		exit 0
	}
	$self next $atype $aspec $addr $srv_name $srv_loc $srv_inst $ssg_port $ssd

	if {$serv_inst_ != $srv_inst} {
		return
	}

	set seqno [lindex [split [lindex [split $ssd "\n"] 0]] 1]
	#puts "Seqno $seqno"
	if {$seqno > $lastseqno_} {
		$ssac_ recv_msg $ssd
	        # Since we know the agent has incremented the seqno,
	        # we incr the lastseqno as well.  Should prob get the
	        # new seqno from the agent instead.
	        incr seqno
		set lastseqno_ $seqno
	}


}

#
AnnounceListenManager/AS/Service/Mars public set_agent_data {newmsg} {

	$self instvar ssd_out_

	set ssd_out_ $newmsg

}

#
AnnounceListenManager/AS/Service/Mars public set_filename {filename} {
	$self instvar ssd_

	set ssd_(filename) $filename
}

#
AnnounceListenManager/AS/Service/Mars public set_duration {duration} {
	$self instvar ssd_

	set ssd_(duration) $duration
}

#
AnnounceListenManager/AS/Service/Mars public add_sessinfo {sessname sessaddr lsrcid} {
	$self instvar ssd_

	lappend ssd_(sesslist) $sessname

	set ssd_($sessname,Address) $sessaddr
	set ssd_($sessname,SrcIDs) $lsrcid
}

#
AnnounceListenManager/AS/Service/Mars public set_seqno {seqno} {
	$self instvar ssd_

	set ssd_(seqno) $seqno
}

# SSACServer sets the agent-data for the return messages
AnnounceListenManager/AS/Service/Mars public agent_data {} {
	$self instvar ssd_ ssac_

	set aa "Seqno $ssd_(seqno)"
	set a "PSID $ssd_(filename)"
	set c "Duration $ssd_(duration)"
	set cc "Current [$ssac_ get_mapping]"
	set d ""
	foreach sess $ssd_(sesslist) {
		set d "$d\nSName $sess\nAddress $ssd_($sess,Address) $ssd_($sess,SrcIDs)"
	}

	set response "$aa\n$a\n$c\n$cc$d\n"

#	puts "respone - $response"

	if {$ssd_(seqno) > 0 } {
		return $response
	} else {
		return ""
	}



}

