# ui-scroll.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/ui_tools/ui-scroll.tcl,v 1.13 2002/02/03 04:30:23 lim Exp $


WidgetClass ScrolledWidget -configspec {
	{ -scrollbar scrollbar Scrollbar {none} config_scroll cget_scroll }
}


ScrolledWidget instproc build_widget { path } {
	frame  $path.dummy -borderwidth 0 -relief flat
	set main [$self create_main_widget $path]
	scrollbar $path.vscroll -orient vertical
	scrollbar $path.hscroll -orient horizontal
	pack $path.dummy -side top -fill both -expand 1
	$self replace_main_widget $main
}


ScrolledWidget instproc replace_main_widget { widget } {
	$self instvar main_
	if { [info exists main_] } {
		if { $main_ == $widget } return
		catch { pack forget $main_ }
	}

	set main_ $widget

	set path [$self info path]
	$path.vscroll configure -command "$main_ yview"
	$path.hscroll configure -command "$main_ xview"
	$main_ configure -yscrollcommand "$path.vscroll set"
	$main_ configure -xscrollcommand "$path.hscroll set"

	pack $main_ -side left -anchor nw -fill both -expand 1 \
			-in $path.dummy
}


ScrolledWidget instproc create_main_widget { path } {
	error "cannot create object of class [$self info class];\
			every subclass MUST redefine the create_main_widget\
			method"
}


ScrolledWidget instproc config_scroll { option scroll } {
	$self instvar main_
	set path [$self info path]
	catch {
		pack forget $path.vscroll
		pack forget $path.hscroll
	}

	switch $scroll {
		horizontal {
			pack $path.hscroll -side bottom -fill x \
					-before $path.dummy
		}
		vertical {
			pack $path.vscroll -side right -fill y \
					-in $path.dummy -before $main_
		}
		both {
			pack $path.hscroll -side bottom -fill x \
					-before $path.dummy
			pack $path.vscroll -side right -fill y \
					-in $path.dummy -before $main_
		}
		auto {
			error "function not implemented"
		}
		default {
			set scroll none
		}
	}
	$self set scroll_ $scroll
}


ScrolledWidget instproc cget_scroll { option } {
	$self instvar scroll_
	if [info exists scroll_] { return $scroll_ } else { return none }
}







WidgetClass ScrolledCanvas -superclass ScrolledWidget

ScrolledCanvas instproc create_main_widget { path } {
	return [canvas $path.bbox]
}


WidgetClass ScrolledText -superclass ScrolledWidget

ScrolledText instproc create_main_widget { path } {
	return [text $path.text]
}


WidgetClass ScrolledWindow -superclass ScrolledCanvas


ScrolledWindow instproc build_widget { path } {
	$self next $path
	frame $path.bbox.window
	$path.bbox create window 0 0 -anchor nw -window $path.bbox.window
	$self set_subwidget window $path.bbox.window

	bind $path.bbox.window <Configure> "+$self ev_window_resize %w %h"
}


ScrolledWindow instproc ev_window_resize { width height } {
	[$self subwidget bbox] configure -scrollregion "0 0 $width $height"
}


WidgetClass ScrolledWindow/Expand -superclass ScrolledWindow


ScrolledWindow/Expand instproc build_widget { path } {
	$self next $path

	set dummy [frame [$self subwidget bbox].dummy_ -width 0 -height 0 \
			-relief flat -bg [[$self subwidget window] cget -bg]]
	pack $dummy -side top -in [$self subwidget window]
	bind [$self subwidget bbox] <Configure> "+$self ev_bbox_resize_ %w %h"
}


ScrolledWindow/Expand instproc ev_bbox_resize_ { w h } {
	set window [$self subwidget window]
	set bbox   [$self subwidget bbox]
	$bbox.dummy_ configure \
			-width [expr $w - ([$bbox cget -bd] + \
			[$window cget -bd] + [$bbox cget -highlightthickness] \
			+ [$window cget -highlightthickness]) * 2]
}


WidgetClass ScrolledWinMgr -superclass ScrolledCanvas


ScrolledWinMgr public add_window { path x y } {
	$self instvar windows_
	set bbox [$self subwidget bbox]
	if { [winfo parent $path] != $bbox } {
		error "$path is not a child of ScrolledWinMgr::holder"
	}

	set id [$bbox create window $x $y -anchor nw -window $path \
			-tags all_windows]
	set windows_($path) $id
	bind $path <Configure> "+$self recompute_scrollregion"
	$self recompute_scrollregion
}


ScrolledWinMgr public move_window { path x y } {
	$self instvar windows_
	set bbox [$self subwidget bbox]
	set current [$bbox coords $windows_($path)]
	set dx [expr $x - [lindex $current 0]]
	set dy [expr $y - [lindex $current 1]]
	$bbox move $windows_($path) $dx $dy
	raise $path
}


ScrolledWinMgr public remove_window { path } {
	$self instvar windows_
	set bbox [$self subwidget bbox]
	$bbox delete $windows_($path)
	unset windows_($path)
}

# return the name of the window that's supposed to hold all managed windows
# managed windows should be children of this window
ScrolledWinMgr public holder { } {
	return [$self subwidget bbox]
}


ScrolledWinMgr private recompute_scrollregion { } {
	set bbox [$self subwidget bbox]
	$bbox configure -scrollregion [$bbox bbox all_windows]
}
