# index2times.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

proc makegraph {filename} {

    if {$filename == "stdin"} {
	set fd "stdin"
    } else {
	if [catch {open $filename r} fd] {
	    puts stdout "Cannot open file $filename"
	    return 0
	}
    }

    while {[gets $fd line] >= 0} {
	set processLine 0
	if {!($line == "")} {
	    if {[isNumber $line]} {
		set processLine 1
	    }


	}

	if {$processLine} {
	    set sLine [split $line " "]
	    set index [lindex $sLine 0]
	    set val [lindex $sLine 1]

	    set ms [expr double($index) * 20.0]
	    set sec [expr $ms / 1000.0]

	    puts stdout "$sec $val"
	} else {
	    if {[isXLabel $line]} {
		puts stdout "XUnitText: seconds"
	    } else {
		puts stdout $line
	    }
	}

    }

    close $fd

    return 1
}

# returns 1 if it's a number, 0 otherwise
proc isNumber {str} {
    set firstChar [string index $str 0]
    switch -exact -- $firstChar {
	0 -
	1 -
	2 -
	3 -
	4 -
	5 -
	6 -
	7 -
	8 -
	9 {
	    return 1
	}
    }
    # all else return 0
    return 0
}

# returns 1 if it's an X label
proc isXLabel {str} {
    set firstChar [string index $str 0]
    switch -exact -- $firstChar {
	X {
	    set sLine [split $str ":"]
	    if {[lindex $sLine 0] == "XUnitText"} {
		return 1
	    }
	}
    }
    # all else return 0
    return 0
}

# main program

if {[llength $argv] != 1} {
    puts stdout "usage: range <filename>"
    exit
}
set filename [lindex $argv 0]

makegraph $filename

