/*
 * old2new.c --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 2000-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>

// global vars
FILE* datfile;
FILE* tsfile;
FILE* outfile;
struct DatInfo datInfo;
struct TsInfo tsInfo;

// dat file seqno
struct DatInfo
{
  u_int16_t seqno;
  int wraps;
};

// timestamp file seqno
struct TsInfo
{
  u_int16_t seqno;
  int wraps;
  int numPackets;
};

// Archive DAT file structs
struct FileHeader {
        char version[16];
        char protocol[8];
        char media[32];
        char cname[128];
        char name[128];

        u_int32_t start_sec;
        u_int32_t start_usec;
        u_int32_t end_sec;
        u_int32_t end_usec;

        u_int32_t privateLen;
};

struct RTPPrivateHdr {
	char email[128];
	char phone[64];
	char loc[256]; // geographical user location
	char tool[64]; // application or tool name
	u_int32_t scale;
	u_int32_t ssrc;
	u_int32_t ref_rtp;
	u_int32_t ref_tv_sec;
	u_int32_t ref_tv_usec;
};

struct RecordHdr {
	u_int len;
	u_char type;
	u_char d2;
};

struct rtphdr {
	u_int16_t rh_flags;	/* T:2 P:1 X:1 CC:4 M:1 PT:7 */
	u_int16_t rh_seqno;	/* sequence number */
	u_int32_t rh_ts;	/* media-specific time stamp */
	u_int32_t rh_ssrc;	/* synchronization src id */
	/* data sources follow per cc */
};

// old rtp timestamp formats
struct OldQMHeader
{
  int numPackets;
  char reserved[396];
};

struct OldQMPacketInfo
{
  u_int16_t seqno;
  int index;
  struct timeval sysTime;
};

// new rtp timestamp formats from qm-files.h
struct QMHeader
{
  int numPackets;
  int postProcessed;
  int firstTs;
  int lastTs;
  char reserved[384];
};

struct QMPacketInfo
{
  u_int16_t flags; // don't think I'll need this, but just in case, and
                   // keeps things word aligned
  u_int16_t seqno;
  u_int32_t ts;  // timestamp
  int index;
  struct timeval sysTime;
};

// function prototypes
void init();
void genOutfile();
int findDatEntry(u_int16_t seqno, int wraps, u_int16_t* flags, u_int32_t* ts);
int earlierInFile(u_int16_t seqno1, int wraps1, u_int16_t seqno2, int wraps2);

///////////////////////////////////////////////////

int main(int argc, char** argv)
{
  if(argc != 4)
  {
    printf("old2new <dat filename> <timestamp filename> <outfile>\n");
    exit(1);
  }

  datfile = fopen(argv[1], "r");
  tsfile = fopen(argv[2], "r");
  outfile = fopen(argv[3], "w");
  if(datfile == NULL || tsfile == NULL || outfile == NULL)
  {
    fprintf(stderr, "could not open files, exiting\n");
    return(-1);
  }

  init();

  genOutfile();

/*
  go = 1;
  while(go)
  {
    x = fread(&datFileRHdr, sizeof(struct RecordHdr), 1, datfile);
    if(x > 0)
    {
      len = ntohl(datFileRHdr.len);
      fread(buf, len, 1, datfile);
      rtpHdrPtr = (struct rtphdr*)buf;
      ts = ntohl(rtpHdrPtr->rh_ts);
      seqno = ntohs(rtpHdrPtr->rh_seqno);
      flags = ntohs(rtpHdrPtr->rh_flags);
      if(lastSeqno + 1 != seqno)
      {
	printf("missed packet, lastSeqno=%u, seqno=%u\n", lastSeqno, seqno);
      }
      lastSeqno = seqno;
//    if(seqno == 22000)
    }
    else
    {
      go = 0;
    }
  }
  */

  fclose(datfile);
  fclose(tsfile);
  fclose(outfile);

  return(0);
}

void init()
{
  struct FileHeader datHdr;
  struct RTPPrivateHdr datPHdr;

  struct OldQMHeader tsHdr;
  struct QMHeader outHdr;

  // dat file
  fread(&datHdr, sizeof(struct FileHeader), 1, datfile);
  if(sizeof(struct RTPPrivateHdr) != ntohl(datHdr.privateLen))
  {
    fprintf(stderr, "Warning, sizeof(struct RTPPrivateHdr)=%u != privateLen=%u\n",
	    sizeof(struct RTPPrivateHdr), ntohl(datHdr.privateLen));
    exit(0);
  }
  fread(&datPHdr, ntohl(datHdr.privateLen), 1, datfile);
  // we are now at the start of the data packets

  // old QM timestamp file
  fread(&tsHdr, sizeof(struct OldQMHeader), 1, tsfile);
  tsInfo.numPackets = tsHdr.numPackets;
  printf("numPackets = %d\n", tsHdr.numPackets);
  // we are now at the start of the info packets

  // prepare timestamp outfile
  outHdr.numPackets = tsInfo.numPackets;
  fwrite(&outHdr, sizeof(struct QMHeader), 1, outfile);

  datInfo.seqno = 0;
  datInfo.wraps = 0;
  tsInfo.seqno = 0;
  tsInfo.wraps = 0;

}

void genOutfile()
{
  int x;
  int success;
  int len;
  u_int16_t flags;
  u_int16_t seqno;
  u_int16_t lastSeqno = 0;
  u_int32_t ts;
  struct OldQMPacketInfo oldInfo;
  struct QMPacketInfo newInfo;
  struct QMHeader hdr;
  int newNumPackets = tsInfo.numPackets;
  // at this point, the timestamp file is pointing to the first OldQMPacketInfo
  //    the dat file is pointing at the first packet record

  for(x = 0; x < tsInfo.numPackets; ++x)
//  for(x = 0; x < 1765; ++x)
  {
    fread(&oldInfo, sizeof(struct OldQMPacketInfo), 1, tsfile);
//    printf("ts: seqno=%u\n", oldInfo.seqno);
//    printf("\tts: index=%d\n", oldInfo.index);
//    printf("\tts: sysTime=%lu %lu\n", oldInfo.sysTime.tv_sec, oldInfo.sysTime.tv_usec);
    if(lastSeqno > oldInfo.seqno)
    {
      // we've wrapped
      tsInfo.wraps++;
      printf("timestamps wrapped, seqno=%u, lastSeqno=%u, wraps=%d\n", oldInfo.seqno, lastSeqno, tsInfo.wraps);
    }
    lastSeqno = oldInfo.seqno;
    tsInfo.seqno = oldInfo.seqno;

    success = findDatEntry(tsInfo.seqno, tsInfo.wraps, &flags, &ts);
    if(success)
    {
//      printf("match for seqno=%d, wraps=%d\n", tsInfo.seqno, tsInfo.wraps);
      newInfo.flags = flags;
      newInfo.seqno = oldInfo.seqno;
      newInfo.ts = ts;
      newInfo.index = oldInfo.index;
      newInfo.sysTime = oldInfo.sysTime;

      fwrite(&newInfo, sizeof(struct QMPacketInfo), 1, outfile);
    }
    else
    {
      // there is no corresponding entry in the dat file, so we have to
      //    mark this guy to be filtered out later
      newInfo.index = -2;
      newNumPackets--;
//      printf("no match for seqno=%d, wraps=%d\n", tsInfo.seqno, tsInfo.wraps);
    }
  }
  // at this point, we've processed all of the old timestamp file and created
  //    a new timestamp file that only has packets that are represented in
  //    the archive

  printf("newNumPackets=%d\n", newNumPackets);

  hdr.numPackets = newNumPackets;
  hdr.postProcessed = 0;
  fseek(outfile, 0, SEEK_SET);
  fwrite(&hdr, sizeof(struct QMHeader), 1, outfile);
}

// returns 1 if successful, 0 if failed
int findDatEntry(u_int16_t seqno, int wraps, u_int16_t* flagsPtr, u_int32_t* tsPtr)
{
  static char buf[2048];
  int success;
  int len;
  u_int16_t tempSeqno;
  u_int16_t tempFlags;
  u_int32_t ts;
  struct RecordHdr rHdr;

  struct rtphdr* rtpHdrPtr;

  while(earlierInFile(datInfo.seqno, datInfo.wraps, seqno, wraps))
  {
    // keep reading in dat records
    success = fread(&rHdr, sizeof(struct RecordHdr), 1, datfile);
    if(success > 0)
    {
      len = ntohl(rHdr.len);
      fread(buf, len, 1, datfile);
      rtpHdrPtr = (struct rtphdr*)buf;
      ts = ntohl(rtpHdrPtr->rh_ts);
      tempSeqno = ntohs(rtpHdrPtr->rh_seqno);
      tempFlags = ntohs(rtpHdrPtr->rh_flags);

      if(datInfo.seqno > tempSeqno)
      {
	datInfo.wraps++;
	printf("dat wrapped, seqno=%u, lastSeqno=%u, wraps=%d\n", tempSeqno, datInfo.seqno, datInfo.wraps);
      }

      datInfo.seqno = tempSeqno;
      *flagsPtr = tempFlags;
      *tsPtr = ts;
//      printf("datInfo.seqno=%u\n", datInfo.seqno);
    }
    else
    {
      // we must have reached the end of file => always fail
      return(0);
    }

  }
  // we've either found it or the next seqno is too big
  if(datInfo.seqno == seqno && datInfo.wraps == wraps)
  {
    // we've found it
//    printf("found match for seqno=%u, wraps=%d\n", seqno, wraps);

    return(1);
  }
  // if we got here, there must not be an entry in the dat file
  return(0);
}

// returns 1 if 1 is earlier than 2, 0 otherwise
int earlierInFile(u_int16_t seqno1, int wraps1, u_int16_t seqno2, int wraps2)
{
  if(wraps2 > wraps1)
  {
    return(1);
  }
  if(wraps1 > wraps2)
  {
    return(0);
  }
  if((seqno1 < seqno2) && (wraps1 == wraps2))
  {
    return(1);
  }
  return(0);
}
