/*
 * tgmb-canv.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <Pilot.h>
#include "tgmb-canv.h"
#include "tgmb-app.h"


#define SCROLL_ARROW_LEN   3
#define SCROLL_ARROW_WIDTH 5


static Word cross[] = {
	0x0008, 0x0008, 0x0002, 0x0000,	0x0000, 0x0000, 0x0000, 0x0000,
	0xC300, 0xE700, 0x7E00, 0x3C00,	0x3C00, 0x7E00, 0xE700, 0xC300 };
//	0xC100, 0x6300, 0x3600, 0x1C00,	0x3800, 0x6C00, 0xC600, 0x8300 };
static Word check[] = {
	0x0008, 0x0008, 0x0002, 0x0000,	0x0000, 0x0000, 0x0000, 0x0000,
	0x0300, 0x0700, 0x0E00, 0xDC00,	0xF800, 0x7000, 0x2000, 0x0000 };


void
TGMB_Canvas::Refresh()
{
	scrollbar_.Draw();
	DrawCheckCross(isCheck_);
	TGMB_Application::Instance()->Book()->Refresh();
}


#define SCROLLRES 40
inline void TGMB_Canvas::MoveUp()    { APP->Book()->Scroll(0, -SCROLLRES); }
inline void TGMB_Canvas::MoveDown()  { APP->Book()->Scroll(0, SCROLLRES);  }
inline void TGMB_Canvas::MoveLeft()  { APP->Book()->Scroll(-SCROLLRES, 0); }
inline void TGMB_Canvas::MoveRight() { APP->Book()->Scroll(SCROLLRES, 0);  }


void
TGMB_Canvas::ScreenRect(AbsRectType *bbox)
{
	bbox->left   = 1;
	bbox->top    = 1;
	bbox->right  = 152;
	bbox->bottom = 141;
}


Boolean
TGMB_Canvas::HandleEvent(EventPtr e)
{
	if (inCanv_ && scrollbar_.HandleEvent(e)) return true;
	AbsRectType bbox;

	switch (e->eType) {
	case frmOpenEvent:
		DrawCheckCross(0);
		// fall thru
	case frmUpdateEvent:
		scrollbar_.Draw();
		// return false, so the default routine can do its own thing
		return false;

	case winEnterEvent:
		/* Refresh the screen if necessary */
		if (e->data.winEnter.enterWindow==
		    FrmGetWindowHandle(FrmGetActiveForm())) {
			if (e->data.winEnter.enterWindow !=
			    e->data.winEnter.exitWindow)
				TG_AddUsrEventToQueue(usrRefreshScreen,NULL,0);
			else inCanv_ = true;
		}
		break;

	case winExitEvent:
		if (e->data.winExit.exitWindow==
		    FrmGetWindowHandle(FrmGetActiveForm())) inCanv_ = false;
		break;

	case penDownEvent:
		if (!inCanv_) break;
		ScreenRect(&bbox);
		if (TGMB_Application::Instance()->Book()->Command()->
		    Start(e->screenX, e->screenY, &bbox))
			return true;
		break;

	case penMoveEvent:
		if (!inCanv_) break;
		ScreenRect(&bbox);
		if (TGMB_Application::Instance()->Book()->Command()->
		    Move(e->screenX, e->screenY, &bbox))
			return true;
		break;

	case penUpEvent:
		if (!inCanv_) break;
		ScreenRect(&bbox);
		if (TGMB_Application::Instance()->Book()->Command()->
		    End(e->screenX, e->screenY, &bbox))
			return true;
		break;

	case keyDownEvent:
		if (!inCanv_) break;
		ScreenRect(&bbox);
		if (TGMB_Application::Instance()->Book()->Command()->
		    KeyPress(e->data.keyDown.chr, &bbox))
			return true;
		break;

	case usrRefreshScreen:
		Refresh();
		inCanv_ = true;
		return true;

	case usrNewPage:
		TGMB_Application::Instance()->Book()->CreateNewPage();
		return true;

	default:
		break;
	}

	return false;
}


void
TGMB_Canvas::DrawCheckCross(Boolean isCheck)
{
	isCheck_ = isCheck;
	WinHandle oldWindow = WinGetDrawWindow();
	WinSetDrawWindow(oneBitWindow_);
	WinDrawBitmap((BitmapPtr)(isCheck ? check : cross), 149, 149);
	WinSetDrawWindow(oldWindow);
}


TGMB_Scrollbar::TGMB_Scrollbar(TGMB_Canvas *c) : canv_(c)
{
	TGMB_Canvas::ScreenRect(&bbox_);
	highlightedArrow_ = sbNone;
}


void
TGMB_Scrollbar::Draw(SB_Arrow which, Boolean highlight)
{
	short x1, x2, y1, y2;
	Win2_Context cxt;

	cxt.window = Win2_GetOnscreenWindow();
	cxt.outlineClr = (highlight ? 0x00 : 0x80);
	cxt.fillClr    = 0x80;
	cxt.fill       = 1;
	cxt.width      = 1;

	x1 = bbox_.right + 3;
	y1 = bbox_.top;
	y2 = bbox_.bottom;
	// draw the top arrow
	if (which==sbAll || which==sbTop) {
		Win2_DrawLine(&cxt, x1, y1, x1+1, y1);
		Win2_DrawLine(&cxt, x1-1, y1+1, x1+2, y1+1);
		Win2_DrawLine(&cxt, x1-2, y1+2, x1+3, y1+2);
	}

	// draw the bottom arrow
	if (which==sbAll || which==sbBottom) {
		Win2_DrawLine(&cxt, x1, y2, x1+1, y2);
		Win2_DrawLine(&cxt, x1-1, y2-1, x1+2, y2-1);
		Win2_DrawLine(&cxt, x1-2, y2-2, x1+3, y2-2);
	}

	// draw the vertical line
	cxt.width = 0;
	if (which==sbAll) Win2_DrawRectangle(&cxt, x1, y1+3, x1+1, y2-3);

	cxt.width = 1;
	x1 = bbox_.left;
	x2 = bbox_.right;
	y1 = bbox_.bottom + 3;

	// draw the left arrow
	if (which==sbAll || which==sbLeft) {
		Win2_DrawLine(&cxt, x1, y1, x1, y1+1);
		Win2_DrawLine(&cxt, x1+1, y1-1, x1+1, y1+2);
		Win2_DrawLine(&cxt, x1+2, y1-2, x1+2, y1+3);
	}

	// draw the right arrow
	if (which==sbAll || which==sbRight) {
		Win2_DrawLine(&cxt, x2, y1, x2, y1+1);
		Win2_DrawLine(&cxt, x2-1, y1-1, x2-1, y1+2);
		Win2_DrawLine(&cxt, x2-2, y1-2, x2-2, y1+3);
	}

	// draw the horizontal line
	cxt.width = 0;
	if (which==sbAll) {
		Win2_DrawRectangle(&cxt, x1+3, y1, x2-3, y1+1);
		highlightedArrow_ = sbNone;
	} else {
		highlightedArrow_ = (highlight ? which : sbNone);
	}
}


Boolean
TGMB_Scrollbar::HandleEvent(EventPtr e)
{
	int x1, x2, y1, y2;
	switch (e->eType) {
	case penDownEvent:
		// check if we are in the vscroll or hscroll area
		x1 = bbox_.right+1;
		x2 = x1 + SCROLL_ARROW_WIDTH;
		if (e->screenX >= x1 && e->screenX <= x2) {
			// we are in the vscroll area
			y1 = bbox_.top;
			y2 = bbox_.bottom;

			if (e->screenY >= y1 &&
			    e->screenY <= y1+SCROLL_ARROW_LEN) {
				Draw(sbTop, 1);
				canv_->MoveUp();
				return true;
			}

			if (e->screenY >= y2-SCROLL_ARROW_LEN &&
			    e->screenY <= y2) {
				Draw(sbBottom, 1);
				canv_->MoveDown();
				return true;
			}

			return false;
		}

		y1 = bbox_.bottom+1;
		y2 = y1 + SCROLL_ARROW_WIDTH;
		if (e->screenY >= y1 && e->screenY <= y2) {
			// we are in the hscroll area
			x1 = bbox_.left;
			x2 = bbox_.right;

			if (e->screenX >= x1 &&
			    e->screenX <= x1+SCROLL_ARROW_LEN) {
				Draw(sbLeft, 1);
				canv_->MoveLeft();
				return true;
			}

			if (e->screenX >= x2-SCROLL_ARROW_LEN &&
			    e->screenX <= x2) {
				Draw(sbRight, 1);
				canv_->MoveRight();
				return true;
			}

			return false;
		}

		break;

	case penUpEvent:
		if (highlightedArrow_!=sbNone) Draw(highlightedArrow_, 0);
		break;

	default:
		return false;
	}

	return false;
}
