/*
 * tgmb-conn.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tgmb/gateway/tgmb-conn.h,v 1.5 2002/02/03 04:18:21 lim Exp $
 */

#ifndef MASH_TGMB_CONN_H
#define MASH_TGMB_CONN_H


#include "tclcl.h"
#include "all-types.h"
#include "misc/linkedlist.h"
#include "mb/mb.h"
#include "mb/mb-items.h"
#include "tgmb-enum.h"
#include "tgmb-chunk.h"
#include "errno.h"


class TGMB_Canvas;
class TGMB_LocalRcvr;
class ChunkFrag;
class Page;


#define sizeof_WingmanHdr 20

struct WingmanHdr {
	u_int32_t version;      /* Protocol version */
	u_int32_t requestId;    /* The request id */
	u_int32_t metadataSize; /* How much metadata has been sent */
	u_int32_t dataSize;     /* How much data has been sent */
	u_int32_t comp;         /* compression (unused) */
};


struct Chunk {
	Chunk() { memset(this, 0, sizeof(Chunk)); }
	~Chunk(){
		if (data) delete [] data;
		if (metadata) delete [] metadata;
	}
	Bool search_metadata(u_int16_t name, void *&value, u_int16_t &len) {
		return search(metadata, hdr.metadataSize, name, value, len);
	}

	static Bool search(void *data, u_int32_t dlen, u_int16_t name,
			   void *&value, u_int16_t &len);

	WingmanHdr hdr;
	u_char     *data, *metadata;
};


enum TGMB_ChannelState {
	connReadingHdr=1,
	connReadingMetadata,
	connReadingData
};


struct TGMB_ClientStatus {
	TGMB_ClientStatus()
		: zoomFactor_(0) { };
	Bool IsInitialized() {
		return Bool(zoomFactor_!=0);
	}

	u_int32_t zoomFactor_;
	PageId    currPgId_;
};


class TCP_MediaPad : public TclObject {
public:
	TCP_MediaPad();
	~TCP_MediaPad();

	void recv_chunk(Chunk *chunk);
	Bool send_data(TGMB_Canvas *pCanvas);
	int  send_data(int argc, const char *const* argv);
	int  readable(int argc, const char *const* argv);
	int  set_socket(int argc, const char *const* argv);
	void send_ctl_chunk(Chunk *chunk, void *data, u_int16_t len);

	inline Bool send_chunk(Chunk *chunk) {
		chunk->hdr.requestId = currRequestId_;
		if (send(chunk) != int(sizeof_WingmanHdr  +
				       chunk->hdr.dataSize +
				       chunk->hdr.metadataSize))
			return FALSE;
		else
			return TRUE;
	}

	int handshake(int argc, const char * const *argv);
	int zoom_factor(int argc, const char *const *argv);
	const PageId &curr_pgid() { return status_.currPgId_; }
	inline u_int32_t zoom_factor() { return status_.zoomFactor_; }

	static int send_newpage(int argc, const char * const *argv);
	static int send_srcname(int argc, const char * const *argv);
	static int send_data_to_everyone(int argc, const char * const *argv);
	static int send_data_to_everyone(TGMB_Canvas *pCanv);

private:
	void reset() {
		sock_ = -1;
		nextRequest_ = 1;
		state_ = connReadingHdr;
		readSoFar_ = 0;
		chunk_ = NULL;
	}

	int send(Chunk *chunk);

	int send(const u_char* buf, int len);
	int send_all(const u_char* buf, int len);
	int recv(u_char* buf, int len);
	void recv();
	Bool CreateNewChunk(Chunk *&chunk, u_char *hdrBuf);
	inline void Error();
	inline void NotifyChunkReceived();

	int sock_;
	// sending stuff
	u_int32_t         nextRequest_;

	// receiving stuff
	u_char            recvHdrBuf_[sizeof_WingmanHdr];
	Chunk             *chunk_;
	TGMB_ChannelState state_;
	u_int32_t         readSoFar_;

	static void alloc_srcname_pkt(u_char *&pkt, u_int16_t &len,
				      const SrcId &sid,
				      const char *name);
	static Bool send_ctl_to_everyone(const SrcId &dontSendToSid,
					 ChunkFragDescr descr,
					 void *data, u_int16_t len);
	static void construct_chunk(Chunk *chunk, u_int16_t contentType);

	Tcl_HashEntry *FindLastCanvCmdSent(TGMB_Canvas *pCanv);

	void recv_ctl(u_char *data, u_int32_t len);
	void recv_clientstatus(u_char *data, u_int16_t len);
	void recv_srcname(u_char *data, u_int16_t len);
	void recv_newpage(u_char *ptr, u_int16_t len);
	void recv_resendimage(u_char *ptr, u_int16_t len);

	void recv_data(u_int32_t requestId, u_char *data, u_int32_t len);


	void create_item(ChunkFrag *frag, Page *pPage);
	void create_line(ChunkFrag *frag, Page *pPage,
			 void *pCoords, u_int16_t numCoords,
			 u_int32_t timestamp);
	void create_text(ChunkFrag *frag, Page *pPage,
			 void *pCoords, u_int16_t numCoords,
			 u_int32_t timestamp);
	void create_poly(ChunkFrag *frag, Page *pPage,
			 void *pCoords, u_int16_t numCoords,
			 u_int32_t timestamp, u_int16_t itemType);
	u_int32_t create_item(Page *pPage, PageItem *pItem,
			      u_int32_t timestamp);
	u_int32_t create_char_cmd(Page *pPage, char ch, u_int32_t cmdId,
				  u_int16_t index, u_int32_t timestamp);
	u_int32_t create_group(Page* pPage, PageItemType type,
			       u_long snStart, u_long snEnd,
			       u_int32_t timestamp);
	void create_page(const PageId &pgId);


	Tcl_HashTable htLastCanvCmdSent_;
	TGMB_ClientStatus status_;
	u_int32_t currRequestId_;
	TGMB_LocalRcvr *pRcvr_;

	static List<TCP_MediaPad> allConnections_;
};


inline void
TCP_MediaPad::Error() {
	Invoke("chunk_error", NULL);
	return;
}


inline void
TCP_MediaPad::NotifyChunkReceived() {
	recv_chunk(chunk_);
	delete chunk_;
	chunk_ = NULL;
}


inline
Bool Str2SrcId(const char *str, SrcId &srcId) {
	int retval;
	retval = sscanf(str, "%lx@%lx", (unsigned long*)&srcId.ss_uid,
			(unsigned long*)&srcId.ss_addr);
	if (retval!=2) {
		return FALSE;
	} else {
		return TRUE;
	}
}



#endif /* #ifdef MASH_TGMB_CONN_H */
