/*
 * pktbuf.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1993-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

static const char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/srmv2/net/pktbuf.cc,v 1.10 2002/02/03 03:03:19 lim Exp $ (LBL)";

#include "pktbuf.h"
#include "srmv2.h"
#include "pktbuf-srmv2.h"

SRMv2_BufferPool_::SRMv2_BufferPool_() : freebufs_(0), nbufs_(0)
{
}

SRMv2_pktbuf* SRMv2_BufferPool_::alloc(unsigned char /* type */)
{
	SRMv2_pktbuf* pb = freebufs_;
	if (pb != 0)
		freebufs_ = pb->next;
	else {
		/*FIXME grow exponentially*/
		pb = new SRMv2_pktbuf;
		pb->manager = this;
		++nbufs_;
	}
	pb->len = 0;
	pb->offset = 0; 
	pb->dp = pb->data;
	return (pb);
}

void SRMv2_BufferPool_::release(SRMv2_pktbuf* pb)
{
	pb->next  = freebufs_;
	freebufs_ = pb;
}

SRMv2_pktbuf* SRMv2_pktbuf::copy(u_char type)
{
	SRMv2_pktbuf* cp;
	cp = ((SRMv2_BufferPool *)manager)->alloc(type);
	memcpy(cp->dp, dp, len);
	cp->len += len;
	cp->offset = offset;
	return (cp);
}
